/*
 * Copyright (C) 1997-2008 Alacritech, Inc. All rights reserved
 *
 * sxgphycode.h:
 *
 * This file PHY microcode and register initialization data.
 */

/**********************************************************************
 * PHY Microcode
 *
 * The following contains both PHY microcode and PHY register
 * initialization data.  It is specific to both the PHY and the
 * type of transceiver.
 *
 **********************************************************************/

/*
 * Download for AEL2005C PHY with SR/LR transceiver (10GBASE-SR or 10GBASE-LR)
 */
static struct PHY_UCODE PhyUcode[] = {
	/*
	 * NOTE:  An address of 0 is a special case.  When the download routine
	 * sees an address of 0, it does not write to the PHY.  Instead, it
	 * delays the download.  The length of the delay (in ms) is given in
	 * the data field.
	 *
	 * Delays are required at certain points.
	 */

	/*
	 * Platform-specific MDIO Patches:
	 * (include patches for 10G RX polarity flip, 50Mhz Synth, etc)
	 */
	/* Addr, Data */
	{0xc017, 0xfeb0},	/* flip RX_LOS polarity (mandatory */
	/*  patch for SFP+ applications) */
	{0xC001, 0x0428},	/* flip RX serial polarity */

	{0xc013, 0xf341},	/* invert lxmit clock (mandatory patch) */
	{0xc210, 0x8000},	/* reset datapath (mandatory patch) */
	{0xc210, 0x8100},	/* reset datapath (mandatory patch) */
	{0xc210, 0x8000},	/* reset datapath (mandatory patch) */
	{0xc210, 0x0000},	/* reset datapath (mandatory patch) */
	{0x0000, 0x0032},	/* wait for 50ms for datapath reset to */
	/* complete. (mandatory patch) */

	/* Configure the LED's */
	{0xc214, 0x0099},	/* configure the LED drivers */
	{0xc216, 0x5f5f},	/* configure the Activity LED */
	{0xc217, 0x33ff},	/* configure the Link LED */

	/* Transceiver-specific MDIO Patches: */
	{0xc010, 0x448a},	/* (bit 14) mask out high BER input from the */
	/* LOS signal in 1.000A */
	/* (mandatory patch for SR code) */
	{0xc003, 0x0181},	/* (bit 7) enable the CDR inc setting in */
	/* 1.C005 (mandatory patch for SR code) */

	/* Transceiver-specific Microcontroller Initialization: */
	{0xc04a, 0x5200},	/* activate microcontroller and pause */
	{0x0000, 0x0032},	/* wait 50ms for microcontroller before */
	/* writing in code. */

	/* code block starts here: */
	{/*(DEBLOBBED)*/},
	/* end of code block */

	/* Unpause the microcontroller to start program */
	{0xca00, 0x0080},
	{0xca12, 0x0000},
	{0x0000, 0x000A},	/* wait 10ms just to be safe */
	{0xffff, 0xffff}	/* table terminator */
};
