#ifndef _ASM_X86_SPEC_CTRL_H
#define _ASM_X86_SPEC_CTRL_H

#include <linux/stringify.h>
#include <asm/msr-index.h>
#include <asm/cpufeature.h>
#include <asm/alternative-asm.h>

#ifdef __ASSEMBLY__

.extern ibrs_enabled
.extern x86_spec_ctrl_base

#define _SPEC_CTRL_IBRS (1 << SPEC_CTRL_IBRS_SHIFT)

#define __ASM_ENABLE_IBRS			\
	pushq %rax;				\
	pushq %rcx;				\
	pushq %rdx;				\
	movl $MSR_IA32_SPEC_CTRL, %ecx;		\
	movq x86_spec_ctrl_base, %rdx;		\
	shr $32, %rdx;				\
	movq x86_spec_ctrl_base, %rax;		\
	orl $_SPEC_CTRL_IBRS, %eax;		\
	wrmsr;					\
	popq %rdx;				\
	popq %rcx;				\
	popq %rax

#define __ASM_ENABLE_IBRS_CLOBBER		\
	movl $MSR_IA32_SPEC_CTRL, %ecx;		\
	movq x86_spec_ctrl_base, %rdx;		\
	shr $32, %rdx;				\
	movq x86_spec_ctrl_base, %rax;		\
	orl $_SPEC_CTRL_IBRS, %eax;		\
	wrmsr;

#define __ASM_DISABLE_IBRS			\
	pushq %rax;				\
	pushq %rcx;				\
	pushq %rdx;				\
	movl $MSR_IA32_SPEC_CTRL, %ecx;		\
	movq x86_spec_ctrl_base, %rdx;		\
	shr $32, %rdx;				\
	movq x86_spec_ctrl_base, %rax;		\
	wrmsr;					\
	popq %rdx;				\
	popq %rcx;				\
	popq %rax

#define __ASM_STUFF_RSB				\
	call	1f;				\
	pause;					\
1:	call	2f;				\
	pause;					\
2:	call	3f;				\
	pause;					\
3:	call	4f;				\
	pause;					\
4:	call	5f;				\
	pause;					\
5:	call	6f;				\
	pause;					\
6:	call	7f;				\
	pause;					\
7:	call	8f;				\
	pause;					\
8:	call	9f;				\
	pause;					\
9:	call	10f;				\
	pause;					\
10:	call	11f;				\
	pause;					\
11:	call	12f;				\
	pause;					\
12:	call	13f;				\
	pause;					\
13:	call	14f;				\
	pause;					\
14:	call	15f;				\
	pause;					\
15:	call	16f;				\
	pause;					\
16:	call	17f;				\
	pause;					\
17:	call	18f;				\
	pause;					\
18:	call	19f;				\
	pause;					\
19:	call	20f;				\
	pause;					\
20:	call	21f;				\
	pause;					\
21:	call	22f;				\
	pause;					\
22:	call	23f;				\
	pause;					\
23:	call	24f;				\
	pause;					\
24:	call	25f;				\
	pause;					\
25:	call	26f;				\
	pause;					\
26:	call	27f;				\
	pause;					\
27:	call	28f;				\
	pause;					\
28:	call	29f;				\
	pause;					\
29:	call	30f;				\
	pause;					\
30:	call	31f;				\
	pause;					\
31:	call	32f;				\
	pause;					\
32:						\
	add $(32*8), %rsp

.macro ENABLE_IBRS
	testl	$1, ibrs_enabled
	jz	50f
	__ASM_ENABLE_IBRS
	jmp 55f
50:
	lfence
55:
.endm

.macro ENABLE_IBRS_CLOBBER
	testl	$1, ibrs_enabled
	jz	60f
	__ASM_ENABLE_IBRS_CLOBBER
	jmp 65f
60:
	lfence
65:
.endm

.macro DISABLE_IBRS
	testl	$1, ibrs_enabled
	jz	70f
	__ASM_DISABLE_IBRS
70:
.endm

.macro STUFF_RSB
ALTERNATIVE __stringify(__ASM_STUFF_RSB), "", X86_FEATURE_SMEP
.endm

#endif /* __ASSEMBLY__ */
#endif /* _ASM_X86_SPEC_CTRL_H */
