# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###





import gtk
import gobject
import pango


class TextColumn(gtk.TreeViewColumn):
    title = ""
    tag = ""
    def __init__(self,ncol):
        r = gtk.CellRendererText()
        #r.set_property("ellipsize",pango.ELLIPSIZE_END)
        super(TextColumn,self).__init__(self.title,r,text=ncol)
        self.set_resizable(True)

class EllipsizeTextColumn(gtk.TreeViewColumn):
    title = ""
    tag = ""
    def __init__(self,ncol):
        r = gtk.CellRendererText()
        r.set_property("ellipsize",pango.ELLIPSIZE_END)
        super(EllipsizeTextColumn,self).__init__(self.title,r,text=ncol)
        self.set_resizable(True)

class ExpandTextColumn(gtk.TreeViewColumn):
    title = ""
    tag = ""
    def __init__(self,ncol):
        r = gtk.CellRendererText()
        r.set_property("ellipsize",pango.ELLIPSIZE_END)
        super(ExpandTextColumn,self).__init__(self.title,r,text=ncol)
        self.set_expand(True)
        self.set_resizable(True)
        self.set_min_width(50)

class TitleColumn(ExpandTextColumn):
    title = _("Title")
    tag = "title"
    
    
class AlbumColumn(ExpandTextColumn):
    title = _("Album")
    tag = "album"
    
class GenreColumn(ExpandTextColumn):
    title = _("Genre")
    tag = "genre"
    
class ArtistColumn(ExpandTextColumn):
    title = _("Artist")
    tag = "artist"
    
class FeedColumn(ExpandTextColumn):
    title = _("Feeds")
    tag = "feed"
    
class PersonColumn(EllipsizeTextColumn):
    title = _("Person")
    tag = "#person"
    
class RadioPersonColumn(EllipsizeTextColumn):
    title = _("Person")
    tag = "radio_person"

class MaxPersonColumn(EllipsizeTextColumn):
    title = _("Max Person")
    tag = "#max_perso"

class BitrateColumn(TextColumn):
    title = _("Bitrate")
    tag = "#bitrate"
    
class TrackColumn(TextColumn):
    title = _("#")
    tag = "#track"
    
class DurationColumn(TextColumn):
    title = _("Length")
    tag = "#duration"
    
class DateColumn(TextColumn):
    title = _("Date")
    tag = "#date"
    
class YearColumn(TextColumn):
    title = _("Year")
    tag = "date"
        
class ProgressColumn(gtk.TreeViewColumn):
    def __init__(self,ncol,ncol2):
        r = gtk.CellRendererProgress()
        super(ProgressColumn,self).__init__("",r,text=ncol,value=ncol2)
        self.set_resizable(True)
        self.tag = "progress"
        
class LastPlayerColumn(TextColumn):
    title = _("Last Played")
    tag = "#lastplayed"
        
class PlayCountColumn(TextColumn):
    title = _("Play Count")
    tag = "#playcount"
        
class PlayCountColumn(gtk.TreeViewColumn):
    def __init__(self,ncol):
        r = gtk.CellRendererText()
        super(PlayCountColumn,self).__init__(_("Play Count"),r,text=ncol)
        self.set_resizable(True)
        self.tag = "#playcount"
        
TAG_COLUMNS = { "title":TitleColumn,
               "artist":ArtistColumn,
               "album":AlbumColumn,
               "#duration":DurationColumn,
               "#track":TrackColumn,
               "#date":DateColumn,
               "date":YearColumn,
               "progress":ProgressColumn,
               "radio_person":RadioPersonColumn,
               "#person":PersonColumn,
               "#max_person":MaxPersonColumn,
               "#bitrate":BitrateColumn,
               "#lastplayed":LastPlayerColumn,
               "#playcount":PlayCountColumn,
               "genre":GenreColumn,
               "feed":FeedColumn
               }
                