


import os
import logging
import re

classfilter = []
configfile = os.path.expanduser("~/.listenlogfilter.conf")
if os.path.exists(configfile):
    fd = file(configfile)
    classfilter = fd.read().split()
    fd.close()

levelno = logging.WARN
def setLevelNo(n):
    global levelno
    levelno = ( 100 - (n * 10) )

class MyFilter(logging.Filter):
    def __init__(self, name=""): pass
    def filter(self, record):
        global levelno
        if record.levelno >= levelno: return True
        for filter in classfilter:
            if record.name.startswith(filter): return True
        return False


FORMAT="%(levelname)-8s %(name)s   %(message)s"
logger = logging.getLogger("listen")
logger.setLevel(logging.DEBUG)
logging.addLevelName(100,"DEPRECATED")

formatter = logging.Formatter(FORMAT)

handler = logging.StreamHandler()
handler.setFormatter(formatter)

handler.addFilter(MyFilter())

logger.addHandler(handler)

def objaddr(obj):
    string = "%s"%obj
    m = re.search("at (0x\w+)",string)
    if m: return  m.group(1)
    m = re.search("/GstPipeline:ListenPlayer/GstBin:(\w+) \(StreamBin\)",string)
    if m: return m.group(1)
    return ""

def newLogger(name):
    return logging.getLogger("listen.%s"%name)

class Logger:
    def logdebug(self, msg, *args, **kwargs): 
        msg = "%s  %s"%(objaddr(self),msg)
        mylogger = logging.getLogger("listen.%s.%s"%(self.__module__,self.__class__.__name__))
        mylogger.debug(msg, *args, **kwargs)

    def loginfo(self, msg, *args, **kwargs): 
        msg = "%s  %s"%(objaddr(self),msg)
        mylogger = logging.getLogger("listen.%s.%s"%(self.__module__,self.__class__.__name__))
        mylogger.info(msg, *args, **kwargs)

    def logwarn(self, msg, *args, **kwargs): 
        msg = "%s  %s"%(objaddr(self),msg)
        mylogger = logging.getLogger("listen.%s.%s"%(self.__module__,self.__class__.__name__))
        mylogger.warn(msg, *args, **kwargs)

    def logerror(self, msg, *args, **kwargs): 
        msg = "%s  %s"%(objaddr(self),msg)
        mylogger = logging.getLogger("listen.%s.%s"%(self.__module__,self.__class__.__name__))
        mylogger.error(msg, *args, **kwargs)

    def logcritical(self, msg, *args, **kwargs): 
        msg = "%s  %s"%(objaddr(self),msg)
        mylogger = logging.getLogger("listen.%s.%s"%(self.__module__,self.__class__.__name__))
        mylogger.critical(msg, *args, **kwargs)

    def logexception(self, msg, *args, **kwargs):
        msg = "%s  %s"%(objaddr(self),msg)
        mylogger = logging.getLogger("listen.%s.%s"%(self.__module__,self.__class__.__name__))
        mylogger.exception(msg, *args, **kwargs)

    def logdeprecated(self, msg, *args, **kwargs):
        msg = "%s  %s"%(objaddr(self),msg)
        mylogger = logging.getLogger("listen.%s.%s"%(self.__module__,self.__class__.__name__))
        mylogger.log(100,msg, *args, **kwargs)
