# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gst
import gtk
import gobject
from plugins.generic import GenericPlugin
from player import Player
from action_manager import ActionManager

class VideoArea(gtk.DrawingArea):
    def __init__(self):
        gtk.DrawingArea.__init__(self)
        self.unset_flags(gtk.DOUBLE_BUFFERED)
        self.__imagesink = None

    def set_sink(self,imagesink):
        self.__imagesink = imagesink

    def do_expose_event(self, event):
        if self.__imagesink:
            self.__imagesink.expose()
            return False
        else:
            return True


class VisualisationPlugin(GenericPlugin):
    PLUGIN_NAME="Visualisation"
    PLUGIN_DESC="Visualisation plugin"
    PLUGIN_VERSION = "0.1"
    PLUGIN_AUTHOR = "Mehdi ABAAKOUK <theli48@gmail.com>"
    PLUGIN_WEBSITE = ""

    def __init__(self):
        super(VisualisationPlugin,self).__init__()

        self.__visplugins_list = None
        self.__bin = None
        self.__next_visname = None
        self.__fs_window = None


        self.__movie_window = VideoArea()
        self.__movie_window.set_size_request( 100,-1)
        self.__small_movie_window = self.__movie_window

        self.__eventbox = gtk.EventBox()
        self.__eventbox.add(self.__movie_window)
        self.autoconnect(self.__eventbox,"button_press_event", self.__on_click )

        frame_video = gtk.Frame()
        frame_video.set_shadow_type(gtk.SHADOW_IN)
        frame_video.add(self.__eventbox)
        frame_video.set_border_width(3)

        ActionManager.register_action("visualizer", 1000, None, frame_video, pack_end=True)


        bus = Player.bin.pipeline.get_bus()
        bus.enable_sync_message_emission()
        self.autoconnect(bus,'sync-message::element', self.on_sync_message)

          
        self.__differed_set_visualizer = False
        self.__differed_unset_visualizer = False

        self.__visualizer_state = "STATE_NULL"

        self.autoconnect(Player.bin,"tee-inserted",self.__on_insert)
        self.autoconnect(Player.bin,"tee-removed",self.__on_remove)

        self.change_visualizer("goom")

    def destroy(self):
        if self.__bin: Player.bin.xfade_remove_tee(self.__bin)
        ActionManager.unregister_action("visualizer")

    def on_sync_message(self, bus, message):
        if message.structure is None: return
        if not self.__movie_window.window: return
        if message.structure.get_name() == 'prepare-xwindow-id':
            self.__movie_window.set_sink(message.src)
            #print "I:Visualizer:prepare-xwindow-id receive"
            message.src.set_property('force-aspect-ratio', False)
            message.src.set_property('handle-expose', False)
            message.src.set_xwindow_id(self.__movie_window.window.xid)

    def __on_insert(self,bin,tee,element):
        if element != self.__bin: return
        if self.__visualizer_state == "STATE_READY":
            self.__visualizer_state = "STATE_PLAYING"

        if self.__differed_unset_visualizer:
            self.__differed_unset_visualizer = False
            self.__unset_visualizer()

    def __on_remove(self,bin,tee,element):
        if element != self.__bin: return
        if self.__visualizer_state == "STATE_DIRTY":
            self.__bin.set_state(gst.STATE_NULL)
            self.__bin = None
            self.__visualizer_state =  "STATE_NULL"

        if self.__differed_set_visualizer:
            self.__differed_set_visualizer = False
            self.__set_visualizer()

    def __unset_visualizer(self):
        if self.__visualizer_state == "STATE_READY":
            self.__differed_unset_visualizer = True
            return

        if self.__visualizer_state == "STATE_PLAYING":
            self.__visualizer_state = "STATE_DIRTY"
            Player.bin.xfade_remove_tee(self.__bin)

    def change_visualizer(self,visname=None):
        if visname : self.__visname = visname
        if self.__bin:
            self.__unset_visualizer()
        self.__set_visualizer()

    def __set_visualizer(self):
        if self.__visualizer_state == "STATE_DIRTY":
            self.__differed_set_visualizer = True
            return

        if self.__visualizer_state != "STATE_NULL":
            return

        if self.__bin: 
            print "W:Visualizer:bin not correctly removed"

        self.__bin = gst.Bin("VisualizerBin")

        self.__identity = gst.element_factory_make("identity")
        self.__visplugin = gst.element_factory_make(self.__visname)
        self.__capsfilter = gst.element_factory_make("capsfilter")
        self.__colorspace = gst.element_factory_make("ffmpegcolorspace")
        self.__videoscale = gst.element_factory_make("videoscale")
        self.__sink = gst.element_factory_make("gconfvideosink")

        self.__bin.add(self.__identity, self.__visplugin, self.__capsfilter, self.__colorspace, self.__videoscale, self.__sink)
        gst.element_link_many( self.__identity, self.__visplugin, self.__capsfilter, self.__colorspace, self.__videoscale, self.__sink)

        self.__bin.add_pad( gst.GhostPad("sink",self.__identity.get_pad("sink")))
        
        self.__visualizer_state = "STATE_READY"
        self.__bin.set_state(gst.STATE_PAUSED)

        Player.bin.xfade_add_tee(self.__bin)

    def get_list_plugins(self):
        if self.__visplugins_list is None:
            self.__visplugins_list = []
            plugs = gst.registry_get_default().get_plugin_list()
            for p in plugs:
                for elem_factory in gst.registry_get_default().get_feature_list_by_plugin(p.get_name()):
                    if isinstance(elem_factory,gst.ElementFactory):
                        if elem_factory.get_klass().rfind("Visualization")!=-1:
                            self.__visplugins_list.append((p.get_name(),elem_factory.get_longname()))
        return self.__visplugins_list

    def __on_menuitem_activate(self, w, visname):
        self.change_visualizer(visname)

    def __on_click(self,btn,event):
        if Player.is_paused(): return

        if event.button == 3:
            menu = gtk.Menu()
            i = 0
            for visname,detail in self.get_list_plugins():
                label = gtk.Label()
                label.set_markup(detail)
                label.set_alignment(0.0, 0.0)
                item = gtk.MenuItem()
                item.add(label)
                item.connect("activate",self.__on_menuitem_activate ,visname)
                menu.attach(item, 0, 1, i, i+1)
                i +=1

            menu.show_all()
            menu.popup(None, None, None, event.button, event.time)

        if event.button == 1:
            self.toggle_fullscreen()

    def toggle_fullscreen(self):
    
        if self.__fs_window:
            self.__movie_window = self.__small_movie_window
            gobject.idle_add(self.__fs_window.destroy)
            self.__fs_window = None
            self.change_visualizer()
        else:
            self.__movie_window = VideoArea()
            #self.__movie_window.set_size_request( 150,-1)

            eventbox = gtk.EventBox()
            eventbox.add(self.__movie_window)
            self.autoconnect(eventbox,"button_press_event", self.__on_click )

            self.__fs_window = gtk.Window(gtk.WINDOW_POPUP)

            self.__fs_window.set_decorated(False)
            self.__fs_window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
            monitor = gtk.gdk.Screen.get_monitor_geometry(gtk.gdk.screen_get_default(), 0)
            self.__fs_window.add(eventbox)
            self.__fs_window.resize(monitor.width,monitor.height)
            eventbox.show_all()
            self.is_fullscreen = True
            self.__fs_window.show_all()
            self.__fs_window.set_keep_above(True)

            self.change_visualizer()

    def _set_visualizer(self,visname,x,y):
        print "==> Insert visualizer"
        new_bus = False
        failed = False
        add_tee = False
        old_vis = None
        blocked_pad = None

        if self.__bin.get_parent():
            ret, state, pending = self.__bin.get_state()
            if ret == gst.STATE_CHANGE_SUCCESS and state == gst.STATE_PLAYING:
                gpad = self.__bin.get_pad("sink")
                blocked_pad = gpad.get_target()
                blocked_pad.set_blocked(True)
        elif False:
            bus = self.__bin.get_bus()
            if not bus:
                bus = gst.Bus()
                new_bus = True
                self.__bin.set_bus(bus)
            ret = self.__sink.set_state(gst.STATE_READY)
            if ret == gst.STATE_CHANGE_FAILURE:
                while bus.have_pending():
                    msg = bus.pop()
                    if msg.type == gst.MESSAGE_ERROR:
                        print "E:Visualizer:",msg.parse_error()
                failed = True
            if False and new_bus:
                self.__bin.set_bus(Player.bin.pipeline.get_bus())

            if failed: return

            add_tee = True
        else:
            add_tee = True

        if self.__visplugin:
            old_vis = self.__visplugin
            self.__bin.remove(self.__visplugin)

        self.__visplugin = gst.element_factory_make(visname)
        self.__bin.add(self.__visplugin)

        gst.element_link_many(self.__identity, self.__visplugin, self.__capsfilter)


        pad = self.__visplugin.get_pad("src")
        template_caps = pad.get_pad_template_caps()
        caps = template_caps.copy()
        if not caps.is_fixed():
            caps = caps.make_writable()
            for i in range(0,caps.get_size()):
                cap = caps[i]
                cap.fixate_field_nearest_int("width",x)
                cap.fixate_field_nearest_int("height",y)
                cap.fixate_field_nearest_double("framerate",float(24))
            self.__capsfilter.set_property("caps",caps)
            print "Force fixed at",
        else:
            print "Already fixed at",
        print caps.to_string()

        if add_tee:
            self.__bin.set_state(gst.STATE_READY)
            Player.bin.xfade_add_tee(self.__bin)
        elif blocked_pad:
            self.__bin.set_state(gst.STATE_PLAYING)
            blocked_pad.set_blocked(False)
        else:
            self.__bin.set_state(gst.STATE_PAUSED)
        
        if old_vis:
            old_vis.set_state(gst.STATE_NULL)


