# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gobject
import threading
import urllib
from StringIO import StringIO
from time import time,sleep
import utils
from proxy import discover_http_proxy

THREAD_INSTANCE = []
gobject.threads_init()

WEBSERVICE_CACHE_EXPIRATION = 1000*60*60*6

TIMEOUT = 30

class WebFetchThread:
    def __init__(self,buffer_len,func_fail_cb,*args_fail_cb):
        self.id = len(THREAD_INSTANCE)
        THREAD_INSTANCE.append(self)
        
        
        self.dbg = False
        self.info = None
        
        self.buffer_len = buffer_len
        self.func_fail_cb = func_fail_cb
        self.args_fail_cb = args_fail_cb
        
        self.condition = threading.Condition()
        t = threading.Thread(target=self.fetch)
        t.setDaemon(True)
        t.start()
        
        
        self.cache = {}
        
        self.mode_queue = False
        self.mode_cache = True
        
        #Dirty hack to get the url
        self.last_url_fail = None
    
    def set_mode_queue(self,value):
        self.mode_queue = value
        if value:
            self.info = []
        else:
            self.info = None
    
    def set_mode_cache(self,mode):
        self.mode_cache = mode

    def flush_cache(self):
        self.cache = {}
        
    def fetch_url(self,url,func_cb,*arg_cb,**kargs):
            
        self.print_dbg("demand fetch url: ",url)
        self.condition.acquire()
        if self.mode_queue :
            self.info.append((url,func_cb,arg_cb,kargs.get("func_fail"),kargs.get("func_fail_args")))
        else:
            self.info = (url,func_cb,arg_cb,kargs.get("func_fail"),kargs.get("func_fail_args"))
        self.condition.notify()
        self.condition.release()
        
        
    def fetch(self):
        while True:
            
            self.condition.acquire()
            while not self.info:
                self.print_dbg("wait url")
                self.condition.wait()
            
            if self.mode_queue :
                info = self.info.pop(0)
            else:
                info = self.info
                self.info = None
                
            url = info[0]
            if url.rfind("#")!=-1:
                url = url[:url.rfind("#")]
            self.print_dbg("url demanded:",url)
            
            
            if not self.cache.has_key(url) or time() - self.cache[url][1] > WEBSERVICE_CACHE_EXPIRATION:
                self.condition.release()
                
                #example of urllib timeout found at:
                # http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/284631
                f = []
                def subthread(url,f):
                    proxy = discover_http_proxy()
                    opener = urllib.FancyURLopener(proxy)
                    opener.addheaders.pop(0)
                    opener.addheader("User-Agent","Mozilla/5.0 (X11; U; Linux i686; fr; rv:1.8.0.5) Gecko/20060731 Ubuntu/dapper-security Firefox/1.5.0.5")
                    self.print_dbg("open url:",url)
                    try:
                        f.append(opener.open(url))
                    except: 
                        f = []
                        
                t = threading.Thread(target=subthread,args=(url,f))
                t.setDaemon(True)
                t.start()
                
                #wait a new url or socket timeout or thread left
                self.print_dbg("wait open url")
                start = time()
                self.condition.acquire()
                while (self.mode_queue or self.info==None) and time() - start < TIMEOUT and t.isAlive():
                    self.condition.release()
                    #Need do some test to optimise value perhaps more smaller
                    sleep(0.5)
                    self.condition.acquire()
                self.condition.release()
                
                if f==[] or not f[0]:
                    self.print_dbg("failed connect to:",url)       
                    self.condition.acquire()
                    if (self.mode_queue or self.info==None):
                        if info[3]: 
                            if info[4]: args = info[4]
                            else: args = tuple()
                            gobject.idle_add(info[3],*args)
                        else:
                            self.last_url_fail = url
                            gobject.idle_add(self.func_fail_cb,*self.args_fail_cb)
                    self.condition.release()
                    continue
                else:
                    f = f[0]
                
                    
                    
                self.print_dbg("connected to :",url)
    
                f_data = StringIO()
                data = f.read(self.buffer_len)
                f_data.write(data)
                
                self.condition.acquire()
                while data and (self.mode_queue or self.info==None):
                    self.condition.release()
                    data = f.read(self.buffer_len)
                    f_data.write(data)
                    #self.print_dbg("DL progess",len(data))
                    self.condition.acquire()
                    
                f.close()
                if not self.info and self.mode_cache: 
                    self.cache[url] = (f_data,time())
            else:
                self.print_dbg("cache used")
                f_data = self.cache[url][0]
                
            f_data.seek(0)
            if self.mode_queue or self.info==None: 
                self.print_dbg("send retrieved data")
                gobject.idle_add(info[1],f_data,*info[2])
                self.condition.release()
            else:
                self.condition.release()
                self.print_dbg("retrived data break")  
                
    def print_dbg(self,*args):
        if self.dbg: print "DBG:WebFetchThread:id=",self.id,":",args
            
