# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gtk
import pango

from library import ListenDB
from player import Player

from widget.misc import set_tip

class PlayInfo(gtk.Label):
    def __init__(self):
        super(PlayInfo,self).__init__("")

        self.set_ellipsize(pango.ELLIPSIZE_END)
        self.set_use_markup(True)
        self.set_selectable(True)
        self.set_alignment(0,0.5)
        
        self.set_markup("<span size=\"large\"><b>"+_("No playing")+"</b></span>\n\n")
        set_tip(self,_("No playing"))


        Player.connect("instant-new-song",self.__new_song)
        ListenDB.connect("simple-changed",self.__on_change)
        Player.bin.connect("buffering", self.__on_buffering)
        
        self.song = None
        
    def __on_buffering(self, playbin, progress):
        if self.song:
            self.update(self.song, progress)


    def __on_change(self,db,songs):
        if self.song in songs:
            self.update(self.song)
    
    def __new_song(self, player, song):
        self.update(song)

    def update(self, song , buffering = None):
        if not song: return
        self.song = song

        markup = ""

        tip = song.get_str("title")
        markup += "<span size=\"large\"><b>"+song.get_str("title",True)+"</b></span>"
        if song.get("station"):
            markup += " <b><i>("+song.get_str("station",True)+")</i></b>"
        markup += "\n<span>"
        if song.get("artist"):
            tip += " - "+song.get_str("artist")
            markup += "<i>"+song.get_str("artist",True)+"</i> "
        markup += "\n"
        if song.get("album"):
            tip += " - "+song.get_str("album")
            markup += song.get_str("album",True)
        elif song.get("info_supp"):
            markup +=  song.get_str("info_supp",True)
        elif buffering is not None and buffering <= 100:
            markup +=  "\n<i>(%s... %d%%)</i>"%(_("buffering"), buffering)
        markup += "</span>"

        self.set_markup(markup)
        set_tip(self,tip)
        
