# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gtk
import pango

import utils
import stock

from source import Source, MANDATORY_SOURCE, BLACKLIST_SOURCE
from widget.misc import MarkupLabel,ScrolledWindow

from plugins import Manager
from helper import Dispatcher

COL_NAME = 0
COL_ENABLE = 1
COL_PLUGIN = 2
COL_MANAGER = 3 
COL_INCONSISTENT = 4
COL_SEPARATOR = 5
COL_INDICATORSIZE = 6
COL_VERSION = 7
COL_DESC = 8
COL_AUTHOR = 9
LIST_STORE_TYPES = (str,bool, object, object, bool,bool,int, str,str,str)
# Name, enabled, plugin, manager, inconsistent, separator ,

class PluginsPreferenceDialog( gtk.Window ):
    def __init__(self,parent):
        super(PluginsPreferenceDialog,self).__init__()
        self.set_title(_("Plugins management"))
        self.set_resizable(True)
        self.set_modal(True)
        self.set_default_size(580,360)
        self.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        self.set_border_width(12)
        self.set_property("skip-taskbar-hint",True) 
        
        self.set_transient_for(parent)
        self.connect("destroy",self.close)

        class ColumnText(gtk.TreeViewColumn):
            def __init__(self,name,ncol):
                r = gtk.CellRendererText()
                gtk.TreeViewColumn.__init__(self,name,r,markup=ncol)
                #self.set_expand(True)
                #self.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)
                
        class ColumnSiText(gtk.TreeViewColumn):
            def __init__(self,name,ncol):
                r = gtk.CellRendererText()
                gtk.TreeViewColumn.__init__(self,name,r,text=ncol)
                self.set_resizable(True)
                #self.set_expand(True)
                #self.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)
                
        class ColumnSiTextEllip(gtk.TreeViewColumn):
            def __init__(self,name,ncol):
                r = gtk.CellRendererText()
                r.set_property("ellipsize",pango.ELLIPSIZE_END)
                gtk.TreeViewColumn.__init__(self,name,r,text=ncol)
                self.set_resizable(True)
                self.set_expand(True)
                self.set_sizing(gtk.TREE_VIEW_COLUMN_GROW_ONLY)
                
        self.__treeview = gtk.TreeView()
        #self.__treeview.set_headers_visible(False)
        
        def row_separator(model, iter): return model[iter][COL_SEPARATOR]
        self.__treeview.set_row_separator_func(row_separator)
        
        self.__toggle_cellrenderer = gtk.CellRendererToggle()
        self.__toggle_id_toggled = self.__toggle_cellrenderer.connect("toggled",self.__on_toggled)
        
        col = gtk.TreeViewColumn("",self.__toggle_cellrenderer,active=COL_ENABLE,inconsistent=COL_INCONSISTENT)
        col.add_attribute(self.__toggle_cellrenderer,"indicator-size",COL_INDICATORSIZE)
        
        self.__treeview.append_column(ColumnText(_("Name"),COL_NAME))
        self.__treeview.append_column(col)
        self.__treeview.append_column(ColumnSiText(_("Version"),COL_VERSION))
        self.__treeview.append_column(ColumnSiTextEllip(_("Description"),COL_DESC))
        #self.__treeview.append_column(ColumnSiTextEllip(_("Author"),COL_AUTHOR))
        
        self.__treeview.set_model(gtk.ListStore(*LIST_STORE_TYPES))
        self.__treeview.get_selection().connect("changed",self.__on_row_selected)
        
        self.__desc = MarkupLabel("")
        self.__plugbtn = gtk.Button(stock = stock.CONFIGURE)
        self.__plugbtn.connect("clicked",self.on_configure)
        self.__plugbtn.set_sensitive(False)

        btn = gtk.Button( stock=gtk.STOCK_CLOSE )
        btn.connect("clicked",lambda *arg : self.destroy())

        btn2 = gtk.Button(stock=gtk.STOCK_REFRESH)
        btn2.connect("clicked",self.reload)
        bottom_box = gtk.HBox(spacing=6)
        bottom_box.pack_start(self.__desc,True,True)
        bottom_box.pack_start(self.__plugbtn, False, False)
        bottom_box.pack_start(btn,False,False)
        bottom_box.pack_start(btn2,False,False)

        self.add(gtk.VBox(spacing=12))
        sw = ScrolledWindow(self.__treeview)
        self.child.pack_start(sw)
        self.child.pack_start(bottom_box,False,False)
        self.show_all()
        self.reload()
    
    def on_configure(self,*args):
        model, iter = self.__treeview.get_selection().get_selected()
        if iter:
            plug = model[iter][COL_PLUGIN]
            if plug and hasattr(plug,"on_configure") and callable(plug.on_configure): 
                plug.on_configure(self)

    def reload(self,*arg):
        self.__toggle_cellrenderer.handler_block(self.__toggle_id_toggled)

        model = self.__treeview.get_model()
        model.clear()
        first = True
        for name, pm in Manager.instances.iteritems():
            pm.scan()
            
            if not first : model.append( (None, None,  None , None, None, True, 0, None, None, None) )
            model.append( ("<b>"+name+"</b>", False,  None , pm, True, False, 0, None, None, None ) )
            plist = pm.list()
            if not plist: continue
            if issubclass(plist[0],Source):
                plist = [ (p.display_index,p) for p in plist if p.__name__ not in MANDATORY_SOURCE and p.__name__ not in BLACKLIST_SOURCE]
                plist.sort()
                plist= [ p[1] for p in plist ]

            for plugin in plist:
                if pm.activable:
                    size = 12
                    inconsistent = False
                else:
                    size = 0
                    inconsistent = True
                model.append( (plugin.PLUGIN_NAME, pm.enabled(plugin),  plugin, pm, inconsistent, False , size, plugin.PLUGIN_VERSION, plugin.PLUGIN_DESC, plugin.PLUGIN_AUTHOR) )
            first = False
            
        
        self.__toggle_cellrenderer.handler_unblock(self.__toggle_id_toggled)
        self.__treeview.get_selection().select_path(0)
            

    def close(self,*args):
        self.save()

    def save(self):
        pms = Manager.instances.values()
        [ pm.save() for pm in pms ]            
        #Dispatcher.reload_plugins()
        
    def __on_toggled(self,cellrenderer,path):
        active = not cellrenderer.get_active()
        self.__treeview.get_model()[path][COL_MANAGER].enable(self.__treeview.get_model()[path][COL_PLUGIN], active)
        self.__treeview.get_model()[path][COL_ENABLE] = active
        self.save()
    
    def __on_row_selected(self,treeselection):
        model, iter = treeselection.get_selected()
        if iter:
            pm = model[iter][COL_MANAGER]
            plug = model[iter][COL_PLUGIN]
            if plug and pm:
                self.__plugbtn.set_sensitive(hasattr(plug,"on_configure") and callable(plug.on_configure))
                desc  = ""
                desc += "<b>"+_("Author(s)")+":</b> "
                if plug.PLUGIN_AUTHOR:
                    desc += utils.xmlescape(plug.PLUGIN_AUTHOR)
                desc += "\n<b>"+_("Website")+":</b> "
                if plug.PLUGIN_WEBSITE:
                    desc += utils.xmlescape(plug.PLUGIN_WEBSITE)
                self.__desc.set_markup( desc )
                return
        self.__desc.set_markup( "" )
        self.__plugbtn.set_sensitive(False)
        #self.__treeview.get_selection().select_path(1)
        
