# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import threading
try: from elementtree.ElementTree import fromstring as XMLFromString
except ImportError: 
    # Python 2.5 rename
    from xml.etree.ElementTree import fromstring as XMLFromString

import urllib
from time import time

from web_threading import WebFetchThread
import utils

from logger import Logger


LASTFM_WEBSERVICE_URL = "http://ws.audioscrobbler.com/2.0/"
LASTFM_WEBSERVICE_APIKEY = "b25b959554ed76058ac220b7b2e0a026"


def lastfm_get_service_method_url(infos):
    infos["api_key"] = LASTFM_WEBSERVICE_APIKEY
    url = LASTFM_WEBSERVICE_URL + "?" + "&".join([ "%s=%s"%(key, value) for key, value in infos.items() ])
    return url


class LastFmInfo(Logger):
    def __init__(self):
        
        self.condition_artist = threading.Condition() 

        self.download_thread_related = WebFetchThread(1024,self.fail_fetch)
        self.download_thread_related.set_mode_queue(True)
        self.download_thread_topalbum = WebFetchThread(1024,self.fail_fetch)
        self.download_thread_topalbum.set_mode_queue(True)
        self.download_thread_events = WebFetchThread(1024,self.fail_fetch)
        self.download_thread_events.set_mode_queue(True)
        
        self.related_cache = {}
        self.topalbum_cache = {}
        self.events_cache = {}
        
    def fail_fetch(self):
        self.logwarn("Failed retrieve a url")
    
    def get_related(self,artist,callback,*args_cb,**kargs):
        if not artist: return 
        if self.related_cache.has_key(artist):
            callback(self.related_cache[artist][1],*args_cb)
        else:
            url_artist = lastfm_get_service_method_url({
                "method":"artist.getsimilar",
                "artist":urllib.quote(utils.filter_info_song(artist).encode("utf-8"))
            })
            self.download_thread_related.fetch_url(url_artist,self.fetch_related,artist,callback,*args_cb,**kargs)
        
        
    def fetch_related(self,file,artist,callback,*args_cb):
        try:
            root = XMLFromString(file.read())
        except:
            self.logwarn("failed artist.getsimilar for %s",artist)
            return
        status = root.attrib["status"]
        root = root.find("similarartists")
        if status == "failed" or not root:
            #error_code = root.getchildren()[0].attrib["code"]
            #error_str = root.getchildren()[0].text
            self.logwarn("failed artist.getsimilar for %s",artist)
            return
        else:
            related = []
            for i,a in enumerate(root.getchildren()):
                if a.tag == 'artist':
                    item = {}
                    for at in a.getchildren():
                        if at.tag in ["name","url","match"] and at.text:
                            # Url doesn't have http:// ?
                            if at.tag == "url": item[at.tag] = "http://"+at.text
                            else: item[at.tag] = at.text
                        if at.tag == 'image':
                            if at.attrib.has_key("size"):
                                item["image_%s"%at.attrib["size"]] = at.text
                        if at.tag == 'streamable':
                            item["streamable"] = ( at.text == "1")
                    related.append(item)
            self.related_cache[artist] = (time(),related)
            callback(self.related_cache[artist][1],*args_cb)
        
    def get_topalbum(self,artist,callback,*args_cb,**kargs):
        if not artist: return 
        if self.topalbum_cache.has_key(artist):
            callback(self.topalbum_cache[artist][1],*args_cb)
        else:
            url_artist = lastfm_get_service_method_url({
                "method":"artist.gettopalbums",
                "artist":urllib.quote(utils.filter_info_song(artist).encode("utf-8"))
            })
            self.download_thread_topalbum.fetch_url(url_artist,self.fetch_topalbum,artist,callback,*args_cb,**kargs)
        
        
    def fetch_topalbum(self,file,artist,callback,*args_cb):
        try:
            root = XMLFromString(file.read())
        except:
            self.logwarn("failed artist.gettopalbums for %s",artist)
            return
        status = root.attrib["status"]
        root = root.find("topalbums")
        if status == "failed" or not root:
            #error_code = root.getchildren()[0].attrib["code"]
            #error_str = root.getchildren()[0].text
            self.logwarn("failed artist.gettopalbums for %s",artist)
            return
        else:
            topalbum = []        
            for i,a in enumerate(root.getchildren()):
                if a.tag == 'album':
                    item = {}
                    for at in a.getchildren():    
                        if at.tag == 'name':
                            item["name"] = at.text
                        if at.tag == 'url':
                            item["url"] = at.text
                        if at.tag == 'playcount':
                            item["playcount"] = at.text
                        if at.tag == 'image':
                            if at.attrib.has_key("size"):
                                item["image_%s"%at.attrib["size"]] = at.text
                                   
                    topalbum.append(item)
                    
            self.topalbum_cache[artist] = (time(),topalbum)
            callback(self.topalbum_cache[artist][1],*args_cb)
            
    def get_events(self,artist,callback,*args_cb,**kargs):
        if not artist: return 
        if self.events_cache.has_key(artist):
            callback(self.events_cache[artist][1],*args_cb)
        else:
            url_artist = lastfm_get_service_method_url({
                "method":"artist.getevents",
                "artist":urllib.quote(utils.filter_info_song(artist).encode("utf-8")),
            })
            self.download_thread_events.fetch_url(url_artist,self.fetch_events,artist,callback,*args_cb,**kargs)
        
        
    def fetch_events(self,file,artist,callback,*args_cb):
        try:
            root = XMLFromString(file.read())
        except:
            self.logwarn("failed fetch_events for %s",artist)
            return
        status = root.attrib["status"]
        if status == "failed":
            error_code = root.getchildren()[0].attrib["code"]
            error_str = root.getchildren()[0].text
            self.logwarn("failed fetch_events for %s",artist)
            return
        else:
            events = {}
            for i,a in enumerate(root.getchildren()):
                if a.tag == "events":
                    events["artist_name"] = a.attrib["artist"]
                    events["total"] = int(a.attrib["total"])
                    events["events"] = []
                            
                    for b in a.getchildren():
                        item = {}
                        for c in b.getchildren():
                            if c.tag == "title":
                                item["title"] = c.text
                            
                            if c.tag == "artists":
                                artists = []
                                for d in c.getchildren():
                                    if d.tag == "artist":
                                        artists.append(d.text)
                                    if d.tag == "headliner":
                                        headliner = d.text
                                item["artists"] = artists
                                item["headliner"] = headliner
                                        
                            if c.tag == "venue":
                                for d in c.getchildren():
                                    if d.tag == "name":
                                        item["venue_name"] = d.text
                                    if d.tag == "location":
                                        for e in d.getchildren():
                                            if e.tag in ["city", "country"]:
                                                item[e.tag] = e.text
                                            
                            if c.tag in ["startDate", "url"] or (c.tag == "image" and c.attrib["size"] == "medium"):
                                item[c.tag.lower()] = c.text
                        events["events"].append(item)
            self.events_cache[artist] = (time(),events)
            callback(self.events_cache[artist][1],*args_cb)
                    
lastfm_info = LastFmInfo()

