# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

from subprocess import Popen

from plugins.generic import GenericPlugin
from widget.song_menu import SongMenuManager

from vfs import get_path_from_uri
from stock import add_stock, WIKI_CD

class BraseroPlugin(GenericPlugin):
    PLUGIN_NAME = "Brasero"
    PLUGIN_DESC = "Plugin to record song with brasero"
    PLUGIN_AUTHOR = "Mehdi ABAAKOUK <theli48@gmail.com>"
    PLUGIN_WEBSITE = "http://www.listen-project.org"
    PLUGIN_VERSION = "1.0"

    def __init__(self):
        GenericPlugin.__init__(self)

        def song_menu_action(song_menu_manager,id_menu,songs):
            if id_menu == "brasero" and songs:
                uris = [ get_path_from_uri(song.get("uri")) for song in songs ]
                Popen("brasero -a '%s'"%"' '".join(uris) , shell=True)

        self.autoconnect(SongMenuManager,"action",song_menu_action)
        SongMenuManager.register_item("brasero", 85,
                add_stock("brasero", _("Burn this track to audio CD"), WIKI_CD) )
        for type in [ "local","unknown_local"]:
            SongMenuManager.allow_item_for_type("brasero",type)

        
