from string import join
import dbus


import os
import gobject, gtk

import dbus
if getattr(dbus, 'version', (0,0,0)) >= (0,41,0):
    import dbus.glib


from player import Player
from plugins.generic import GenericPlugin

OBJ_PATH = '/org/gajim/dbus/RemoteObject'
INTERFACE = 'org.gajim.dbus.RemoteInterface'
SERVICE = 'org.gajim.dbus'

class GajimStatusPlugin(GenericPlugin):
    PLUGIN_NAME = "GajimStatus"
    PLUGIN_DESC = "Plugin to show Current player track in gajim"
    PLUGIN_VERSION = "0.1"
    PLUGIN_AUTHOR = "Unknown"
    PLUGIN_WEBSITE = "http://www.listen-project.org/ticket/700"

    def __init__(self):
        GenericPlugin.__init__(self)
        self.__lastsong = None
        self.sbus = dbus.SessionBus()
        self.autoconnect(Player, "new-song", self.on_new_song)
        
        self.__connected_to_gajim = False
        self.__check_gajim_presence()
        self.on_new_song(Player, Player.song)
        gobject.timeout_add(10000, self.__check_gajim_presence)

    def __check_gajim_presence(self):
        try: 
            obj = self.sbus.get_object(SERVICE, OBJ_PATH)
        except:
            if self.__connected_to_gajim:
                self.__connected_to_gajim = False
                self.loginfo("disconnect from gajim")
        else:
            interface = dbus.Interface(obj, INTERFACE)
            self.change_meth = interface.__getattr__("change_status")
            self.get_meth = interface.__getattr__("get_status")
            if not self.__connected_to_gajim:
                self.__connected_to_gajim = True
                self.loginfo("connect to gajim")
                if self.__lastsong:
                    self.on_new_song(None, self.__lastsong)
        return False

    def on_new_song(self, player, song):
        self.__lastsong = song
        if not song or not self.__connected_to_gajim: return
        try: 
            status = self.get_meth("")
        except:
            self.__check_gajim_presence()
            self.on_new_song(player,song)
            return

        title = ""
        artist = ""
        album = ""
        
        if song.get_str("title"):
            title = song.get_str("title")
        if song.get_str("artist"):
            artist = song.get_str("artist")
        if song.get_str("album"):
            album = song.get_str("album")

        status_msg = "\xe2\x99\xaa %s: %s (%s) \xe2\x99\xaa" %(artist, title, album)
        self.loginfo("Change gajim status to \"%s\"",status_msg)
        self.change_meth(status, status_msg, "")

