# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import urllib

from plugins.lyrics import LyricsPlugin

class LyrcComAcPlugin(LyricsPlugin):
    PLUGIN_NAME = "lyrc.com.ar"
    PLUGIN_DESC = "Add support of lyrc.com.ar website to provide lyrics"
    PLUGIN_VERSION = "0.1"
    PLUGIN_AUTHOR = "mehdi Abaakouk <theli@gmail.com>"
    PLUGIN_WEBSITE = "http://www.listen-project.org"
    server_name="lyrc.com.ar"
    
    def process_lyrics(self,artist,album,title,song):
        url = "http://lyrc.com.ar/en/tema1en.php?artist=%s&songname=%s"%(
            urllib.quote(artist.encode('utf-8')),
            urllib.quote(title.encode('utf-8')))
        self.download_data(url,self.fetch_lyrics_lyrccomar,song)

    def fetch_lyrics_lyrccomar(self,html_buffer,song):
        self.render(html_buffer.read(),song,True)
