# -*- coding: utf-8 -*-
# vim: ts=4
###
# written by xsdnyd <xsdnyd@gmail.com>
###

import urllib
import string

from plugins.lyrics import LyricsPlugin
from plugins.lyrics import LyricWiki_client

class LyricwikiPlugin(LyricsPlugin):
    PLUGIN_NAME = "lyricwiki.org"
    PLUGIN_DESC = "Add support of lyricwiki.org website to provide lyrics"
    PLUGIN_VERSION = "3.0"
    server_name = "lyricwiki.org"
    PLUGIN_AUTHOR = "Mehdi ABAAKOUK <theli48@gmail.com>"
    PLUGIN_WEBSITE = ""
    
    def process_lyrics(self,artist,album,title,song):
        soap = LyricWiki_client.LyricWikiBindingSOAP("http://lyrics.wikia.com/server.php")
        song = LyricWiki_client.getSongRequest()
        song.Artist = artist
        song.Song = title
        try: 
            result = soap.getSong(song)
            lyric = result.Return.Lyrics
        except:
            self.render(_("Unable to find any matches for this song."))
        else:
            self.render(lyric,song,True)
