# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import re
import gobject

import utils
from song import Song

from vfs import urlopen
from plugins.webradio import WebRadioPlugin

try: from elementtree.ElementTree import fromstring as XMLFromString
except ImportError:
    # Python 2.5 rename
    from xml.etree.ElementTree import fromstring as XMLFromString

from xml.parsers.expat import ExpatError

# Without arg return genre list
# with genre= return station list
SHOUTCAST_URL_QUERY = "http://www.shoutcast.com/sbin/newxml.phtml"

# Use id= to select stream
SHOUTCAST_URL_STREAM = "http://www.shoutcast.com/sbin/tunein-station.pls"

class ShoutcastPlugins(WebRadioPlugin):
    PLUGIN_NAME = "Shoutcast"
    PLUGIN_DESC = _("Allow to browse Shoutcast radio direcetory")
    PLUGIN_VERS = "2.0"

    conf_prefix = "shoutcast"
    def __init__(self):
        WebRadioPlugin.__init__(self)
        self.categorie = []
        self.cache = {}
        
    def get_xml_page(self, url):
        nb_try = 0
        while nb_try < 3:
            try: 
                handle_read = urlopen(url)
            except: 
                self.logwarn("Failed open url %s", url)
                return ""
        
            self.loginfo("Reading file %s",url)
            try: 
                data = handle_read.read()
                root = XMLFromString(data)
            except ExpatError:
                self.logexception("Failed parse xml from shoucast")
                print data
                root = None
            except:
                self.logexception("Failed read xml from shoucast")
                root = None
            handle_read.close()
            if root: 
                return root
            else: 
                nb_try += 1
        return None

    """
    Return Categorie tuple (key:Name)
    """
    def get_categorie(self):
        if self.categorie: return self.categorie
        root = self.get_xml_page(SHOUTCAST_URL_QUERY)
        if not root: return []
        for genre in root.getchildren():
            genre = genre.attrib["name"]
            self.categorie.append((genre,genre))
        self.loginfo("%d genres found",len(self.categorie))
        return self.categorie
    
    def get_songs_by_categorie(self,key_categorie):
        #FIXME: flush the cache sometimes
        if self.cache.has_key(key_categorie):
            return self.cache[key_categorie]

        songs = []    
        root = self.get_xml_page(SHOUTCAST_URL_QUERY + "?genre=" + key_categorie)
       
        if not root:
            #Hack to don't code any thing to send no radio on widget
            s = Song()
            s.set_type("local")
            s["title"] = _("No radio found")
            s["uri"] = _("No radio found")
            return [s]

        for station in root.getchildren():
            if station.tag != "station": continue
            try:
                w = {}
                w["uri"] = SHOUTCAST_URL_STREAM + "?id=" + station.attrib["id"]
                w["playlist"] = "pls" # Important for player it will read the playlist and choose en stream to read
                w["album"] = station.attrib["ct"]
                w["title"] = station.attrib["name"]
                w["radio_person"] = "%s"%(station.attrib["lc"])
                try:
                    w["#bitrate"] = int(station.attrib["br"])*1000
                except:
                    pass
                songs.append(w)
            except:
                self.logexception("Error decoding radio data")
            
        self.cache[key_categorie] = songs
        self.loginfo("%d stations found",len(songs))
        return songs

