# -*- coding: utf-8 -*-
# vim: ts=4 
#
# Copyright (C) 2007 - Guillaume Desmottes, Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import xml.sax, xml.sax.handler
TRANS = {
        "artist":"artist",
        "albumname":"album",
        "trackname":"title",
        "tracknum":"#track",
        "year":"date",
        "mp3genre":"genre",
        "seconds":"#duration",
        "url":"uri",
        }

markups = ["AllSongs","Track" ] 

class MagnatuneSaxHandler(xml.sax.handler.ContentHandler):
    def __init__(self):
        xml.sax.handler.ContentHandler.__init__(self)

        self.current = {}

    def startElement(self, name, attrs):
        self.__text = ""

        if name in markups:
            fct = getattr (self, "start" + name)
            fct (attrs)

    def endElement(self, name):
        if name in markups:
            fct = getattr (self, "end" + name)
            fct ()
        elif name in TRANS.keys():
            value = self.__text
            key = TRANS.get(name)
            if key == "#duration" and value:
                try: value = int(value) * 1000
                except: pass
            self.current[key] = value

    def characters(self, content):
        self.__text = self.__text + content

    def startAllSongs(self, attrs):
        self.tracks = []

    def endAllSongs(self):
        pass

    def startTrack(self, attrs):
        self.current = {}

    def endTrack(self):
        self.tracks.append(self.current)

if __name__ == "__main__":
    parser = xml.sax.make_parser()
    handler = MagnatuneSaxHandler()
    parser.setContentHandler(handler)
    datasource = open("/tmp/dump.xml")
    parser.parse(datasource)

    tracks = handler.tracks
    for track in tracks:
        print track
