# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gobject
import gtk
import threading
import utils,stock

from source import Source,SourceItem
from widget.song_view import SortableSongView
from widget.song_menu import SongMenu , SongMenuManager
from widget.misc import ScrolledWindow

from library import ListenDB
from helper import Dispatcher
from hal import hal
try: 
    import musicbrainz2
    import musicbrainz2.disc as disc
    import musicbrainz2.webservice as ws
except:
    print "No Audio cd support (musicbrainz2 missing)"

class MusicBrainzAudioCD(object):
    def __init__(self,device):
        self.device = device
        try: self.cd = disc.readDisc(device)    
        except: self.disc_id=None
        else: self.disc_id = self.cd.getId()
        
    def get_mb_release_id(self):
        q = ws.Query()
        filter = ws.ReleaseFilter(discId=self.disc_id)    
        
        try: results = q.getReleases(filter=filter)
        except: return None
        else:
            if len(results) > 0:
                return results[0].release.getId()               
        return None
                
    def get_mb_release(self,id):
        q = ws.Query()    
        include = ws.ReleaseIncludes(artist=True, tracks=True)
        try : res = q.getReleaseById(id,include)
        except: return None
        else: return res
        
    
    def get_tracks(self):
        if not self.disc_id : 
            print "W:MusicBrainzAudioCD:No disk id"
            return []
        
        release_id = self.get_mb_release_id()
        release = self.get_mb_release(release_id)
        if not release_id or not release: 
            print "W:MusicBrainzAudioCD:No release found"
            cd_tracks = self.cd.getTracks()
            tracks_tags = []
            for i in range(0,len(cd_tracks)):
                t = cd_tracks[i]
                # an audio CD sector size = 2352 
                # and audio CD encoded at 44.1KHz, Stereo, with 16-bit/sample 
                tags = {
                    "title" : _("Track")+" %d"%(i+1),
                    "album" : _("Unknown album"),
                    "artist" : _("Unknown artist"),
                    "#track" : (i+1),
                    "uri" : "cdda://%d#%s"%(i+1,self.device),
                    "#duration" : (t[1]*2352)/(2*2*44100)*1000
                    }
                tracks_tags.append(tags)
            return tracks_tags
        
        
        album_name = release.getTitle()
        artist = release.getArtist()
        artist_name = artist.getName()
        date_album = release.getEarliestReleaseDate()
        
        tracks = release.getTracks()
        cd_tracks = self.cd.getTracks()
        
        tracks_tags = []
        
        for i in range(0,len(tracks)):
            t = tracks[i]
            cd_t = cd_tracks[i]
            tags = {
                "title" : t.getTitle(),
                "album" : album_name,
                "#date" : date_album,
                "artist" : artist_name,
                "#track" : (i+1),
                "uri" : "cdda://%d#%s"%(i+1,self.device),
                "#duration" : (cd_t[1]*2352)/(2*2*44100)*1000
                }
            tracks_tags.append(tags)
        return tracks_tags
    
class AudioCDSource(Source):
    PLUGIN_NAME = "AudioCD Support"
    PLUGIN_DESC = _("Play your Audio CD")

    display_index = 80

    signal_collector_id = "audiocdsource"

    categorie = "device"

    def __init__(self):
        Source.__init__(self)

        self.play_device = None
        self.audiocd_items = {}
        ListenDB.register_type("audiocdtrack",["lyrics","wikipedia","lastfminfo","audioscrobbler","current"])
        for item_menu in [ "play", "enqueue" ,"lastfm","wikipedia_artist","wikipedia_album","lyrics"]:
            SongMenuManager.allow_item_for_type(item_menu,"audiocdtrack")

        try: 
            import musicbrainz2
        except: pass
        else: 
            self.autoconnect(hal,"volume-mounted",self.mount)
            self.autoconnect(hal,"volume-umounted",self.umount)
        self.autoconnect(Dispatcher,"play-device",self.on_play_device)
        for udi in hal.get_mounted_devices_udi():
            gobject.idle_add(self.mount,hal, udi)
        
    
    def on_play_device(self,helper,path):
        for udi,(item,device) in self.audiocd_items.iteritems():
            if path==device:
                songs = [ s for s in ListenDB.get_songs("audiocdtrack") if s.get("uri").endswith("#"+device) ]
                Dispatcher.cur_playlist_play(songs)
        self.play_device = path
        
    def check(self,udi):
        if hal.get_property(udi,"volume.disc.has_audio"):
            return True
        return False
        
    def mount(self,hal,udi):
        if not self.check(udi): return
        device_path = hal.get_device_path(udi)
        
        if device_path:
            t = threading.Thread(target=self.post_mount_thread,args=(device_path,udi))
            t.setDaemon(True)
            t.start()
                
    def post_mount_thread(self,device,udi):
        gobject.idle_add(self.post_mount_cb,MusicBrainzAudioCD(device).get_tracks(),device,udi)
        
    def post_mount_cb(self,tracks_tags,device,udi):
        if len(tracks_tags) >0 :
            songs = [ ListenDB.get_or_create_song(track,"audiocdtrack") for track in tracks_tags]
            item = AudioCDSourceItem(device,songs)
               
            self.audiocd_items[udi] = (item,device)
            if self.play_device==device:
                Dispatcher.cur_playlist_play(songs)
            self.build_source_items()

    def umount(self,hal,udi):
        if udi and self.audiocd_items.has_key(udi):
            ListenDB.remove(self.audiocd_items[udi][1].songs)
            del self.audiocd_items[udi]
            self.build_source_items()
        
    def build_source_items(self):
        self.items = []
        for udi,(item,device) in self.audiocd_items.iteritems():
            self.items.append(item)
        Dispatcher.update_source()
        

class AudioCDSourceItem(SourceItem):
    has_top_separateur = False
    has_bottom_separateur = False
    is_droppage = True
    stock = stock.WIKI_CD
    config_code = "audiocd"

    def __init__(self,device,songs):
        self.songs = songs
        self.device = device
        view = AudioCDSongView()
        view.get_model().fill(songs)
        self.widget = ScrolledWindow(view)
        self.label = songs[0].get_str("album")
    
    def on_drag_data_get(self,context, selection, info):
        list_uri = [ s.get("uri") for s in self.songs ]
        #ListenDB.get_songs("audiocdtrack") if s.get("uri").endswith("#"+self.device)
        selection.set("text/listen-songs", 8, "\n".join(list_uri))
        selection.set_uris(list_uri)
        return True
      
    def on_activated(self):
        self.play_playlist()
        
    def play_playlist(self,w=None):
        if len(self.songs)>0:
            Dispatcher.cur_playlist_play(self.songs)
               
    def enqueue_playlist(self,w):
        if len(self.songs)>0:
            Dispatcher.cur_playlist_enqueue(self.songs)  
            
    def get_menu(self):
        menu = gtk.Menu()
        item = gtk.ImageMenuItem(stock.PLAY)
        item.connect("activate",self.play_playlist)
        menu.append(item)
        item = gtk.ImageMenuItem(stock.ENQUEUE)
        item.connect("activate",self.enqueue_playlist)
        menu.append(item)
        menu.show_all()
        return menu
        
class AudioCDSongView(SortableSongView):
    def __init__(self):
        super(AudioCDSongView,self).__init__("audiocd")
        self.menu = SongMenu()
        self.set_menu(self.menu)

