# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import gtk
import gobject
import stock
import utils

from song import Song

from widget.misc import ScrolledWindow
from library import ListenDB
from source import Source,SourceItem,PlaylistSourceItem
from widget.song_view import PlaylistSongView
from widget.browser import SimpleBrowser
from widget.song_menu import SongMenu, SongMenuManager

from helper import Dispatcher 

from service_discover import service_discover

class DaapSource(Source):
    PLUGIN_NAME = "Daap Support"
    PLUGIN_DESC = _("Allow browse shared music library")
                                                                                                                                                               
    display_index = 1

    categorie = "shared"

    def __init__(self):
        self.services = {}

        # Try to load module before build source
        from daap import DAAPClient

        service_discover.connect_service("_daap._tcp",self.connect,self.disconnect)    
        
    def connect(self,*args):
        add,port,name = service_discover.resolve(*args)
        gobject.idle_add(self.add_service,add,port,name,*args)
        
    @utils.threaded
    def add_service(self,address, port,name,*args):
        l =  DaapLibrary(address, port)

        items = [ DaapLibrarySourceItem(l) ]
        plitems = [ DaapPlaylistSourceItem(pl) for pl in ListenDB.get_playlists(l.type) ]
        plitems.sort()
        items.extend(plitems)
        
        self.services[args[:-1]] = (l ,items,name)
        self.items.extend(items)
        
        Dispatcher.update_source()
        
    def disconnect (self,*args):
        self.items = []
        try: self.services[args[:-1]][0].close()
        except: pass
        del self.services[args[:-1]]
        for l, items, name in self.services.values():
            self.items.extend(item)
        Dispatcher.update_source()
    
    def destroy(self):
        for l, items, name in self.services.values():
            try: l.close()
            except: pass
            for item in items:
                item.destroy()
        self.items = []
        Dispatcher.update_source()
        
        
class DaapBrowser(SimpleBrowser):
    _cover = True
    _config_code = "daap"
    def __init__(self,library):
        self._type = library.type
        SimpleBrowser.__init__(self)

class DaapLibrarySourceItem(SourceItem):
    stock = gtk.STOCK_NETWORK
    config_code = "daaplibrary"

    def __init__(self,library):
        self.label = library.library.name
        self.widget = DaapBrowser(library)
          
class DaapPlaylistSongView(PlaylistSongView):
    editable = False

class DaapPlaylistSourceItem(PlaylistSourceItem):
    is_droppage = False
    editable = False
    config_code = "daaplibrary"

    _playlist_songview = DaapPlaylistSongView
#    _autoplaylist_songview = DaapAutoPlaylistBrowser

class DaapLibrary(object):
    def __init__(self,address, port):   
        self.address = address
        self.port = port

        from daap import DAAPClient
        self.client = DAAPClient()
        self.client.connect( address, port )
        self.session = self.client.login()
        self.library =  self.session.library()
        
        self.type = str(address)+":"+str(port)
    
        print "Loading DAAP songs AT",self.type        

        ListenDB.register_type(self.type,["lyrics","wikipedia","lastfminfo","audioscrobbler"])
        for menu_item in ["play","enqueue","lastfm","wikipedia_artist","wikipedia_album","lyrics"]:
            SongMenuManager.allow_item_for_type(menu_item, self.type)

        ListenDB.register_playlist_type(self.type)
        tracks = self.library.tracks()
        [ ListenDB.get_or_create_song( self.get_tags(track), self.type ) for track in tracks]
        
        print "Loading DAAP playlist AT " , self.type
        playlists = self.library.playlists()
        for pl in playlists:
            if pl.name == self.library.name: continue
            ListenDB.create_playlist(self.type , pl.name, [ ListenDB.get_or_create_song(self.get_tags(track),self.type ) for track in  pl.tracks() ] )
        print "Loading DAAP Finish AT",self.type        

    def close(self):
        print "I:DaapLibrary:Disconnect daap from:",self.type
        for menu_item in ["play","enqueue","lastfm","wikipedia_artist","wikipedia_album","lyrics"]:
            SongMenuManager.disallow_item_for_type(menu_item, self.type)
        ListenDB.unregister_type(self.type)
        ListenDB.unregister_playlist_type(self.type)
        if self.session:
            try:
                self.session.logout()
            except:pass
        
        
       
    def get_tags(self,track): 
        tags = {}
        tags["daap_track_id"] = track.id
#        if isinstance(track.id,int):
#            tags["uri"] = "daap://%s:%d/%d"%(self.address,self.port,track.id)
#        else:
#            tags["uri"] = "daap://%s:%d/%s"%(self.address,self.port,track.id)
        tags["uri"] = "http://%s:%s/databases/%s/items/%s?session-id=%s" % \
                            (self.address, self.port, self.session.library().id, track.id,
                                                self.session.sessionid)
        tags["title"] = (track.name or "").encode("utf8")
        tags["artist"] = (track.artist or "").encode("utf8")
        tags["album"] = (track.album or "").encode("utf8")
        tags["#duration"] = track.time
        #tags["#size"] = track.size
#        tags["genre"] = (track.genre or "").encode("utf-8")
        return tags
    
