# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import gobject
import gtk

import stock
import utils
from config import config

from source import Source,SourceItem, PlaylistSource, PlaylistSourceItem
from widget.song_view import PlaylistSongView,SortableSongView
from widget.song_model import SongModel
from widget.song_menu import SongMenu
from widget.browser import AutoPlaylistBrowser
from widget.misc import ScrolledWindow
from widget.smart_playlist import SmartPlaylistWindow

from helper import Dispatcher

from library import ListenDB, ListenDBQuery

class LocalAutoPlaylistBrowser(AutoPlaylistBrowser):
    _type = "local"
    _songview_klass = SortableSongView

class LocalPlaylistSongView(PlaylistSongView):
    editable = True

class LocalPlaylistSourceItem(PlaylistSourceItem):
    is_droppage = True
    editable = True

    config_code = "locallibrary"

    _playlist_songview = LocalPlaylistSongView
    _autoplaylist_songview = LocalAutoPlaylistBrowser
    
class LocalPlaylistSource(PlaylistSource):
    PLUGIN_NAME = "Playlist support"
    PLUGIN_DESC = _("Add Playlist Support")

    categorie = "playlist"
    editable = True

    _source_item_klass = LocalPlaylistSourceItem
    _type = "local"

    def save(self):
        for item in self.items:
            item.widget.save_config()

    def get_default_menu(self):
        if self.editable:
            item1 = gtk.ImageMenuItem(stock.SRC_PLAYLIST)
            item1.connect("activate",self.__new_playlist)
            item2 = gtk.ImageMenuItem(stock.SRC_PLAYLIST_SMART)
            item2.connect("activate",self.__new_auto_playlist)
            return [item1,item2]
        else:
            return []
    
    def __new_playlist(self,bt):
        ListenDB.create_playlist("local",_("New Playlist"))
    
    def __new_auto_playlist(self,bt):
        pl = ListenDB.create_autoplaylist("local","local",_("New Automatic Playlist"))
        SmartPlaylistWindow(pl, True).run()
    
