# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###
#    From quodlibet 
###
LISTEN = "listen"

ALBUM_ART = 'listen_cover'
MEDIA_LIB = 'listen'
LASTFM = "source/lastfm_mini"
COVER="listen_cover_color"

WIKI_USERS = 'users'
WIKI_CD = 'cd'
PREF_OSD = "osd"
PREF_PODCAST = "pref_podcast"
PREF_LASTFM = "source/lastfm_mini"
PREF_WIKIPEDIA = "source/wikipedia"

SRC_UNKNOWN = 'source/unknown'
SRC_BIBLIO = 'source/biblio'
SRC_JAMENDO = 'source/jamendo'
SRC_MAGNATUNE = 'source/magnatune'
SRC_DAAP = 'source/biblio'
SRC_IPOD = 'source/ipod'
SRC_PLAYLIST = 'source/playlist'
SRC_PLAYLIST_SMART = 'source/playlist_smart'
SRC_PLAYLIST_IPOD = 'source/playlist_ipod'
SRC_PODCAST_IPOD = 'source/podcast_ipod'
SRC_IRADIO='source/iradio'
SRC_WIKIPEDIA = "source/wikipedia"
SRC_LASTFM = "source/lastfm_mini"
SRC_PODCAST = "source/podcast"
SRC_LYRICS = "source/lyrics"
SRC_YOOOOK = "source/yooook"
LASTFM_SIMILAR="source/lastfm_mini"



_ICONS = [SRC_DAAP,LISTEN,MEDIA_LIB,LASTFM,WIKI_USERS,WIKI_CD,\
        PREF_OSD,PREF_PODCAST,PREF_LASTFM,\
        SRC_BIBLIO,SRC_IPOD,SRC_PLAYLIST,SRC_PLAYLIST_IPOD,SRC_PODCAST_IPOD,SRC_MAGNATUNE, \
        SRC_IRADIO,SRC_WIKIPEDIA,SRC_LASTFM,SRC_PODCAST,SRC_LYRICS,SRC_YOOOOK,SRC_PLAYLIST_SMART, SRC_JAMENDO, SRC_UNKNOWN, \
        COVER]

IMPORT_FOLDER = "importfolder"
IMPORT_FILE = "importfile"
OPEN_FILE = "openfile"
OPEN_URI = "openuri"
EDIT = "edit"
RENAME = "rename"
ENQUEUE = "enqueue"
PLAY = "play"
WIKI_ARTIST = "wiki-artist"
WIKI_ALBUM = "wiki-album"
LYRICS = "lyrics"
YOOOOK = "yooook"
DELETE = "delete"
DELETE_DISK = "delete-disk"
MUSICBRAINZ = "musicbrainz"
NEW_PODCAST = "new-podcast"
NEW_RADIO = "new-radio"
EDIT_RADIO = "edit-radio"
ADD_FAVORITE = "add-favorite"
EXPORT = "export"
RELOAD_LIBRARY = "reload-library"
SHUFFLE = "stock_shuffle"
BURN = "burn"
PODCAST_DOWNLOAD="podcast_download"
CONFIGURE="configure"
CHANGE_FONT="change_font"
VISIBLE_COLUMN="visible_column"
EJECT="eject"
BROWSER="browser"

import gtk
import gobject

from xdg_support import get_xdg_pixmap_file

lookup = gtk.icon_factory_lookup_default

factory = gtk.IconFactory()
factory.add_default()

def stock_init():
    for fn in _ICONS:
        pb = gtk.gdk.pixbuf_new_from_file( get_xdg_pixmap_file( fn + ".png" ) )
        factory.add(fn, gtk.IconSet(pb))


    gtk.stock_add([
            (EDIT, _("_Edit"), 0, 0, ""),
            (RENAME, _("_Rename"), 0, 0, ""),
            (ENQUEUE, _("En_queue"), 0, 0, ""),
            (PLAY, _("_Play"), 0, 0, ""),
            (WIKI_ARTIST, _("About _artist"), 0, 0, ""),
            (WIKI_ALBUM, _("About a_lbum"), 0, 0, ""),
            (LYRICS, _("See _Lyrics"), 0, 0, ""),
            (YOOOOK, _("_Liberate copyright"), 0, 0, ""),
            (DELETE, _('Remove'), 0, 0, ""),
            (DELETE_DISK, _('Move to trash'), 0, 0, ""),
            (SRC_PLAYLIST, _('_New Playlist'), 0, 0, ""),
            (SRC_PLAYLIST_SMART, _('New _Automatic Playlist...'), 0, 0, ""),
            (IMPORT_FOLDER,_('_Import Folder...'), 0, 0, ""),
            (IMPORT_FILE,_('_Import _File...'), 0, 0, ""),
            (OPEN_FILE,_('_Play a file'), 0, 0, ""),
            (OPEN_URI,_('_Play a uri'), 0, 0, ""),
            (MUSICBRAINZ,_('_Get file informations'), 0, 0, ""),
            (NEW_PODCAST,_('_New Podcast feed'), 0, 0, ""),
            (NEW_RADIO,_('_New Web Radio'), 0, 0, ""),
            (ADD_FAVORITE,_('_Add to favorite'), 0, 0, ""),
            (EDIT_RADIO,_("Edit Web Radio"), 0, 0, ""),
            (EXPORT,_("Export"),0,0,""),
            (RELOAD_LIBRARY,_("Reload Library"),0,0,""),
            (SHUFFLE,_("Shuffle"),0,0,""),
            (EJECT,_("Eject"),0,0,""),
            (BURN,_("Burn"),0,0,""),
            (PODCAST_DOWNLOAD,_("Download"),0,0,""),
            (CONFIGURE,_("Configure"),0,0,""),
            (LASTFM_SIMILAR,_("Listen Similar Artist"),0,0,""),
            (CHANGE_FONT,_("Change font"),0,0,""),
            (VISIBLE_COLUMN,_("Visible column"),0,0,""),
            (COVER,_("Change cover"),0,0,""),
            (BROWSER,_("Open in browser"),0,0,"")
            ])

   
    factory.add(NEW_PODCAST,lookup(gtk.STOCK_NEW))
    factory.add(NEW_RADIO,lookup(gtk.STOCK_NEW))
    factory.add(EDIT_RADIO,lookup(gtk.STOCK_EDIT))    
    factory.add(EDIT, lookup(gtk.STOCK_PROPERTIES))
    factory.add(IMPORT_FOLDER, lookup(gtk.STOCK_OPEN))
    factory.add(OPEN_FILE, lookup(gtk.STOCK_MEDIA_PLAY))
    factory.add(OPEN_URI, lookup(gtk.STOCK_MEDIA_PLAY))
    factory.add(IMPORT_FILE, lookup(gtk.STOCK_FILE))
    factory.add(RENAME, lookup(gtk.STOCK_EDIT))
    factory.add(ENQUEUE, lookup(gtk.STOCK_ADD))
    factory.add(PLAY, lookup(gtk.STOCK_MEDIA_PLAY))
    factory.add(WIKI_ARTIST, lookup(gtk.STOCK_ABOUT))
    factory.add(WIKI_ALBUM, lookup(gtk.STOCK_ABOUT))
    factory.add(LYRICS, lookup(gtk.STOCK_EDIT))
    factory.add(YOOOOK, lookup(SRC_YOOOOK))
    factory.add(DELETE, lookup(gtk.STOCK_REMOVE))
    factory.add(DELETE_DISK, lookup(gtk.STOCK_DELETE))
    factory.add(MUSICBRAINZ, lookup(gtk.STOCK_NETWORK))
    factory.add(ADD_FAVORITE, lookup(gtk.STOCK_CONVERT))
    factory.add(EXPORT, lookup(gtk.STOCK_SAVE_AS))
    factory.add(RELOAD_LIBRARY, lookup(gtk.STOCK_REFRESH))
    factory.add(BURN,lookup(gtk.STOCK_CDROM))
    factory.add(PODCAST_DOWNLOAD,lookup(gtk.STOCK_SAVE))
    factory.add(CONFIGURE,lookup(gtk.STOCK_PREFERENCES))
    factory.add(EJECT, lookup(gtk.STOCK_DISCONNECT))
    try: factory.add(SHUFFLE,  gtk.IconSet(gtk.icon_theme_get_default().load_icon("stock_shuffle",-1,gtk.ICON_LOOKUP_USE_BUILTIN)))
    except:pass 
    try: factory.add(BROWSER,  gtk.IconSet(gtk.icon_theme_get_default().load_icon("stock_internet",-1,gtk.ICON_LOOKUP_USE_BUILTIN)))
    except:pass 

def add_stock(id, text, icon):
    if not isinstance(icon, gtk.IconSet):
        icon = gtk.icon_factory_lookup_default(icon)
    factory.add(id, icon)
    gtk.stock_add([ (id, text, 0, 0, "") ])
    return id

