# -*- coding: utf-8 -*-
# vim: ts=4 
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import os
import re
import shutil
import gtk
import gobject
import locale
import time

import threading

import socket 
socket.setdefaulttimeout(5)

from urllib import pathname2url, url2pathname, quote_plus, unquote_plus, quote, unquote
from urllib2 import build_opener, ProxyHandler, Request
from xml.dom.minidom import parseString
from urlparse import urlparse, urlunparse

from proxy import discover_http_proxy
from logger import newLogger



logger = newLogger("vfs.vfsutils")


def urlopen(url):
    hproxy = ProxyHandler(discover_http_proxy())
    opener = build_opener(hproxy)
    req = Request(url)
    req.add_header("Accept","*/*")
    return opener.open(req)

def get_scheme(uri):
    if uri.rfind("://")==-1: return ""
    scheme = uri[:uri.index("://")]
    return scheme.lower()

def get_ext(uri, complete = True):
    if uri.rfind(".")==-1:
        return ""
    if get_scheme(uri) in [ "http", "https" ]:
        if uri.rfind("#")!=-1:
            uri = uri[:uri.rindex("#")]
        if uri.rfind("?")!=-1:
            uri = uri[:uri.rindex("?")]
    if complete:
        return uri[uri.rindex("."):].lower()
    else:
        if uri[-1:] == ".": return ""
        return uri[uri.rindex(".")+1:].lower()

def islocaldir(uri):
    if not get_scheme(uri) == "file": return False
    else: return os.path.isdir(get_path_from_uri(uri))


import mimetypes
mimetypes.init()

def get_mime_type(uri):
    # Minimum mime_type support for webradio
    if get_scheme(uri) in [ "http", "https" ]:
        if uri.rfind("#")!=-1:
            uri = uri[:uri.rindex("#")]
        if uri.rfind("?")!=-1:
            uri = uri[:uri.rindex("?")]
    mimetype = mimetypes.guess_type(uri)[0]
    return mimetype
    if mimetype: return mimetype

    ext = get_ext(uri)
    if ext == ".pls": mimetype = "audio/x-scpls"
    elif ext == ".m3u": mimetype = "audio/x-mpegurl"
    elif ext == ".asx": mimetype = "video/x-ms-asf"
    else: mimetype = ""
    return mimetype


def realuri(uri):
    if get_scheme(uri) == "file":
        return get_uri_from_path(os.path.realpath(get_path_from_uri(uri)))
    else:
        return uri

def read_entire_file(uri):
    data = ""
    if get_scheme(uri) == "file":
        f = file(get_path_from_uri(uri),"r")
        data = f.read()
        f.close()
    else:
        try:
            f = urlopen(uri)
            data = f.read()
            f.close()
        except :
            logger.exception("failed read %s",uri)
            data = ""
    return data

def make_uri_from_shell_arg(arg):
    scheme = get_scheme(arg)
    if scheme: return arg
    else: 
        return "file://"+pathname2url(os.path.abspath(os.path.expanduser(arg)))

def get_name(value):
    return get_path_from_uri(value).split("/")[-1]

def get_path_from_uri(value):
    if get_scheme(value) == "file":
        # escape "#" otherwise it will be interpreted as a url fragment by urlparse
        value = value.replace("#", "%23")
    return unquote(urlparse(value)[2])

def get_uri_from_path(value):
    if get_scheme(value): return value
    else: 
        return "file://"+quote(value)

def unescape_string_for_display(value):
    return unquote(value)

def safe_unlink(uri):
    if get_scheme(uri) != "file": return True
    else:
        path = get_path_from_uri(uri)
        if os.path.exists(path):
            return os.unlink(path)
        return False

def unlink(uri):
    if get_scheme(uri) != "file": return True
    else:
        path = get_path_from_uri(uri)
        return os.unlink(path)

def exists(uri):
    if get_scheme(uri) != "file": return True
    else:
        path = get_path_from_uri(uri)
        return os.path.exists(path)

def makedirs(uri,mode=0755):
    if uri.find("://")!=-1:
        path =  uri[uri.find("://")+3:]
    else:
        path = uri
    if not os.path.exists(path):
        os.makedirs(path, mode)

# http://developer.gnome.org/doc/API/2.0/glib/glib-running.html
if "G_FILENAME_ENCODING" in os.environ:
    fscoding = os.environ["G_FILENAME_ENCODING"].split(",")[0]
    if fscoding == "@locale": fscoding = locale.getpreferredencoding()
elif "G_BROKEN_FILENAMES" in os.environ:
    fscoding = locale.getpreferredencoding()
else: fscoding = "utf-8"

def fsdecode(s):
    """Decoding a string according to the filesystem encoding."""
    if isinstance(s, unicode): return s
    else: return decode(s, fscoding)

def fsencode(s):
    """Encode a string according to the filesystem encoding, replacing
    errors."""
    if isinstance(s, str): return s
    else: return s.encode(fscoding, 'replace')

def decode(s, charset="utf-8"):
    """Decode a string; if an error occurs, replace characters and append
    a note to the string."""
    try: return s.decode(charset)
    except UnicodeError:
        return s.decode(charset, "replace") + " " + _("[Invalid Encoding]")

def encode(s, charset="utf-8"):
    """Encode a string; if an error occurs, replace characters and append
    a note to the string."""
    try: return s.encode(charset)
    # FIXME: Can *this* happen?
    except UnicodeError:
        return (s + " " + _("[Invalid Encoding]")).encode(charset, "replace")

def pls_rebuild_uri(base_uri,uri):
    base_uri = base_uri[:base_uri.rfind("/")]
    if uri.find("://") != -1:
        return uri
    elif  uri[0] == "/":
        return "file://"+quote(uri)
    else:
        return base_uri+"/"+quote(uri)
    
""" Return all folder in a folder excepted hidden one """
def get_folder_in_folder(dir):
    dirs = set()
    alldirs = [ get_path_from_uri(dir) ]
    for mdir in alldirs:
        for dirpath, dirs, names in os.walk(mdir):
            [ dirs.remove(dir) for dir in dirs if dir[0] == "." ]
            [ alldirs.append(os.path.realpath(os.path.join(dirpath,dir))) for dir in dirs if os.path.islink(os.path.join(dirpath,dir)) ]
            dirs.add(get_uri_from_path(os.path.join(dirpath,dirs)))
            while gtk.events_pending():gtk.main_iteration()
    return dirs

""" Return all uri in a folder excepted hidden one """
def parse_folder(dir):
    dir = get_path_from_uri(dir)
    uris = [ get_uri_from_path(os.path.join(dir,name)) for name in os.listdir(dir) if name[0] != "." and os.path.isfile(os.path.join(dir,name)) ]
    print "W:Utils:ParseFolder:",len(uris),"founds"
    return uris

""" 
 - Receive a list of uris 
 - expand it 
 - check if exist
 - if directory recursive add all uri in directory
 - if playlist read all uri in playlist
 - return all supported file found
"""
def parse_uris(uris, follow_folder=True, follow_playlist=True, callback=None, *args_cb, **kwargs_cb):
    if not uris : return []
    from song import file_is_supported
    valid_uris = []
    for uri in uris:
        #Check file exists only is file is local to speed parsing of shared/remote file
        uri = unquote(uri)
        if uri and uri.strip()!="" and exists(uri):
            ext = get_ext(uri)
            info = None
            try:
                mimetype = get_mime_type(uri)
            except:
                logger.exception("failed to read file info from %s",uri)
                continue

            is_pls = False
            is_m3u = False
            is_xspf = False
            try:
                is_pls = (mime_type == "audio/x-scpls")
                is_m3u = (mime_type == "audio/x-mpegurl" or mime_type == "audio/mpegurl" or mime_type == "audio/m3u")
                is_xspf = (mime_type == "application/xspf+xml")
            except:
                pass
            is_pls = is_pls or (ext == ".pls")
            is_m3u = is_m3u or (ext == ".m3u")
            is_xspf = is_xspf or (ext == ".xspf")
                
            if islocaldir(uri) and follow_folder:
                valid_uris.extend(parse_uris(parse_folder(uri),follow_folder,follow_playlist))
            elif follow_playlist and is_pls:
                valid_uris.extend(parse_uris(get_uris_from_pls(uri),follow_folder,follow_playlist))
            elif follow_playlist and is_xspf:
                valid_uris.extend(parse_uris(get_uris_from_xspf(uri),follow_folder,follow_playlist))
            elif follow_playlist and is_m3u:
                valid_uris.extend(parse_uris(get_uris_from_m3u(uri),follow_folder,follow_playlist))
            elif get_scheme(uri) != "file" or file_is_supported(get_path_from_uri(uri)):
                valid_uris.append(uri)

    logger.info("parseuris found %s uris",len(valid_uris))
    if callback:
        def launch_callback(callback, uris, args, kwargs):
            callback(uris, *args, **kwargs)
        gobject.idle_add(launch_callback, callback,list(valid_uris), args_cb, kwargs_cb)
    else:
        return valid_uris

def async_parse_uris(*args, **kwargs):
    t = threading.Thread(target=parse_uris, args=args, kwargs=kwargs)
    t.setDaemon(True)
    t.start()


""" Return uri in a m3u playlist """
def get_uris_from_m3u(uri):
    uris = []    
    content = read_entire_file(uri)
    lines = content.splitlines()
    for line in lines:
        if not line.startswith("#") and line.strip()!="":
            uris.append(line.strip())
    uris = [pls_rebuild_uri(uri,u) for u in uris]
    return uris
    
""" Return uri in a pls playlist """
def get_uris_from_pls(uri):
    uris = []
    content = read_entire_file(uri)
    lines = content.splitlines()
    for line in lines:
        if line.lower().startswith("file") and line.find("=")!=-1:
           uris.append(line[line.find("=")+1:].strip())
    uris = [pls_rebuild_uri(uri,u) for u in uris]
    return uris

from xml.sax import parseString, handler, SAXParseException
class XSPFParser(handler.ContentHandler):
    def __init__(self):
        self.uris = []

    def startElement(self, name, attrs):
        self.content = ""

    def characters(self, content):
        self.content = self.content + content

    def endElement(self, name):
        if name == "location":
            self.uris.append(self.content)

""" Return uri in a xspf playlist """
def get_uris_from_xspf(uri):
    uris = []
    try: 
        handler = XSPFParser()
        parseString(read_entire_file(uri), handler)
    except:
        logger.exception("Failed to parse %s",uri)
        return []
    else:
        return handler.uris

def get_uris_from_asx(uri):
    uri_list= []
    uri_asx_list = [uri]
    while len(uri_asx_list) > 0:
        uri = uri_asx_list.pop()
        text = read_entire_file(uri)
        d = parseString(text)
        links = [ ref.getAttribute('HREF')
                for ref in d.getElementsByTagName('REF')
                if ref.hasAttribute('HREF') ]
        links.extend([ ref.getAttribute('href')
                for ref in d.getElementsByTagName('ref')
                if ref.hasAttribute('href') ])
        for link in links:
            if link[-4:] == ".asx" or (link.find("?") != -1 and link[link.find("?")-4:link.find("?")] == ".asx"):
                uri_asx_list.append(link)
            else:
                uri_list.append(link)
#    print "get_uris_from_asx",uri_list
    return uri_list

def async_get_uris_from_plain_text(content, callback=None, *args_cb, **kwargs):
    """ Return uri found in a string
For now return uri only if one line is one uri
use parse uri to follow directory and playlist """
    uris = [ line.strip() for line in content.splitlines() if line.strip() ]
    async_parse_uris(uris, True, True, callback, *args_cb, **kwargs_cb)

def get_uris_from_plain_text(content, callback=None, *args_cb, **kwargs):
    """ Return uri found in a string
For now return uri only if one line is one uri
use parse uri to follow directory and playlist """
    uris = [ line.strip() for line in content.splitlines() if line.strip() ]
    return parse_uris(uris, True, True, callback, *args_cb, **kwargs_cb)

def move_to_trash(uri):
    path = get_path_from_uri(uri)
    path = os.path.realpath(os.path.expanduser(path))
    if not os.path.exists(path): 
        logger.debug("File %s doesn't exists",path)
        return False
    #find the trash folder
    home_dir = os.path.realpath(os.path.expanduser("~"))
    dirs_name = path.split("/")
    dirs_name = filter(lambda name: name!="",dirs_name)
    trash_dir = None
    r = range(0,len(dirs_name))
    r.reverse()
    for i in r:
        tmp_path = os.path.realpath("/"+"/".join(dirs_name[:i]))
        if tmp_path == home_dir:
            trash_dir = home_dir+"/.local/share/Trash"
            trash_dir = os.environ.get("XDG_DATA_HOME",trash_dir)
            break
        elif os.path.ismount(tmp_path):
            trash_dir = tmp_path+"/.Trash-%d"%os.getuid()
            break
        else: continue
    if not trash_dir:
        logger.error("trash dir not found")
        return False

    for subdir in ["files", "info"]:
        if not os.path.exists(trash_dir+"/"+subdir):
            try:
                os.makedirs(trash_dir+"/"+subdir,0700)
            except: 
                logger.warn("Failed to create trash dir %s",trash_dir+"/"+subdir)
                return False

    if path.rfind("/")!=-1:
        filename = path[path.rindex("/")+1:]

    deleteddate = time.strftime("%Y-%M-%dT%H:%M:%S")
    destpath = trash_dir+"/files/"+filename
    infopath = trash_dir+"/info/"+filename+".trashinfo"
    try:
        shutil.move(path, destpath)
        f = open(infopath,"w")
        f.write("[Trash Info]\nPath=%s\nDeletionDate=%s\n"%(quote(path),deleteddate))
        f.close()
    except: 
        logger.exception("Failed to move to trash %s", path)
        return False
    else: return True

def download_iterator(remote_uri, local_uri, buffer_len = 4096):
    try:
        logger.info("download %s start",remote_uri)
        handle_read = urlopen(remote_uri)
        handle_write = file(get_path_from_uri(local_uri),"w")
        info = handle_read.info()
    
        try: totalsize = int(info.getheader("content-length"))
        except : totalsize = 20000000
        currentsize = 0
        data = handle_read.read(buffer_len)
        handle_write.write(data)
        currentsize += len(data)
        
        last_event = None
        while data:
            data = handle_read.read(buffer_len)
            currentsize += len(data)
            handle_write.write(data)
            percent = currentsize*100/totalsize
            yield (totalsize,currentsize,percent)

        handle_read.close()
        handle_write.close()
        logger.info("download %s finish"%remote_uri)
    except GeneratorExit:
        try: unlink(local_uri)
        except: pass
    except:
        logger.exception("Error while downloading %s",remote_uri)
        try: unlink(local_uri)
        except: pass
        raise IOError

def download(remote_uri, local_uri, buffer_len = 4096):
    try:
        logger.info("download %s start",remote_uri)
        handle_read = urlopen(remote_uri)
        handle_write = file(get_path_from_uri(local_uri),"w")
        
        data = handle_read.read(buffer_len)
        handle_write.write(data)
        
        while data:
            data = handle_read.read(buffer_len)
            handle_write.write(data)

        handle_read.close()
        handle_write.close()
        logger.info("download %s finish"%remote_uri)
    except:
        logger.exception("Error while downloading %s",remote_uri)
        try: unlink(local_uri)
        except: pass
        return False
    if not exists(local_uri): 
        return False
    return True
