# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import gobject
import gtk
import os


import utils
import vfs

from const import VERSION, AUTHORS, TRANSLATORS
from xdg_support import get_xdg_pixmap_file
from song import Song
from library import ListenDB
from widget.misc import ScrolledWindow

from helper import Dispatcher
               
class WindowBase(gtk.Dialog):
    def __init__(self,title="",image=None,bouton = (
                        gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                        gtk.STOCK_OK, gtk.RESPONSE_ACCEPT) ):
        gtk.Dialog.__init__(self,title,None,
                 gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                     bouton
                 )

        self.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        self.set_resize_mode(False)
        self.set_border_width(6)
        self.set_modal(True)
        self.set_property("skip-taskbar-hint",True)
        self.set_has_separator(False)

        self.label_heading = gtk.Label("<span size=\"larger\"><b>"+title+"</b></span>")
        self.label_heading.set_alignment(0,0.5)
        self.label_heading.set_use_markup(True)

        self.box_contenu = gtk.VBox(False,6)
        self.box_contenu.pack_start(self.label_heading,False,False)
        #self.box_contenu.set_border_width(12)
        if bouton:
            self.set_default_response(bouton[-1:][0])
        hbox = gtk.HBox(False,12)

        if image:
            if isinstance(image,str):
                wimage = gtk.Image()
                wimage.set_from_file(image)
                wimage.set_alignment(0,0)
            else:
                wimage = image
            a = gtk.Alignment(xalign=0.0)
            a.add(wimage)
            hbox.pack_start(a,False,False)

        hbox.pack_start(self.box_contenu,True,True)
        hbox.set_border_width(6)

        self.vbox.pack_start(hbox,False,False)
        self.vbox.set_spacing(6)
        self.set_resizable(False)

    def add_widget(self,widget,x=False,y=False):
        self.box_contenu.pack_start(widget,x,y)

class WinDir(gtk.FileChooserDialog):
    def __init__(self,title=_("Import a folder in the library")):
        gtk.FileChooserDialog.__init__(self,title, None,
             gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
             
        self.set_modal(True)
        self.set_current_folder(os.path.expanduser("~/"))

    def run(self):
        response = gtk.FileChooserDialog.run(self)
        folder = None
        if response == gtk.RESPONSE_OK:
             folder = self.get_filename()
             folder = self.get_uri()
        self.destroy()
        return folder

class WinURI(WindowBase):
    def __init__(self,title = _("Open a uri"), text = _("Uri:") ):
        WindowBase.__init__(self, title, get_xdg_pixmap_file("playlist_big.png") )
        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',True)
        self.label_heading.set_markup("<span size=\"larger\"><b>"+text+"</b></span>")

        self.entry_uri = gtk.Entry()
        self.entry_uri.set_size_request(300,-1)
        self.entry_uri.set_activates_default(True)
            
        self.add_widget(self.entry_uri)
        self.show_all()
    
    def run(self):
        uri = None
        response = WindowBase.run(self)
        if response == gtk.RESPONSE_ACCEPT and self.entry_uri.get_text().strip() != "":
            uri = self.entry_uri.get_text().strip()
        self.destroy()
        return uri

class WinURIold(gtk.FileChooserDialog):
    def __init__(self,title=_("Open a file")):    
        gtk.FileChooserDialog.__init__(self,title, None,
             gtk.FILE_CHOOSER_ACTION_OPEN,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
             
        self.set_modal(True)
        self.set_current_folder(os.path.expanduser("~/"))

    def run(self):
        response = gtk.FileChooserDialog.run(self)
        folder = None
        self.set_modal(True)
        if response == gtk.RESPONSE_OK:
             folder = self.get_filename()
             folder = self.get_uri()
        self.destroy()
        return folder
            
class WinFile(gtk.FileChooserDialog):
    def __init__(self,title=_("Import a file in the library")):    
        gtk.FileChooserDialog.__init__(self,title, None,
             gtk.FILE_CHOOSER_ACTION_OPEN,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
             
        self.set_modal(True)
        self.set_current_folder(os.path.expanduser("~/"))

    def run(self):
        response = gtk.FileChooserDialog.run(self)
        folder = None
        self.set_modal(True)
        if response == gtk.RESPONSE_OK:
             folder = self.get_filename()
             folder = self.get_uri()
        self.destroy()
        return folder
            
class WindowConfirmation(WindowBase):
    def __init__(self,title,msg=""):
        image = gtk.image_new_from_stock(gtk.STOCK_DISCARD,gtk.ICON_SIZE_DIALOG)
        WindowBase.__init__(self,title,image)
        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',False)
        if not msg: msg = ""
        if isinstance(msg,str) or isinstance(msg,unicode):
            label = gtk.Label(msg)
            label.set_alignment(0,0)
            self.add_widget(label)
        else:
            self.add_widget(msg)
        self.show_all()

class WindowMessage(WindowBase):
    def __init__(self,title,msg=None,image=None):
        if image == None:
            image = gtk.image_new_from_stock(gtk.STOCK_DIALOG_INFO,gtk.ICON_SIZE_DIALOG)
        WindowBase.__init__(self,title,image,(gtk.STOCK_CLOSE, gtk.RESPONSE_CANCEL) )

        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',False)
        if msg==None:msg=""
        if isinstance(msg,str) or isinstance(msg,unicode):
            label = gtk.Label(msg)
            label.set_alignment(0,0)
            self.add_widget(label)
        else:
            self.add_widget(msg)
        self.show_all()
        self.run()
        self.destroy()
        
class WindowError(WindowBase):
    def __init__(self,title,msg=None,image=None):
        if image == None:
            image = gtk.image_new_from_stock(gtk.STOCK_DIALOG_INFO,gtk.ICON_SIZE_DIALOG)
        WindowBase.__init__(self,title,image,(gtk.STOCK_CLOSE, gtk.RESPONSE_CANCEL) )

        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',False)
        if msg==None:msg=""
        if isinstance(msg,str) or isinstance(msg,unicode):
            wtext = gtk.TextView(gtk.TextBuffer())
            wtext.get_buffer().set_text(msg)
            wtext.set_editable(False)
            padding = 5
            wtext.set_property("pixels-above-lines",padding)
            wtext.set_property("pixels-below-lines",padding)
            wtext.set_property("right_margin",padding)
            wtext.set_property("left_margin",padding)
            self.add_widget(ScrolledWindow(wtext))
        else:
            self.add_widget(msg)
        self.show_all()
        self.run()
        self.destroy()
        
class WindowNewPodcast(WindowBase):
    def __init__(self):
        WindowBase.__init__(self,
                         _("New podcast feed"),
                         get_xdg_pixmap_file("podcast_big.png")
                    )
        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',True)
        self.entry_uri = gtk.Entry()
        self.entry_uri.set_size_request(300,-1)
        self.label_heading.set_markup("<span size=\"larger\"><b>"+_("Podcast feed url :")+"</b></span>")

        self.add_widget(self.entry_uri)
        self.show_all()

        response = self.run()
        uri = None
        if response == gtk.RESPONSE_ACCEPT and self.entry_uri.get_text().strip() != "":
            uri = self.entry_uri.get_text().strip()
        self.destroy()
        if uri:
            from source.podcast import FeedsDownloadJob
            FeedsDownloadJob(uri)
        
        
class WindowExportPlaylist(gtk.FileChooserDialog):
    def __init__(self,songs):
        self.songs = songs
        gtk.FileChooserDialog.__init__(self,_("Export playlist"), None,
             gtk.FILE_CHOOSER_ACTION_SAVE,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_SAVE, gtk.RESPONSE_OK))
             
        self.set_modal(True)
        self.set_current_name("playlist.xspf")
        self.set_current_folder(os.path.expanduser("~/"))

    def run(self):
        response = gtk.FileChooserDialog.run(self)
        self.set_modal(True)
        if response == gtk.RESPONSE_OK:
             filename = self.get_filename()
             if vfs.get_ext(filename) in [".m3u",".pls",".xspf"]:
                 utils.export_playlist(self.songs,filename,vfs.get_ext(filename,False))
             else:
                 pl_type = ".m3u"
                 filename = filename+"."+pl_type
                 utils.export_playlist(self.songs,filename,pl_type)
        
        self.destroy()
        
class WindowLoadPlaylist(gtk.FileChooserDialog):
    def __init__(self):
        
        gtk.FileChooserDialog.__init__(self,_("Load playlist"), None,
             gtk.FILE_CHOOSER_ACTION_OPEN,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
             
        self.set_modal(True)
        ffilter = gtk.FileFilter()
        ffilter.set_name(_("Playlist files"))
        ffilter.add_mime_type("audio/mpegurl")
        ffilter.add_mime_type("audio/x-mpegurl")
        ffilter.add_mime_type("audio/m3u")
        ffilter.add_mime_type("audio/x-scpls")
        ffilter.add_mime_type("application/xspf+xml")
        ffilter.add_pattern("*.m3u")
        ffilter.add_pattern("*.pls")
        ffilter.add_pattern("*.xspf")
        self.add_filter(ffilter)
        
        self.set_current_folder(os.path.expanduser("~/"))

    def run(self):
        response = gtk.FileChooserDialog.run(self)
        self.set_modal(True)
        if response == gtk.RESPONSE_OK:
            uri = self.get_uri()
            name = vfs.fsdecode(vfs.get_name(uri))
            name = name[:len(name)-len(vfs.get_ext(name))]
            name = name[0].upper()+name[1:]

            def uri_parser_cb(uris, name):
                songs = [ListenDB.get_or_create_song({"uri":uri},"local") for uri in uris]
                ListenDB.create_playlist("local",name,songs)

            vfs.async_parse_uris([uri], True, True, uri_parser_cb, name)
            
        
        self.destroy()
    
class ListenAbout(gtk.AboutDialog):
    def __init__(self):
        super(ListenAbout,self).__init__()
    
        self.set_modal(True)
        self.set_comments("""A music player for GNOME
        Copyright 2006 Mehdi Abaakouk <theli48@gmail.com>""")
        self.set_website("http://www.listen-project.org/")
        self.set_name("Listen Music Player")
        self.set_authors(AUTHORS.split("\n"))
        self.set_translator_credits(TRANSLATORS)
        self.set_version(VERSION)
        self.set_logo(gtk.gdk.pixbuf_new_from_file( get_xdg_pixmap_file("listen_big.png") ))
        self.show_all()
        self.run()
        self.destroy()
