# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# gtktrayicon.py is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2008 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


# TODO: code orientation
# TODO: find better idea to catch dock unembed than check the delete event

import gobject
import gtk
from Xlib import display as Xdisplay, Xatom, protocol as Xprotocol, X

__all__ = ["TrayIcon"]

SYSTEM_TRAY_REQUEST_DOCK = 0
SYSTEM_TRAY_BEGIN_MESSAGE = 1
SYSTEM_TRAY_CANCEL_MESSAGE = 2
TIMEOUT_DOCK_RECONNECT = 500

class TrayIcon(gtk.Plug):
    __gproperties__ = {
         'orientation' : (gobject.TYPE_INT,
                   'panel orientation',
                   'orientation of the panel',
                   0,
                   1,
                   0,
                   gobject.PARAM_READABLE)
    }

    def __init__(self,name):
        gtk.Plug.__init__(self,0L)
        self.__manager_window = None
        self.__stamp = 1
        self.orientation = gtk.ORIENTATION_HORIZONTAL
        #self.set_events(gtk.gdk.ALL_EVENTS_MASK)
        self.connect("event",self.on_event)
        self.connect("embedded",self.embedded)
        self.connect("realize",self.on_realize)
        self.connect("unrealize",self.on_unrealize)
        self.connect("notify::visible",self.on_visibility_change)
        
        self.__timeout_id = None
        self.__visible_lock = False
        self.__last_visibility = self.get_property("visible")
        gobject.timeout_add(100,self.check_connection)

    def add(self, widget):
        widget.connect("realize",self.make_transparent)
        gtk.Plug.add(self,widget)

    def do_get_property(self, property):
        if property.name == 'orientation':
            return self.orientation
        else:
            return gtk.Plug.do_get_property(self, property)

    def on_visibility_change(self,widget,param):
        if not self.__visible_lock:
            self.__last_visibility = self.get_property("visible")

    def check_connection(self):
        if not self.__manager_window and not self.__timeout_id:
            self.timeout_id = gobject.timeout_add(TIMEOUT_DOCK_RECONNECT,self.reconnect_dock)
        return False

    def on_event(self,widget,event):
        if event.type == gtk.gdk.DELETE and not event.send_event:
            if not self.__timeout_id:
                self.__manager_window = None
                self.__visible_lock = True
                self.hide()
                self.__visible_lock = False
                self.__timeout_id = gobject.timeout_add(TIMEOUT_DOCK_RECONNECT,self.reconnect_dock)
            return True
        else:
            return False

    def reconnect_dock(self):
        if self.update_manager_window(False):
            self.send_dock_request()
            if self.__last_visibility:
                self.show()
            self.__visible_lock = False
            self.timeout_id = None
            return False
        return True

    def embedded(self,plug):
        return 

    def on_realize(self,widget):
        screen = self.get_screen()
        display = screen.get_display()
        xdisplay = self.get_xdisplay()
        
        self.make_transparent(widget)
        buffer = "_NET_SYSTEM_TRAY_S%d"%screen.get_number()
        self.selection_atom = xdisplay.get_atom(buffer,False)
        self.manager_atom = xdisplay.get_atom("MANAGER",False)
        self.system_tray_opcode_atom = xdisplay.get_atom("_NET_SYSTEM_TRAY_OPCODE",False)
        self.orientation_atom = xdisplay.get_atom("_NET_SYSTEM_TRAY_ORIENTATION",False)
        self.update_manager_window(False)
        self.send_dock_request()

#                w = screen.get_root_window()
#                if w not in self.window_filtered:
#                    w.add_filter(self.manager_filter,w)
#                    self.window_filtered.add(w)
#                self.window_filtered_realized.add(w)
#
    def on_unrealize(self,widget):
        return 
        if self.__manager_window:
            gdkwin = self.get_gdkwin_for_display(self.get_display(), self.__manager_window.id)
            #gdkwin.remove_filter(self.manager_filter)
            self.window_filtered_realized.remove(gdkwin)

        root_window = self.get_screen().get_root_window()
        #root_window.remove_filter(self.manager_filter)
        self.window_filtered_realized.remove(root_window)

    def make_transparent(self,widget, *args):
        if not hasattr(widget,"window") or not widget.window or widget.get_property("app-paintable"): 
            return 
        widget.set_app_paintable(True)
        widget.set_double_buffered(False)
        widget.window.set_back_pixmap(None,True)
        widget.connect("expose-event",self.transparent_expose_event)
        widget.connect("style-set",self.make_transparent_again)

    def transparent_expose_event(self, widget, event):
        widget.window.clear_area(event.area.x,event.area.y,event.area.width,event.area.height)
        return False

    def make_transparent_again(self, widget, style):
        widget.window.set_back_pixmap(None,True)
 
    
    def get_xdisplay(self):
        name = self.get_display().get_name()
        xdisplay =  Xdisplay.Display(name)
        return xdisplay

    def update_manager_window(self,dock_if_realized):
        if self.__manager_window :  return True

        xdisplay = self.get_xdisplay()
        xdisplay.grab_server()
        try: self.__manager_window = xdisplay.get_selection_owner(self.selection_atom)
        except: return False
        
        if self.__manager_window:
            #TODO: Fixes the freeze when position event_mask
            #self.__manager_window.change_attributes(None, { "event_mask": X.StructureNotifyMask | X.PropertyChangeMask } )
            pass
            
        xdisplay.ungrab_server()
        xdisplay.flush()
        if self.__manager_window :

#                    gdkwin = self.get_gdkwin_for_display(self.get_display(), self.__manager_window.id)
#                    if gdkwin in self.window_filtered:
#                        gdkwin.add_filter(self.manager_filter,gdkwin)
#                        self.window_filtered.add(gdkwin)
#                    self.window_filtered_realized.add(gdkwin)
#
            if dock_if_realized and self.flags() & gtk.REALIZED:
                self.send_dock_request()

            self.get_orientation_property()
            return True
        return False

    def get_orientation_property(self):
        assert(self.__manager_window != None)
        xdisplay = self.get_xdisplay()
        result = self.__manager_window.get_property(self.orientation_atom,6,0L,32000L,0)
        if not result or not list(result.value): 
            return
        else: 
            if int(list(result.value)[0]) == 0:
                self.orientation = gtk.ORIENTATION_HORIZONTAL
            else:
                self.orientation = gtk.ORIENTATION_VERTICAL

    def get_gdkwin_for_display(self,display,anid):
        gdkwin = gtk.gdk.window_lookup_for_display(display,anid)
        if not gdkwin: gdkwin = gtk.gdk.window_foreign_new_for_display(display,anid)
        return gdkwin
        
    def send_dock_request(self):
        self.send_manager_message(SYSTEM_TRAY_REQUEST_DOCK,self.__manager_window,self.get_id(),0L,0L)

    def send_manager_message(self,message,xwindow,data1,data2,data3):
        ev = Xprotocol.event.ClientMessage( \
                window = xwindow, \
                client_type = self.system_tray_opcode_atom, \
                data = (32, (0,message,data1,data2,data2)) \
                )
        dest = self.get_xdisplay()
        dest.send_event(xwindow,ev,X.NoEventMask)
        dest.sync()

    def send_message(self,timeout, message, l):
        if not message: return 0
        if timeout < 0: return 0
        if not self.__manager_window: return 0
        if l <= 0 : l = len(message)
        self.stamp += 1
        stamp = self.stamp
        self.send_manager_message(SYSTEM_TRAY_BEGIN_MESSAGE,self.get_id(),timeout, l, stamp)
        
        while l > 0:
            xdisplay = display.Display()
            if l > 20:
                messagecur = message[20]
                l -= 20
            else:
                messagecur = message
                l = 0
            ev = Xprotocol.event.ClientMessage( \
                    window = self.get_id(), \
                    client_type = xdisplay.get_atom("_NET_SYSTEM_TRAY_MESSAGE_DATA",False), \
                    data = (8, messagecut ) \
                    )
            message = message[20:]
            dest = d.Display()
            dest.send_event(ev,X.StructureNotifyMask)
            dest.sync(False)

        return stamp

    def cancel_message(self,id):
        if id <= 0: return 0
        self.send_manager_message(SYSTEM_TRAY_CANCEL_MESSAGE, self.get_plug(),0,0)

    def manager_filter(self,event,gdkwin):
        print dir(event),event.type
        return gtk.gdk.FILTER_CONTINUE


