# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gobject
import gtk
import stock
from config import config
import utils

from dbus_manager import ListenDBus
from hal import hal

from player import Player

from widget.tray import TrayIcon
from widget.source_ui import SourceUI
from widget.dialog import WindowNewPodcast, ListenAbout, WindowLoadPlaylist, WinFile, WinURI
    
from widget.preference import PreferenceDialog
from widget.plugins_preferences import PluginsPreferenceDialog
from library import ListenDB

from widget.notify import Notify
from widget.osd import Osd
from widget.misc import ScrolledWindow
from widget.playlist import PlaylistUI
from widget.menubar import ListenMenuBar
from widget.smart_playlist import SmartPlaylistWindow

from xdg_support import get_xdg_pixmap_file
from vfs import FileMonitor, async_parse_uris
from helper import Dispatcher
from mmkeys_wrap import MMKeys
from logger import Logger

#TODO: Remove that
from source.webradio import WindowNewRadio

class Listen(gtk.Window,Logger):
    __obscured = False
    __gsignals__ = {
        "ready" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                ())}
    def __init__(self):
        
        #Start Audioscrobbler Session
        
        gtk.Window.__init__(self,gtk.WINDOW_TOPLEVEL)
        gtk.window_set_default_icon_from_file( get_xdg_pixmap_file("listen.png") )
        
        self.set_title("Listen")
        
        if config.get("window","x")=="-1":
            self.set_position(gtk.WIN_POS_CENTER)
        else:
            self.move(int(config.get("window","x")),int(config.get("window","y")))

        try: self.resize(int(config.get("window","width")),int(config.get("window","height")))
        except:pass
        
                
        window_state = config.get("window","state")
        if window_state == "maximized" :
            self.maximize()
        if window_state == "normal":
            self.unmaximize()

        self.global_box = gtk.HPaned()
        self.global_box.set_border_width(6)
        self.global_box.compute_position(-1,300,True)
        
        self.menubar = ListenMenuBar()

        self.source_ui = SourceUI()
        self.playlist_ui = PlaylistUI(self.menubar)
         
        # Set player source to a static playlist for now
        Player.set_source(self.playlist_ui.playlist)

        if config.get("window","right_layout") == "true":
            self.global_box.pack1(self.source_ui,False,False)
            self.global_box.pack2(self.playlist_ui,True,True)
        else:
            self.global_box.pack1(self.playlist_ui,False,False)
            self.global_box.pack2(self.source_ui,True,True)
        self.global_box.child_set_property(self.global_box.get_child1(),"resize",True)
        self.global_box.child_set_property(self.global_box.get_child2(),"resize",True)

        self.global_box.set_position(int(config.get("window","pos_global_pane")))
        
        
        #Attach accel from playlist
        self.add_accel_group(self.playlist_ui.playlist.ui.get_accel_group())

        vbox = gtk.VBox(spacing=0)
        vbox.pack_start(self.get_main_menu(),False,False)
        vbox.pack_start(self.global_box,True,True)
        self.add(vbox)

        Dispatcher.connect("quit",self.force_quit)
        self.connect("delete-event",self.quit)
        self.connect("configure-event",self.on_configure_event)
        
        Player.connect("instant-new-song",self.update_title)
        ListenDB.connect("simple-changed",self.update_title)
        
        Player.connect("played",self.swap_menu_play,Player,_("Pause"),gtk.STOCK_MEDIA_PAUSE,"listen_tray_play.png")
        Player.connect("paused",self.swap_menu_play,Player,("Play"),gtk.STOCK_MEDIA_PLAY,"listen_tray_pause.png")
        Player.connect("stopped",self.swap_menu_play,Player,("Play"),gtk.STOCK_MEDIA_PLAY,"listen_tray.png")
        
        self.tray = TrayIcon(self)

        self.osd = Osd(self.tray)
        self.notify = Notify(self.tray)
        self.dbus_service = ListenDBus(self)

        self.mmkeys = MMKeys()

        self.pos = None
        if config.get("window","view")=="3":
            config.set("window","view","2")
        self.change_view(int(config.get("window","view")))
        
        if config.get("window","view")=="2":
            width = config.get("window","width")
        else:
            width = config.get("window","pos_global_pane")
        try: self.resize(int(width),int(config.get("window","height")))
        except:pass
        
        if config.get("setting","start_trayicon")!="true" or config.get("setting","use_trayicon")!="true":
            gobject.idle_add(self.ready,True)
        else:
            gobject.idle_add(self.ready,False)
        if config.get("setting","use_trayicon")=="true" and self.tray.tray!=None:
            self.tray.tray.show_all()
            
    def ready(self,show):
        if show: self.show_all()
        self.playlist_ui.playlist.load()
        self.emit("ready")
        
    def quit(self,*param):
        self.tray.cacher()
        if config.get("setting","fermer_trayicon")=="false" or self.tray.tray==None:
            self.force_quit()
        return True
    
    def force_quit(self,*param):
        Player.save_state()
        if not Player.is_paused(): Player.pause()
        self.tray.cacher()
        self.tray.set_tray_icon("listen_tray_save.png")
        # wait fadeout done
        gobject.timeout_add(500,self.__idle_quit)
            
    def __idle_quit(self,*param):
        print "Exiting..."
        Player.stop()
        self.mmkeys.release()
        self.notify.close_notification()
        self.tray.cacher()
        config.set("window","pos_global_pane","%d"%self.global_box.get_position())
        self.source_ui.save()
        self.playlist_ui.playlist.save(close=True)
        ListenDB.save()
        FileMonitor.close()
        config.write()
        gtk.main_quit()
        print "Exit successful"
     
    def update_title(self,*args):
        song = Player.song
        if config.getboolean("setting", "update_title") and song: 
            title = ""
            sep = ""
            if song.get_str("title"):
                title += sep+song.get_str("title")+" "
                sep=" - "
            if song.get_str("artist"):
                title += sep+song.get_str("artist")+" "
                sep=" - "
            if song.get_str("album"):
                title += song.get_str("album")
            title = title.replace("\n",",  ")
            title = "Listen  "+"\xe2\x99\xaa "+title+" "+"\xe2\x99\xaa "
        else:
            title = "Listen"
    
        self.set_title(title)

    def on_configure_event(self,widget=None,event=None):
        #windows property
        if widget.get_property("visible") and config.get("window","view")!="3":
            if self.get_resizable():
                if config.get("window","view")=="2":
                    config.set("window","width","%d"%event.width)
                else :
                    config.set("window","pos_global_pane","%d"%event.width)
                config.set("window","height","%d"%event.height)
            config.set("window","x","%d"%event.x)
            config.set("window","y","%d"%event.y)

    def change_view(self,num_view):
        self.source_ui.show_all()    
        self.source_ui.set_no_show_all(True)  
        self.playlist_ui.box_playlist.show_all()  
        self.playlist_ui.box_playlist.set_no_show_all(True)

        if self.pos:
            self.set_keep_above(False)
            self.unfullscreen()
            gobject.idle_add(self.move,*self.pos)
            self.pos = None
            
        if num_view == 3: #Party mode
            self.pos = self.get_position()
            
            self.source_ui.show()
            self.playlist_ui.box_playlist.show()
            self.set_resizable(True)
            self.resize(int(config.get("window","width")),int(config.get("window","height")))
            self.global_box.set_position(int(config.get("window","pos_global_pane")))
            
            
            self.set_keep_above(True)
            gobject.idle_add(self.fullscreen)
            
            
        elif num_view == 2 :#FULL VIEW  
            self.source_ui.show()
            self.playlist_ui.box_playlist.show()
            self.set_resizable(True)
            self.resize(int(config.get("window","width")),int(config.get("window","height")))
            self.global_box.set_position(int(config.get("window","pos_global_pane")))

            
        elif num_view == 1 :#NORMAL VIEW
            self.source_ui.hide()
            self.playlist_ui.box_playlist.show()
            self.set_resizable(True)
            self.resize(int(config.get("window","pos_global_pane")),int(config.get("window","height")))
            
        elif num_view == 0:#PLAYER  VIEW
            self.source_ui.hide()
            self.playlist_ui.box_playlist.hide()
            self.resize(int(config.get("window","pos_global_pane")),int(config.get("window","height")))
            self.set_resizable(False)
            #self.set_size_request(300,-1)

        config.set("window","view","%d"%num_view)
        
    def open_uri_win(self,w):
        uri = WinURI().run()
        if uri:
            ListenDB.get_or_create_song({"uri":uri},"unknown")
            self.playlist_ui.playlist.play_uris([uri])

    def open_file2_win(self,w):
        uri = WinFile().run()
        if uri:
           self.window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
           async_parse_uris( [uri], True, True,
                    self.playlist_ui.playlist.play_uris, pos = None, sort = True)

    def open_file_win(self,w):
        from source.local import ImportFileJob
        ImportFileJob()
        
    def open_folder_win(self,w):
        from source.local import ImportFolderJob
        ImportFolderJob()
        
    def reload_local_db(self,s):
        from source.local import ReloadDB
        ReloadDB()
        
    def open_podcast_win(self,w):
        WindowNewPodcast()
    
    def open_radio_win(self,w):
        WindowNewRadio()
    
    def open_about_dialog(self,w):
        ListenAbout()
    
    def open_pref_dialog(self,w):
        PreferenceDialog(self,self.osd)
        
    def open_plugins_dialog(self,w):
        PluginsPreferenceDialog(self)
    
    def player_control(self,action):
        name = action.get_name()
        getattr(Player, name)()
              
    def menu_control(self,action):
        name = action.get_name()
        getattr(self.playlist_ui.playlist, name)()

    def new_playlist(self,s):
        ListenDB.create_playlist("local","New Playlist")
        
    def new_playlist_smart(self,s):
        pl = ListenDB.create_autoplaylist("local","local","New Automatic Playlist")
        SmartPlaylistWindow(pl, True).run()

        
    def download_cover(self,w):
        from source.local import CoverDownloadJob
        CoverDownloadJob()
    
    def load_playlist(self,s):
        WindowLoadPlaylist().run()
    
    def save_playlist(self,s):
        self.playlist_ui.playlist.save_to_library()
    
    def swap_menu_play(self,w,player,name,stock,image):
        action = self.ui.get_action("/MenuBar/Control/playpause")   
        action.set_property("stock-id",stock)
        action.set_property("label",name)
        self.tray.set_tray_icon(image)
        
    def get_main_menu(self):
        menu = """
        <ui>
          <menubar name="MenuBar">
            <menu action="Music">
              <menuitem action="OpenFile"/>
              <menuitem action="OpenUri"/>
              <separator />
              <menuitem action="AddFile"/>
              <menuitem action="AddPath"/>
              <separator />
              <menuitem action="ReloadDB"/>
              <menuitem action="DownloadCover"/>
              <separator />
              <menu action="Playlist">
                  <menuitem action="NewPlaylist"/>
                  <menuitem action="NewPlaylistSmart"/>
                  <menuitem action="LoadPlaylist"/>
                  <separator />
                  <menuitem action="SavePlaylist"/>
              </menu>
              <menuitem action="AddRadio"/>
              <menuitem action="AddPodcast"/>
              <separator />
              <menuitem action="Config"/>
              <menuitem action="Plugins"/>
              <menuitem action="OfflineMode"/>
              <separator />
              <menuitem action="Quit"/>
            </menu>
            <menu action="View">
              <menuitem action="Player"/>
              <menuitem action="PlayerPlaylist"/>   
              <menuitem action="Full"/>   
              <menuitem action="Party"/>
              <separator />
              <menu action="BrowserView">
                  <menuitem action="browserview0"/>
                  <menuitem action="browserview1"/>
                  <menuitem action="browserview2"/>
              </menu>
            </menu>
            <menu action="Control">
              <menuitem action="playpause"/>
              <menuitem action="rewind"/>
              <menuitem action="forward"/>
              <separator />
              <menuitem action="previous"/>
              <menuitem action="next"/>
              <separator />
              <menuitem action="random_reorder"/>
              <menuitem action="shuffle"/>
              <menuitem action="repeat"/>
            </menu>
            %s
            <menu action="Help">
              <menuitem action="About"/>
            </menu>
          </menubar>
        </ui>
        """
        
        #<menuitem action="stop"/>

        ag = gtk.ActionGroup('Listen')
        
        ag.add_actions([('Music', None, _('_Music')),
                      ('View', None, _('_View')),
                      ('Help', None, _('_Help')),
                      ('BrowserView', None, _('_Browser view')),
                      ('SongView', None, _('_Song view')),
                      ('Control', None, _('_Control')),
                      ('Playlist', None, _('_Playlist')),
                      ('MediaSource', None, _('Middle pane')),
                      ('OpenFile', stock.OPEN_FILE, None, "","", self.open_file2_win),
                      ('OpenUri', stock.OPEN_URI, None, "","", self.open_uri_win),
                      ('AddFile', stock.IMPORT_FILE,None,None,"", self.open_file_win),
                      ('AddPath', stock.IMPORT_FOLDER, None, "<Control>o","", self.open_folder_win),
                      ('ReloadDB',gtk.STOCK_REFRESH,_("Reload Library"),"","",self.reload_local_db),
                        
                      ('AddRadio', gtk.STOCK_NEW, _('New Internet Radio Station'), "<Control>i","", self.open_radio_win),
                      ('AddPodcast', gtk.STOCK_NEW, _('_New Podcast feed'), "<Control>p","", self.open_podcast_win),
                      
                      ('NewPlaylist', stock.SRC_PLAYLIST, _('_New Playlist'), "<Control>n","", self.new_playlist),
                      ('NewPlaylistSmart', stock.SRC_PLAYLIST_SMART, _('New _Automatic Playlist...'), None,"", self.new_playlist_smart),
                      ('LoadPlaylist', None, _('Load from file...'), None,"", self.load_playlist),
                      ('SavePlaylist', gtk.STOCK_SAVE , _('Save Current Playlist'), "<Control>s","", self.save_playlist),

                      ('About', gtk.STOCK_ABOUT, _('_About'), None,"", self.open_about_dialog),

                      ('Config', gtk.STOCK_PREFERENCES, _('P_references'), None,"", self.open_pref_dialog),
                      ('Plugins', gtk.STOCK_PREFERENCES, _('Plugins'), None,"", self.open_plugins_dialog),
                      ('Quit', gtk.STOCK_QUIT, _('_Quit'), "<Control>q","", self.force_quit),
                      ('playpause', gtk.STOCK_MEDIA_PLAY, _('_Play'), "<Control>space","", self.player_control),
                      #('stop', gtk.STOCK_MEDIA_STOP, _('_Stop'), None,"", self.player_control),
                      ('previous', gtk.STOCK_MEDIA_PREVIOUS, _('_Previous'), "<Alt>Left","", self.player_control),
                      ('next', gtk.STOCK_MEDIA_NEXT, _('_Next'), "<Alt>Right","", self.player_control),
                      ('rewind', gtk.STOCK_MEDIA_REWIND, _('_Rewind'), "<Control>Left","", self.player_control),
                      ('forward', gtk.STOCK_MEDIA_FORWARD, _('_Forward'), "<Control>Right","", self.player_control),
                      ("DownloadCover",None,_("Download missing cover"),None,"",self.download_cover),
                      ('random_reorder', stock.SHUFFLE, _('_Shuffle'), "<control>u","", self.playlist_ui.playlist.random_reorder),
                      
                     ])
                     
        browser_value = int(config.get("browser","view"))
        
        def on_change_browser(widget,radiobtn):
            config.set("browser","view","%d"%radiobtn.get_current_value())
                    
        ag.add_radio_actions([('browserview0', None, _('Artist and album'), None,None,0),
                                       ('browserview1', None, _('Genre and artist'), None,None,1),
                                       ('browserview2', None, _('Genre, artist and album'), None,None,2)],browser_value, on_change_browser)
                     
        def on_change_view(widget,radiobtn):
            self.change_view(radiobtn.get_current_value())
            

        ag.add_radio_actions([('Player', None, _('_Small Display'), "<control>d",None,0),
                              ('PlayerPlaylist', None, _('_Normal Display'), "<control>g",None,1),
                              ('Full', None, _('Full Display'), "<control>f",None,2),
                              ('Party', None, _('Party mode'), "<control>h",None,3)],int(config.get("window","view")), on_change_view)
                                                     
        ag.add_toggle_actions([
           ('repeat', None, _('_Repeat'), "<control>r",None,None,config.getboolean("setting","repeat_mode")),
           ('shuffle', stock.SHUFFLE, _('_Randomise playback'), None,None,None,config.getboolean("setting","shuffle_mode")),
           ('OfflineMode',None,_('Offline Mode'),None,None,None,config.getboolean("setting","offline"))
                      ])

        b = ag.get_action("shuffle")
        b.connect("toggled",self.playlist_ui.playlist.shuffle)
        if config.getboolean("setting","shuffle_mode"): b.activate()

        b = ag.get_action("repeat")
        b.connect_proxy(self.playlist_ui.playlist_control.btn_repeat)
        if config.getboolean("setting","repeat_mode"): b.activate()

        b = ag.get_action("OfflineMode")
        def toggle_offline(w): 
            if w.get_active(): config.set("setting","offline","true")
            else: config.set("setting","offline","false") 
        b.connect("toggled",toggle_offline)
        if config.getboolean("setting","offline"): b.activate()

        def change(action,*param):
            name = action.get_property("name")
            section = name[:name.index("_")]
            option = name[name.index("_")+1:]
            if action.get_active():
                config.set(section,option,"true")
            else:
                config.set(section,option,"false")

        
        self.ui = gtk.UIManager()
        self.ui.add_ui_from_string(menu%"")
        self.ui.insert_action_group(ag, -1)
        self.add_accel_group(self.ui.get_accel_group())
        
        return self.ui.get_widget("/MenuBar")

