# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
####

#@nodistribution

import gtk

import utils

from library import ListenDB
from source import Source,SourceItem
from widget.browser import SimpleBrowser
from widget.song_menu import SongMenuManager

from helper import Dispatcher 

from coherence import __version_info__
if __version_info__ < (0, 5, 7):
    raise ImportError("Coherence version must be >= 0,5,7")
from coherence.base import Coherence
from coherence.upnp.core import DIDLLite
#from coherence.upnp.core.soap_service import errorCode
from coherence.upnp.devices.media_renderer import MediaRenderer
#from coherence import log
import coherence.extern.louie as louie
#from coherence.extern.simple_plugin import Plugin

#import louie



from player import Player

SONGS_LIMIT=1000
KEEPALIVE=1500


class ListenUPNPPlayer:
    def __init__(self, server, **kwargs):
        self.server = server
        louie.send('Coherence.UPnP.Backend.init_completed', None, backend=self)

    def upnp_init(self):
        self.current_connection_id = None
        self.server.connection_manager_server.set_variable(0, 'SinkProtocolInfo',
                            ['http-get:*:audio/mpeg:*'],
                            default=True)
        self.server.av_transport_server.set_variable(0, 'TransportState', 'NO_MEDIA_PRESENT', default=True)
        self.server.av_transport_server.set_variable(0, 'TransportStatus', 'OK', default=True)
        self.server.av_transport_server.set_variable(0, 'CurrentPlayMode', 'NORMAL', default=True)
        self.server.av_transport_server.set_variable(0, 'CurrentTransportActions', '', default=True)
        self.server.rendering_control_server.set_variable(0, 'Volume', Player.get_volume())
        self.server.rendering_control_server.set_variable(0, 'Mute', self.get_mute())

    def get_mute(self):
        return None
        

class CoherenceSource(Source):
    PLUGIN_NAME = "UPNP Support (Coherence)"
    PLUGIN_DESC = _("Allow browse UPNP shared music library")
                                                                                                                                                               
    display_index = 1

    categorie = "shared"

    def __init__(self):
        Source.__init__(self)
        from twisted.internet import gtk2reactor
        try:
            gtk2reactor.install()
        except AssertionError, e:
            # sometimes it's already installed
            print e

        self.instances = {}

        coherence_config = {
            #'logmode': 'info',
            'controlpoint': 'yes',
            'plugins': {},
        }
        self.coherence = Coherence(coherence_config)

        kwargs = {
            "version": 0.1,
            "no_thread_needed": True,
            }
        self.renderer = MediaRenderer(self.coherence, ListenUPNPPlayer, **kwargs)

        # watch for media servers
        louie.connect(self.detected_media_server,
                'Coherence.UPnP.ControlPoint.MediaServer.detected',
                louie.Any)
        louie.connect(self.removed_media_server,
                'Coherence.UPnP.ControlPoint.MediaServer.removed',
                louie.Any)

    def removed_media_server(self, udn):
        print "upnp server went away %s" % udn

    def detected_media_server(self, client, udn):
        print "found upnp server %s (%s)"  %  (client.device.get_friendly_name(), udn)
        self.logwarning("found upnp server %s (%s)"  %  (client.device.get_friendly_name(), udn))

        
        name = client.device.get_friendly_name()
        #client.content_directory.subscribe_for_variable('ContainerUpdateIDs', self.state_variable_change)
        #client.content_directory.subscribe_for_variable('SystemUpdateID', self.state_variable_change)

        d = client.content_directory.browse(id, browse_flag='BrowseDirectChildren', process_result=False, backward_compatibility=False)
        d.addCallback(self.process_media_server_browse, udn)


        ListenDB.register_type(udn,["lyrics","wikipedia","lastfminfo","audioscrobbler"])
        for menu_item in ["play","enqueue","lastfm","wikipedia_artist","wikipedia_album","lyrics"]:
            SongMenuManager.allow_item_for_type(menu_item, udn)

        items = [ CoherenceLibrarySourceItem(d,udn) ]

        self.instances[udn] = (d ,items,name)
        self.items.extend(items)
        
        Dispatcher.update_source()

    @utils.threaded
    def process_media_server_browse(self, results, _type):
        self.loginfo("Device detected...")
        didl = DIDLLite.DIDLElement.fromString(results['Result'])
        for item in didl.getItems():
            self.loginfo("process_media_server_browse %r %r", item.id, item)
            #if item.upnp_class.startswith('object.container'):
            #    self.load_db(item.id)
            if item.upnp_class.startswith('object.item.audioItem'):
                
                s = {}
                url = None
                duration = None
                size = None
                bitrate = None #@UnusedVariable

                for res in item.res:
                    remote_protocol, _remote_network, _remote_content_format, _remote_flags = res.protocolInfo.split(':')
                    if remote_protocol == 'http-get':
                        url = res.data
                        duration = res.duration
                        size = res.size
                        bitrate = res.bitrate #@UnusedVariable
                        break

                if url is not None:
                    s["url"] = url
                    s["title"] = item.title
                    try:
                        if item.artist is not None:
                            s["artist"] = item.artist
                    except AttributeError:
                        pass
                    try:
                        if item.album is not None:
                            s["album"] = item.album
                    except AttributeError:
                        pass

                    try:
                        if item.originalTrackNumber is not None:
                            s["#track"] = int(item.originalTrackNumber)
                    except AttributeError:
                        pass

                    if duration is not None:
                        h,m,s = duration.split(':')
                        seconds = int(h)*3600 + int(m)*60 + int(s)
                        s["duration"] = seconds * 1000

                    if size is not None:
                        s["#size"] = size

                    ListenDB.get_or_create_song( s, _type)


    def remove_instance(self, client):
        for menu_item in ["play","enqueue","lastfm","wikipedia_artist","wikipedia_album","lyrics"]:
            SongMenuManager.disallow_item_for_type(menu_item, "coherence-%s"%client.get_id())
        ListenDB.unregister_type("coherence-%s"%client.get_id())
        
    def disconnect (self):
        self.items = []
        for _l, items, _name in self.instances.values():
            self.items.extend(items)
        Dispatcher.update_source()
    
    def delete_thyself(self):
        for l, _items, _name in self.instances.values():
            self.remove_instance(l)
        if self.coherence is None:
            return

        self.coherence.shutdown()

        try:
            louie.disconnect(self.detected_media_server,
                    'Coherence.UPnP.ControlPoint.MediaServer.detected',
                    louie.Any)
        except louie.error.DispatcherKeyError: #@UndefinedVariable
            pass
        try:
            louie.disconnect(self.removed_media_server,
                    'Coherence.UPnP.ControlPoint.MediaServer.removed',
                    louie.Any)
        except louie.error.DispatcherKeyError: #@UndefinedVariable
            pass

        del self.coherence
        
        super(CoherenceSource, self).delete_thyself()
        
        
class CoherenceBrowser(SimpleBrowser):
    _cover = True
    _config_code = "coherence"
    def __init__(self, client, udn):
        self._type = udn
        SimpleBrowser.__init__(self)

class CoherenceLibrarySourceItem(SourceItem):
    stock = gtk.STOCK_NETWORK
    config_code = "coherence"

    def __init__(self, client, udn):
        self.label = client.device.get_friendly_name()
        self.widget = CoherenceBrowser(client,udn)



