# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gobject
import urlparse
from gtkmozembed import MozEmbed,set_profile_path


from proxy import discover_http_proxy
from xdg_support import get_xdg_cache_dir, get_xdg_cache_file

def set_mozembed_proxy():
    proxy = discover_http_proxy()
    data = ""
    if proxy:
        host_port = None
        parts = urlparse.urlparse(proxy["http"])
        if not parts[0] or parts[0] == 'http':
            host_port = parts[1]
            t = host_port.split(':')
            host = t[0].strip()
            if host:
                try:
                    port = int(t[1])
                except:
                    port = 80

        if port and host:
            port = str(port)
            data += 'user_pref("network.proxy.type", 1);\r\n'
            data += 'user_pref("network.proxy.ftp", "'+host+'");\r\n' 
            data += 'user_pref("network.proxy.ftp_port", '+port+');\r\n'
            data += 'user_pref("network.proxy.gopher", "'+host+'");\r\n'
            data += 'user_pref("network.proxy.gopher_port", '+port+');\r\n'
            data += 'user_pref("network.proxy.http", "'+host+'");\r\n'
            data += 'user_pref("network.proxy.http_port", '+port+');\r\n'
            data += 'user_pref("network.proxy.no_proxies_on", "localhost,127.0.0.1");\r\n'
            data += 'user_pref("network.proxy.share_proxy_settings", true);\r\n'
            data += 'user_pref("network.proxy.socks", "'+host+'");\r\n'
            data += 'user_pref("network.proxy.socks_port", '+port+');\r\n'
            data += 'user_pref("network.proxy.ssl", "'+host+'");\r\n'
            data += 'user_pref("network.proxy.ssl_port", '+port+');\r\n'
            data += 'user_pref("network.http.proxy.pipelining", true);\r\n'

    fd = file( get_xdg_cache_file("mozembed/listen/prefs.js"), "w+")
    fd.write(data)
    fd.close()

set_mozembed_proxy()
set_profile_path( get_xdg_cache_dir("mozembed") , "listen" )

"""
This class wrap MozEmbed
Use workaround to resolve binding problem:
    - freeze when more than 150ko are render
    - crash when render data and the widget is not realize
"""
class MozClient(MozEmbed):
    def __init__(self):
        super(MozClient,self).__init__()
        
        self.connect("realize",self.on_realize)
        self.connect("unrealize",self.on_unrealize)
        
        self.__render_id = None
        self.is_realize = False
        
        self.current_data = None
        self.current_url = None
        
        self.dbg = False

        self.set_data("about:blank","<html></html>")
        
    def load_html_string(self, data, url):
        self.print_dbg("set_data",url,len(data))           
        self.current_data = data
        self.current_url = url
        if self.is_realize:
            self.on_realize()
        
    def on_unrealize(self,w=None):
        self.print_dbg("on_unrealize")       
        self.is_realize = False
        
    def on_realize(self,w=None):
        self.print_dbg("on_realize")    
        self.is_realize = True
        if self.current_data and self.current_url:
            if self.__render_id:
                try:gobject.source_remove(self.__render_id)
                except:pass
                self.__render_id = None
                self.close_stream()
            self.open_stream(self.current_url, "text/html")
            
            self.__render_id = gobject.idle_add(self.idle_set_data,self.current_data)
                
    def idle_set_data(self,data):
        self.print_dbg("idle_set_data",len(data))
        buffer = 10*1024
        tmp_data = data[:buffer]
        self.append_data(tmp_data,long(len(tmp_data)))
        tmp_data = data[buffer:]
        if len(tmp_data)>0:
            self.__render_id = gobject.idle_add(self.idle_set_data,tmp_data)
        else:
            self.print_dbg("close_stream")
            self.close_stream()  
            self.__render_id = None
            
    def print_dbg(self,*arg):
        if self.dbg: print "DBG:MozClient:",arg
        
        
