require 'cairo'

module CairoTestUtils
  private
  def only_cairo_version(major, minor, micro=nil)
    unless Cairo.satisfied_version?(major, minor, micro)
      omit("Require cairo >= #{major}.#{minor}.#{micro}")
    end
  end

  def only_win32
    omit("Only for Win32 platform") unless win32
  end

  def win32?
    /cygwin|mingw|mswin32|bccwin32/.match(RUBY_PLATFORM) ? true : false
  end
end
