/*
 * Drizzle Client & Protocol Library
 *
 * Copyright (C) 2008 Eric Day (eday@oddments.org)
 * All rights reserved.
 *
 * Use and distribution licensed under the BSD license.  See
 * the COPYING file in this directory for full text.
 */

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>

#include "common.h"

int listen_init(in_port_t port)
{
  struct sockaddr_in sa;
  int fd;
  int opt= 1;

  if (signal(SIGPIPE, SIG_IGN) == SIG_ERR)
  {
    printf("signal:%d\n", errno);
    return -1;
  }

  memset(&sa, 0, sizeof(sa));
  sa.sin_family = AF_INET;
  sa.sin_port= htons(port);
  sa.sin_addr.s_addr = INADDR_ANY;

  fd= socket(sa.sin_family, SOCK_STREAM, 0);
  if (fd == -1)
  {
    printf("socket:%d\n", errno);
    return -1;
  }

  if (setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt)) == -1)
  {
    printf("setsockopt:%d\n", errno);
    return -1;
  }

  if (bind(fd, (struct sockaddr *)(&sa), sizeof(sa)) == -1)
  {
    printf("bind:%d\n", errno);
    return -1;
  }

  if (listen(fd, 32) == -1)
  {
    printf("listen:%d\n", errno);
    return -1;
  }

  return fd;
}
