/*
 * Drizzle Client & Protocol Library
 *
 * Copyright (C) 2008 Eric Day (eday@oddments.org)
 * All rights reserved.
 *
 * Use and distribution licensed under the BSD license.  See
 * the COPYING file in this directory for full text.
 */

/**
 * @file
 * @brief Connection declarations
 */

#ifndef __DRIZZLE_CONN_PRIVATE_H
#define __DRIZZLE_CONN_PRIVATE_H

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @addtogroup drizzle_con_private Private Connection Functions
 * @ingroup drizzle_con
 * @{
 */

/**
 * Clear address info, freeing structs if needed.
 */
DRIZZLE_LOCAL
void drizzle_con_reset_addrinfo(drizzle_con_st *con);
 
/**
 * Does the connection use UDS.
 */
DRIZZLE_LOCAL
bool drizzle_con_uses_uds(drizzle_con_st *con);

/**
 * Copy the UDS structures from one drizzle_con_st to another.
 */
DRIZZLE_LOCAL
void drizzle_con_clone_uds(drizzle_con_st *con, drizzle_con_st *from);

/** @} */

#ifdef __cplusplus
}
#endif

#endif /* __DRIZZLE_CONN_PRIVATE_H */
