/*
 * libexplain - Explain errno values returned by libc functions
 * Copyright (C) 2009 Peter Miller
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <libexplain/ac/termios.h>

#include <libexplain/buffer/int.h>
#include <libexplain/buffer/tcflow_action.h>
#include <libexplain/parse_bits.h>
#include <libexplain/sizeof.h>
#include <libexplain/strtol.h>


#ifdef HAVE_TCFLOW

static const explain_parse_bits_table_t table[] =
{
    { "TCOOFF", TCOOFF },
    { "TCOON", TCOON },
    { "TCIOFF", TCIOFF },
    { "TCION", TCION },
};


void
explain_buffer_tcflow_action(explain_string_buffer_t *sb, int data)
{
    explain_parse_bits_print_single(sb, data, table, SIZEOF(table));
}


int
explain_parse_tcflow_action_or_die(const char *text, const char *caption)
{
    return explain_parse_bits_or_die(text, table, sizeof(table), caption);
}

#else


void
explain_buffer_tcflow_action(explain_string_buffer_t *sb, int data)
{
    explain_buffer_int(sb, data);
}


int
explain_parse_tcflow_action_or_die(const char *text, const char *caption)
{
    (void)caption;
    return explain_strtol_or_die(text, 0, 0);
}

#endif
