/* hashRandom.h
 */
#ifndef _HASHRANDOM_H
#define _HASHRANDOM_H

#include "osl/hash/hashKey.h"

namespace osl
{
  namespace hash
  {
    class HashRandom
    {
    public:
      static const size_t Length = 0x1000;
    private:
      static int table[Length];
    public:
      static void setUp(double sigma);
      static int value(size_t key) 
      {
	return table[key % Length];
      }
      static int value(const HashKey& key) 
      {
	return value(key.signature());
      }
    };
  }
  using hash::HashRandom;
}

#endif /* _HASHRANDOM_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
