/****************************************************************************
**
** This file is part of the LibreCAD project, a 2D CAD program
**
** Copyright (C) 2010 R. van Twisk (librecad@rvt.dds.nl)
** Copyright (C) 2001-2003 RibbonSoft. All rights reserved.
**
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
** This copyright notice MUST APPEAR in all copies of the script!  
**
**********************************************************************/
#ifndef QG_CADTOOLBARMAIN_H
#define QG_CADTOOLBARMAIN_H

#include <qvariant.h>

class QG_CadToolBar;

#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QApplication>
#include <QtGui/QButtonGroup>
#include <QtGui/QHeaderView>
#include <QtGui/QToolButton>
#include <QtGui/QWidget>
#include "qg_actionhandler.h"

QT_BEGIN_NAMESPACE

class Ui_QG_CadToolBarMain
{
public:
    QToolButton *bMenuLine;
    QToolButton *bMenuArc;
    QToolButton *bMenuPoint;
    QToolButton *bMenuSpline;
    QToolButton *bMenuEllipse;
    QToolButton *bMenuCircle;
    QToolButton *bMenuText;
    QToolButton *bMenuDim;
    QToolButton *bMenuHatch;
    QToolButton *bMenuImage;
    QToolButton *bMenuModify;
    QToolButton *bMenuInfo;
    QToolButton *bMenuBlock;
    QToolButton *bMenuSelect;
    QToolButton *bMenuPolyline;

    void setupUi(QWidget *QG_CadToolBarMain)
    {
        if (QG_CadToolBarMain->objectName().isEmpty())
            QG_CadToolBarMain->setObjectName(QString::fromUtf8("QG_CadToolBarMain"));
        QG_CadToolBarMain->resize(56, 336);
        QSizePolicy sizePolicy(static_cast<QSizePolicy::Policy>(0), static_cast<QSizePolicy::Policy>(3));
        sizePolicy.setHorizontalStretch(0);
        sizePolicy.setVerticalStretch(0);
        sizePolicy.setHeightForWidth(QG_CadToolBarMain->sizePolicy().hasHeightForWidth());
        QG_CadToolBarMain->setSizePolicy(sizePolicy);
        QG_CadToolBarMain->setMinimumSize(QSize(56, 336));
        bMenuLine = new QToolButton(QG_CadToolBarMain);
        bMenuLine->setObjectName(QString::fromUtf8("bMenuLine"));
        bMenuLine->setGeometry(QRect(28, 0, 28, 28));
        const QIcon icon = qt_get_icon(image0_ID);
        bMenuLine->setIcon(icon);
        bMenuArc = new QToolButton(QG_CadToolBarMain);
        bMenuArc->setObjectName(QString::fromUtf8("bMenuArc"));
        bMenuArc->setGeometry(QRect(0, 28, 28, 28));
        const QIcon icon1 = qt_get_icon(image1_ID);
        bMenuArc->setIcon(icon1);
        bMenuPoint = new QToolButton(QG_CadToolBarMain);
        bMenuPoint->setObjectName(QString::fromUtf8("bMenuPoint"));
        bMenuPoint->setGeometry(QRect(0, 0, 28, 28));
        const QIcon icon2 = qt_get_icon(image2_ID);
        bMenuPoint->setIcon(icon2);
        bMenuSpline = new QToolButton(QG_CadToolBarMain);
        bMenuSpline->setObjectName(QString::fromUtf8("bMenuSpline"));
        bMenuSpline->setGeometry(QRect(28, 56, 28, 28));
        const QIcon icon3 = qt_get_icon(image3_ID);
        bMenuSpline->setIcon(icon3);
        bMenuEllipse = new QToolButton(QG_CadToolBarMain);
        bMenuEllipse->setObjectName(QString::fromUtf8("bMenuEllipse"));
        bMenuEllipse->setGeometry(QRect(0, 56, 28, 28));
        const QIcon icon4 = qt_get_icon(image4_ID);
        bMenuEllipse->setIcon(icon4);
        bMenuCircle = new QToolButton(QG_CadToolBarMain);
        bMenuCircle->setObjectName(QString::fromUtf8("bMenuCircle"));
        bMenuCircle->setGeometry(QRect(28, 28, 28, 28));
        const QIcon icon5 = qt_get_icon(image5_ID);
        bMenuCircle->setIcon(icon5);
        bMenuText = new QToolButton(QG_CadToolBarMain);
        bMenuText->setObjectName(QString::fromUtf8("bMenuText"));
        bMenuText->setGeometry(QRect(0, 116, 28, 28));
        const QIcon icon6 = qt_get_icon(image6_ID);
        bMenuText->setIcon(icon6);
        bMenuDim = new QToolButton(QG_CadToolBarMain);
        bMenuDim->setObjectName(QString::fromUtf8("bMenuDim"));
        bMenuDim->setGeometry(QRect(28, 116, 28, 28));
        const QIcon icon7 = qt_get_icon(image7_ID);
        bMenuDim->setIcon(icon7);
        bMenuHatch = new QToolButton(QG_CadToolBarMain);
        bMenuHatch->setObjectName(QString::fromUtf8("bMenuHatch"));
        bMenuHatch->setGeometry(QRect(0, 144, 28, 28));
        const QIcon icon8 = qt_get_icon(image8_ID);
        bMenuHatch->setIcon(icon8);
        bMenuImage = new QToolButton(QG_CadToolBarMain);
        bMenuImage->setObjectName(QString::fromUtf8("bMenuImage"));
        bMenuImage->setGeometry(QRect(28, 144, 28, 28));
        const QIcon icon9 = qt_get_icon(image9_ID);
        bMenuImage->setIcon(icon9);
        bMenuModify = new QToolButton(QG_CadToolBarMain);
        bMenuModify->setObjectName(QString::fromUtf8("bMenuModify"));
        bMenuModify->setGeometry(QRect(0, 176, 28, 28));
        const QIcon icon10 = qt_get_icon(image10_ID);
        bMenuModify->setIcon(icon10);
        bMenuInfo = new QToolButton(QG_CadToolBarMain);
        bMenuInfo->setObjectName(QString::fromUtf8("bMenuInfo"));
        bMenuInfo->setGeometry(QRect(28, 176, 28, 28));
        const QIcon icon11 = qt_get_icon(image11_ID);
        bMenuInfo->setIcon(icon11);
        bMenuBlock = new QToolButton(QG_CadToolBarMain);
        bMenuBlock->setObjectName(QString::fromUtf8("bMenuBlock"));
        bMenuBlock->setGeometry(QRect(0, 204, 28, 28));
        const QIcon icon12 = qt_get_icon(image12_ID);
        bMenuBlock->setIcon(icon12);
        bMenuSelect = new QToolButton(QG_CadToolBarMain);
        bMenuSelect->setObjectName(QString::fromUtf8("bMenuSelect"));
        bMenuSelect->setGeometry(QRect(28, 204, 28, 28));
        const QIcon icon13 = qt_get_icon(image13_ID);
        bMenuSelect->setIcon(icon13);
        bMenuPolyline = new QToolButton(QG_CadToolBarMain);
        bMenuPolyline->setObjectName(QString::fromUtf8("bMenuPolyline"));
        bMenuPolyline->setGeometry(QRect(0, 84, 28, 28));
        const QIcon icon14 = qt_get_icon(image14_ID);
        bMenuPolyline->setIcon(icon14);

        retranslateUi(QG_CadToolBarMain);

        QMetaObject::connectSlotsByName(QG_CadToolBarMain);
    } // setupUi

    void retranslateUi(QWidget *QG_CadToolBarMain)
    {
        QG_CadToolBarMain->setWindowTitle(QApplication::translate("QG_CadToolBarMain", "Main", 0, QApplication::UnicodeUTF8));
        bMenuLine->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuLine->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Show menu \"Lines\"", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuArc->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuArc->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Show menu \"Arcs\"", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuPoint->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuPoint->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Points", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuSpline->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuSpline->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Splines", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuEllipse->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuEllipse->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Show menu \"Ellipses\"", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuCircle->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuCircle->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Show menu \"Circles\"", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuText->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuText->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Texts", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuDim->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuDim->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Show menu \"Dimensions\"", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuHatch->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuHatch->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Hatches / Solid Fills", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuImage->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuImage->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Raster Image", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuModify->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuModify->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Show menu \"Edit\"", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuInfo->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuInfo->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Show menu \"Measure\"", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuBlock->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuBlock->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Create Block", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuSelect->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuSelect->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Show menu \"Select\"", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
        bMenuPolyline->setText(QString());
#ifndef QT_NO_TOOLTIP
        bMenuPolyline->setProperty("toolTip", QVariant(QApplication::translate("QG_CadToolBarMain", "Polylines", 0, QApplication::UnicodeUTF8)));
#endif // QT_NO_TOOLTIP
    } // retranslateUi


protected:
    enum IconID
    {
        image0_ID,
        image1_ID,
        image2_ID,
        image3_ID,
        image4_ID,
        image5_ID,
        image6_ID,
        image7_ID,
        image8_ID,
        image9_ID,
        image10_ID,
        image11_ID,
        image12_ID,
        image13_ID,
        image14_ID,
        unknown_ID
    };
    static QPixmap qt_get_icon(IconID id)
    {
    static const unsigned char image0_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x62, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xed, 0xd3, 0x31, 0x0e, 0x80,
    0x30, 0x08, 0x05, 0xd0, 0x8f, 0xf1, 0x54, 0x70, 0x7e, 0x7a, 0x2d, 0x9c,
    0x48, 0x88, 0xda, 0x94, 0x96, 0x0e, 0x0e, 0xfe, 0xed, 0x33, 0xbc, 0x81,
    0x00, 0x69, 0x53, 0xec, 0xc8, 0xb1, 0x45, 0xf9, 0xa1, 0xd7, 0x08, 0x8b,
    0x09, 0x8b, 0x79, 0x3f, 0x57, 0x00, 0x00, 0xd0, 0xa6, 0x14, 0xe7, 0x69,
    0xa8, 0x07, 0xa4, 0xa1, 0x11, 0x30, 0x84, 0xb2, 0x40, 0x17, 0x9a, 0x05,
    0x1e, 0xd0, 0x2a, 0xe0, 0xa1, 0x4f, 0xfd, 0x9a, 0xb0, 0x58, 0x19, 0xf2,
    0x95, 0x94, 0xa0, 0x78, 0xd9, 0xa5, 0x17, 0x89, 0x7d, 0x09, 0xba, 0x23,
    0x00, 0x70, 0x01, 0xd5, 0xff, 0x28, 0x98, 0x32, 0x00, 0xab, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image1_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x6f, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xad, 0xd4, 0x5b, 0x0a, 0x00,
    0x21, 0x08, 0x05, 0x50, 0x8d, 0x59, 0x95, 0xae, 0xdf, 0xb6, 0xe5, 0x7c,
    0x09, 0x3d, 0x64, 0xa6, 0xd4, 0xfb, 0x19, 0x79, 0x90, 0x94, 0x50, 0xba,
    0x40, 0x45, 0x9e, 0x9b, 0xcb, 0x4c, 0xac, 0xeb, 0x99, 0x74, 0xc1, 0x23,
    0x68, 0x2c, 0xb6, 0xa2, 0xeb, 0x8e, 0x0c, 0xf9, 0x02, 0x7e, 0x21, 0x26,
    0xd6, 0x13, 0xc0, 0xd2, 0x2a, 0x10, 0x17, 0x8a, 0x20, 0x1b, 0x14, 0x45,
    0x26, 0xc8, 0x1b, 0x6d, 0xb8, 0xa3, 0x68, 0x37, 0x1b, 0x94, 0x49, 0x03,
    0xc8, 0xbd, 0xcd, 0x04, 0x55, 0xa4, 0x04, 0x62, 0x62, 0x4d, 0x43, 0x36,
    0xed, 0x14, 0x34, 0xae, 0x0c, 0x46, 0xff, 0xa3, 0x75, 0xef, 0x42, 0x1d,
    0x79, 0xcb, 0xfb, 0x02, 0x78, 0x1f, 0x31, 0x36, 0x9e, 0xfd, 0x62, 0x47,
    0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image2_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x5c, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0x63, 0x3c, 0x7a, 0xec, 0x28,
    0x03, 0x21, 0x60, 0x6d, 0x65, 0xfd, 0xff, 0xe8, 0xb1, 0xa3, 0x8c, 0xf8,
    0xd4, 0x30, 0x11, 0x34, 0x85, 0x48, 0xc0, 0x88, 0xcf, 0x45, 0xd6, 0x56,
    0xd6, 0xff, 0xd1, 0xc5, 0x70, 0xb9, 0x0c, 0xaf, 0x41, 0xc8, 0x06, 0x0e,
    0x0e, 0xaf, 0x91, 0x02, 0xa8, 0xe6, 0x22, 0xb2, 0x0c, 0xc2, 0x16, 0x09,
    0x03, 0x13, 0x46, 0xf8, 0x92, 0x03, 0x8a, 0x41, 0xc4, 0x44, 0x33, 0x2e,
    0x75, 0xd4, 0xf5, 0x1a, 0x29, 0x29, 0x18, 0xaf, 0x41, 0x30, 0x40, 0xac,
    0xd7, 0xb0, 0x81, 0xd1, 0x94, 0x4d, 0x18, 0x00, 0x00, 0xd5, 0x0a, 0x36,
    0x9b, 0x1a, 0xb6, 0x5e, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e,
    0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image3_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x86, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xad, 0x94, 0x41, 0x0e, 0xc0,
    0x20, 0x08, 0x04, 0x8b, 0xf1, 0x55, 0xf2, 0x7e, 0xfc, 0x96, 0x3d, 0xd1,
    0x18, 0x0a, 0xb8, 0xb6, 0x72, 0x33, 0xc5, 0xe9, 0xe8, 0x12, 0x49, 0xba,
    0x5c, 0x27, 0xaa, 0x1c, 0xa1, 0xcc, 0x20, 0x6e, 0x3c, 0xb8, 0xf1, 0xf8,
    0x05, 0xe2, 0xc6, 0x43, 0xba, 0x90, 0x74, 0xa1, 0xaf, 0xb0, 0xd7, 0xd1,
    0x56, 0x30, 0x35, 0xb7, 0x3d, 0xee, 0x1d, 0x45, 0xb0, 0xd9, 0xdc, 0xf6,
    0x14, 0xc4, 0x22, 0xaa, 0x79, 0x5f, 0x98, 0x9a, 0x85, 0xab, 0x4d, 0xd4,
    0x9f, 0xc6, 0xbf, 0x63, 0xfa, 0x80, 0xa2, 0x4d, 0x28, 0x0c, 0x1a, 0xc8,
    0xec, 0x48, 0x2e, 0x08, 0x89, 0xde, 0xae, 0xf5, 0x27, 0x90, 0x11, 0x32,
    0xb0, 0xdb, 0x03, 0xa9, 0xdf, 0x6d, 0x8a, 0x15, 0x31, 0xf2, 0x60, 0x4b,
    0x23, 0xc4, 0xca, 0x2b, 0xca, 0xde, 0x23, 0x85, 0x21, 0xa9, 0xa5, 0xa0,
    0x9d, 0xba, 0x01, 0x51, 0x85, 0x70, 0x21, 0x3f, 0x74, 0x10, 0x2c, 0x00,
    0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image4_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x86, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xad, 0xd3, 0x51, 0x12, 0x80,
    0x20, 0x08, 0x04, 0xd0, 0xc5, 0xe9, 0x54, 0x79, 0xfe, 0xf5, 0x5a, 0xf5,
    0x85, 0xd3, 0x90, 0x0a, 0x58, 0x7c, 0x39, 0x41, 0xcf, 0x1d, 0x4b, 0x61,
    0x23, 0xb2, 0x55, 0xcf, 0x7a, 0xe9, 0x9a, 0x8d, 0x02, 0x00, 0xc7, 0x0e,
    0xa0, 0x2f, 0xeb, 0x33, 0x36, 0x8a, 0x44, 0x12, 0x8d, 0x00, 0xdb, 0x77,
    0x13, 0xe9, 0x8e, 0xde, 0x5c, 0xf9, 0x03, 0x59, 0x42, 0x51, 0x44, 0xe7,
    0x86, 0x50, 0x26, 0xc9, 0x34, 0x51, 0x06, 0x79, 0xce, 0x96, 0x59, 0x23,
    0x5b, 0x1d, 0xca, 0x22, 0x76, 0x7e, 0xf9, 0xd5, 0xa2, 0x48, 0x87, 0x76,
    0xcf, 0xe5, 0x05, 0x7d, 0x49, 0xa2, 0x25, 0x00, 0x52, 0xff, 0xcb, 0xac,
    0x17, 0x4a, 0xe4, 0x21, 0x80, 0x73, 0xfb, 0x23, 0x97, 0x55, 0xd7, 0xc2,
    0xc6, 0xd7, 0x8e, 0x1e, 0x60, 0x91, 0x0e, 0xd9, 0x86, 0x77, 0x66, 0x16,
    0x01, 0x80, 0x1b, 0x90, 0x10, 0x76, 0xd0, 0xfa, 0x7b, 0x2f, 0xb7, 0x00,
    0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image5_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x78, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xdd, 0x53, 0x41, 0x0e, 0xc0,
    0x20, 0x08, 0x2b, 0x66, 0xaf, 0x92, 0xf7, 0xe3, 0xb7, 0xdc, 0xc9, 0x84,
    0x30, 0x64, 0xe8, 0x3c, 0xad, 0x47, 0x2d, 0xa5, 0x55, 0x20, 0x69, 0x02,
    0x0b, 0xae, 0xdc, 0xed, 0x99, 0x34, 0xa1, 0x07, 0x51, 0xe1, 0xf2, 0x04,
    0xbc, 0xa2, 0xe8, 0x0e, 0x00, 0x68, 0x38, 0xe2, 0xca, 0xfd, 0xad, 0x6b,
    0xc4, 0x2b, 0x2b, 0x22, 0xc3, 0x91, 0x17, 0xbd, 0x64, 0x8a, 0x33, 0x20,
    0x00, 0x69, 0x37, 0x1a, 0x36, 0xc5, 0x31, 0x47, 0x7f, 0x16, 0x9a, 0x7d,
    0x67, 0x04, 0x6f, 0x5c, 0xce, 0x46, 0x5b, 0x71, 0x35, 0x1b, 0x5e, 0xd2,
    0x4b, 0xbb, 0xbb, 0x6b, 0x5c, 0xb9, 0xd3, 0xd7, 0xed, 0x1f, 0x5c, 0x57,
    0x28, 0x0b, 0xdd, 0x70, 0xfb, 0xb1, 0xad, 0xeb, 0x2d, 0x21, 0x2f, 0xfa,
    0x0d, 0xcc, 0x20, 0x53, 0x6c, 0x75, 0x1d, 0xca, 0xe3, 0x00, 0x00, 0x00,
    0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image6_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x73, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xbd, 0x94, 0x41, 0x0e, 0xc0,
    0x20, 0x08, 0x04, 0x8b, 0xe9, 0xab, 0xe4, 0xfd, 0xf8, 0x2d, 0x7b, 0x32,
    0x31, 0x76, 0xc5, 0xc5, 0x9a, 0xee, 0x15, 0x32, 0x19, 0x81, 0x28, 0x56,
    0xec, 0x3a, 0x91, 0x74, 0x84, 0xb2, 0x02, 0x69, 0xd6, 0xaa, 0x59, 0xeb,
    0x67, 0x50, 0x0f, 0xdc, 0x06, 0xb1, 0x26, 0x94, 0x91, 0x15, 0x13, 0x16,
    0x0c, 0x41, 0x51, 0x1b, 0xd7, 0xa8, 0xd9, 0xf4, 0x56, 0x21, 0x90, 0x67,
    0xe3, 0xd5, 0xa0, 0xd1, 0x68, 0xc1, 0x58, 0xc9, 0x78, 0xd9, 0xcc, 0x7c,
    0x10, 0xf8, 0x46, 0x10, 0xd4, 0x18, 0xde, 0xda, 0xec, 0x19, 0xab, 0x53,
    0x48, 0x5e, 0x31, 0x12, 0xb1, 0x62, 0x10, 0xc2, 0x1e, 0x63, 0xeb, 0x7b,
    0x0d, 0x7b, 0x37, 0xff, 0x7c, 0x23, 0x91, 0x3c, 0x62, 0x3e, 0x3c, 0x1f,
    0x25, 0x0e, 0xcb, 0x56, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
    0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image7_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x73, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xdd, 0x93, 0x41, 0x0e, 0xc0,
    0x20, 0x08, 0x04, 0x17, 0xd3, 0x57, 0xc9, 0xfb, 0xe1, 0x5b, 0xf6, 0x44,
    0x42, 0x6b, 0x8b, 0x56, 0x39, 0x95, 0x93, 0x91, 0x65, 0xb2, 0x10, 0x20,
    0x51, 0x41, 0x46, 0x94, 0x14, 0x8a, 0x81, 0xb8, 0x72, 0xfb, 0x5a, 0x78,
    0xaf, 0xe9, 0x1c, 0x45, 0xd0, 0x28, 0x57, 0x66, 0x85, 0x23, 0x0d, 0x89,
    0xca, 0x52, 0x6b, 0x00, 0x20, 0x2a, 0x64, 0xef, 0xc3, 0x7f, 0x1a, 0xd0,
    0x0b, 0x9e, 0xdc, 0x78, 0xad, 0xc5, 0xa5, 0xb5, 0x37, 0xc0, 0x8c, 0xa6,
    0x1b, 0x76, 0x04, 0x8b, 0x72, 0xb9, 0x7b, 0xf4, 0x4f, 0x10, 0x65, 0x1c,
    0x2d, 0x57, 0x6e, 0xdb, 0x8e, 0x6c, 0x9f, 0xb6, 0x40, 0x7e, 0x29, 0x97,
    0x41, 0xc3, 0xeb, 0x5f, 0x81, 0x00, 0xc0, 0x09, 0x6b, 0x1a, 0x32, 0xdd,
    0x42, 0x57, 0x89, 0xc3, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
    0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image8_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x89, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xcd, 0x94, 0x6b, 0x0a, 0x00,
    0x21, 0x08, 0x84, 0xd7, 0xa5, 0x53, 0xe5, 0xf9, 0xf5, 0x5a, 0xed, 0xaf,
    0x01, 0xd7, 0xb4, 0x07, 0xc4, 0xb2, 0x03, 0x41, 0xf6, 0xf8, 0xc8, 0xc9,
    0x22, 0x51, 0xb9, 0x4e, 0xe8, 0x3e, 0x42, 0x39, 0x09, 0x2a, 0xa3, 0x49,
    0xae, 0xdc, 0x56, 0x20, 0xa2, 0x42, 0x21, 0x08, 0x00, 0x51, 0x21, 0xc4,
    0xe8, 0xfb, 0x18, 0x6b, 0x3b, 0xd0, 0x68, 0x53, 0x14, 0x43, 0x2f, 0x8f,
    0x76, 0x21, 0x36, 0xf5, 0xd4, 0x6c, 0x2c, 0xe2, 0xca, 0x0d, 0xcd, 0x8f,
    0x5b, 0x68, 0xb1, 0x1b, 0xbd, 0x27, 0x51, 0x1a, 0x80, 0xfa, 0xf1, 0xee,
    0x44, 0x99, 0x07, 0x56, 0xdb, 0x1e, 0xcd, 0x64, 0x3d, 0x7a, 0xdd, 0x5a,
    0x64, 0x64, 0x56, 0x4b, 0x36, 0xfd, 0x0e, 0x94, 0x9d, 0x6c, 0xa5, 0x04,
    0xa6, 0x1e, 0x7d, 0x5e, 0x47, 0x84, 0x6f, 0x64, 0xf5, 0x5d, 0x45, 0x12,
    0x15, 0xa2, 0xdf, 0xfd, 0x47, 0x0f, 0x7a, 0x88, 0x91, 0xa3, 0xce, 0x6d,
    0x4b, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42,
    0x60, 0x82
};

    static const unsigned char image9_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x76, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xcd, 0x94, 0xbb, 0x15, 0x80,
    0x30, 0x08, 0x45, 0x2f, 0x9e, 0x2c, 0xe1, 0x2a, 0x3a, 0x85, 0x2e, 0xea,
    0x14, 0x64, 0x15, 0xdd, 0x02, 0x0b, 0x4c, 0x72, 0xec, 0xfc, 0x50, 0xe4,
    0x35, 0xbc, 0x50, 0x3c, 0xb8, 0x45, 0x10, 0xcd, 0x4a, 0x84, 0x86, 0x90,
    0x94, 0xc8, 0xa0, 0x04, 0x30, 0x4f, 0xb3, 0xfd, 0x09, 0xd1, 0xac, 0x92,
    0xda, 0xd3, 0xb3, 0xcc, 0x40, 0x84, 0xc7, 0x1e, 0xdc, 0xc4, 0xa2, 0x95,
    0x29, 0x5f, 0x7c, 0xd9, 0xac, 0x06, 0xbd, 0xc1, 0xb9, 0xa3, 0xb9, 0x3a,
    0x46, 0x1b, 0x37, 0xef, 0xec, 0x8b, 0xbd, 0xf2, 0x45, 0x61, 0x68, 0x5c,
    0x7f, 0xcd, 0xbe, 0x0a, 0x30, 0xcd, 0xda, 0x21, 0x5a, 0xdd, 0xe8, 0x58,
    0xbd, 0x0a, 0x6d, 0xd2, 0x13, 0x5f, 0x7b, 0xdd, 0xdd, 0xa3, 0x13, 0xcd,
    0x3c, 0x86, 0xfd, 0xa6, 0x99, 0xb9, 0x44, 0x00, 0x00, 0x00, 0x00, 0x49,
    0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image10_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x6d, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xed, 0x92, 0x41, 0x0a, 0xc0,
    0x30, 0x08, 0x04, 0x27, 0xa5, 0xaf, 0xd2, 0xf7, 0x27, 0xdf, 0xb2, 0x87,
    0x22, 0x58, 0x21, 0xa5, 0x69, 0x72, 0xe8, 0xa1, 0x0b, 0x1e, 0x5c, 0x65,
    0xd8, 0x48, 0x4a, 0x6d, 0x95, 0x15, 0xda, 0x96, 0x50, 0x3e, 0x09, 0x02,
    0xcc, 0x62, 0x9d, 0x37, 0xbb, 0xf6, 0xee, 0xe5, 0x59, 0xdc, 0xd9, 0x01,
    0x6a, 0x6b, 0x25, 0xe3, 0xdd, 0x53, 0x11, 0x8b, 0xf3, 0x9e, 0xbf, 0xbb,
    0x99, 0x17, 0x47, 0xd5, 0x4d, 0x34, 0xaa, 0x65, 0xc7, 0xee, 0x3e, 0xcd,
    0xbd, 0xa7, 0x69, 0xcb, 0xff, 0xb3, 0x6f, 0xa5, 0xa2, 0x36, 0x0d, 0x52,
    0x51, 0x83, 0xc9, 0x44, 0x0e, 0x99, 0x02, 0x45, 0xc8, 0x6b, 0x50, 0x86,
    0x00, 0x1c, 0x8f, 0x18, 0x4f, 0xf2, 0x5b, 0xc6, 0x79, 0x3b, 0x00, 0x00,
    0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image11_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x60, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xdd, 0x93, 0x31, 0x0e, 0xc0,
    0x20, 0x0c, 0x03, 0xe3, 0x8a, 0x57, 0x91, 0xf7, 0x87, 0x6f, 0x99, 0x09,
    0x84, 0x28, 0x6a, 0x51, 0x80, 0x05, 0x2f, 0x78, 0x08, 0x87, 0x15, 0x61,
    0x58, 0x32, 0xd9, 0xa1, 0x67, 0x0b, 0xe5, 0x6e, 0x50, 0x10, 0x11, 0xd1,
    0xa8, 0xf4, 0x5c, 0xb6, 0x64, 0x78, 0x25, 0x22, 0x59, 0xcf, 0x19, 0xdf,
    0xeb, 0xcc, 0x8e, 0xda, 0x97, 0x66, 0xfc, 0x91, 0x44, 0xa1, 0x18, 0x00,
    0x5f, 0x73, 0xbf, 0xc2, 0x9d, 0x15, 0xd1, 0xa8, 0x5c, 0x06, 0x95, 0xcf,
    0xbc, 0x04, 0x6a, 0x1b, 0xe1, 0x06, 0xf5, 0xb5, 0x72, 0x81, 0x46, 0xdd,
    0xcc, 0xae, 0x01, 0x35, 0x11, 0x62, 0xd1, 0xe7, 0x7c, 0x00, 0x00, 0x00,
    0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image12_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0xa5, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xcd, 0x94, 0x41, 0x0e, 0xc3,
    0x20, 0x0c, 0x04, 0x67, 0xa3, 0xbc, 0x84, 0x67, 0xc0, 0xfb, 0xcd, 0x33,
    0xf2, 0x15, 0xf7, 0x40, 0x53, 0x41, 0x9a, 0x02, 0x89, 0x72, 0xe8, 0x4a,
    0x1c, 0x90, 0xcc, 0x60, 0xb3, 0x2b, 0x64, 0xd9, 0x78, 0x42, 0xcb, 0x23,
    0x14, 0x60, 0x05, 0x48, 0x31, 0xf9, 0x9d, 0xc3, 0x96, 0x4d, 0x0d, 0x08,
    0xc0, 0x7d, 0xbb, 0x04, 0x91, 0x42, 0xb3, 0x7f, 0x6c, 0xb4, 0xff, 0x03,
    0xad, 0xe3, 0x92, 0xa2, 0xe3, 0x9b, 0x1c, 0x35, 0xd5, 0x91, 0x14, 0x70,
    0xdf, 0x9a, 0x05, 0xad, 0xdb, 0x43, 0xd0, 0x0e, 0x39, 0x93, 0xfb, 0xf6,
    0x81, 0x75, 0x47, 0xeb, 0x41, 0x6a, 0x98, 0x14, 0x7c, 0x01, 0xb8, 0x95,
    0xc6, 0xe3, 0xa5, 0x5e, 0x71, 0xd4, 0xab, 0xfc, 0xd1, 0x0d, 0x94, 0xce,
    0x65, 0xd9, 0x88, 0x31, 0x79, 0xae, 0xe2, 0xbe, 0x2b, 0xc5, 0xe4, 0x33,
    0x89, 0x97, 0x42, 0x79, 0xec, 0x33, 0xc8, 0x55, 0x75, 0x5d, 0xb3, 0x6c,
    0x1a, 0xe5, 0x47, 0x0a, 0x58, 0x36, 0x0d, 0xed, 0xef, 0xc1, 0x76, 0x08,
    0x4c, 0x26, 0xfb, 0x0d, 0xfb, 0x32, 0xb7, 0xfe, 0x46, 0x5e, 0x87, 0x3a,
    0x48, 0x55, 0x0a, 0x39, 0x15, 0xe9, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
    0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image13_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x9d, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xa5, 0x93, 0x41, 0x0e, 0x84,
    0x30, 0x0c, 0x03, 0xed, 0x15, 0xaf, 0x4a, 0xde, 0x9f, 0x7e, 0xcb, 0x7b,
    0x80, 0x5c, 0x80, 0xb6, 0x5e, 0x6d, 0x4e, 0x48, 0x85, 0xe9, 0xd8, 0x0a,
    0xac, 0x51, 0x70, 0x26, 0x22, 0x05, 0x00, 0x63, 0x14, 0xdf, 0xce, 0x8f,
    0x7f, 0x01, 0x5b, 0x90, 0x0b, 0x58, 0x82, 0x22, 0x52, 0x2e, 0xe0, 0x15,
    0xd4, 0x16, 0x04, 0xe0, 0x35, 0x77, 0x03, 0x3d, 0x62, 0x44, 0x2a, 0x23,
    0x55, 0x3f, 0x58, 0x1d, 0xb3, 0x18, 0x92, 0x40, 0xd2, 0x86, 0x7d, 0x56,
    0x5d, 0x48, 0x42, 0x5e, 0xb6, 0x5b, 0xd0, 0xee, 0x05, 0x17, 0xb6, 0x05,
    0xb9, 0x30, 0x0b, 0x44, 0x9e, 0xe9, 0x57, 0xb0, 0xe5, 0x66, 0x93, 0x84,
    0x74, 0x7e, 0xbb, 0x2b, 0x7d, 0x6a, 0xd4, 0x16, 0x80, 0x17, 0x6d, 0x6a,
    0xd4, 0x06, 0x24, 0xd5, 0x56, 0xb3, 0xc9, 0x48, 0xd1, 0xf9, 0xfb, 0x33,
    0x52, 0xd7, 0x5e, 0x3d, 0x22, 0xb6, 0xa9, 0x55, 0xf6, 0xea, 0x82, 0x7e,
    0xb6, 0x40, 0x35, 0x8a, 0x77, 0x9b, 0x7b, 0x67, 0x56, 0xb4, 0x95, 0x49,
    0xcf, 0x17, 0x1c, 0xf5, 0x63, 0xc2, 0x23, 0x9b, 0x25, 0x25, 0x00, 0x00,
    0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    static const unsigned char image14_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x12,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x56, 0xce, 0x8e, 0x57, 0x00, 0x00, 0x00,
    0x61, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xdd, 0xd3, 0xb1, 0x0e, 0xc0,
    0x20, 0x08, 0x04, 0xd0, 0x62, 0xfa, 0x55, 0xdc, 0xf7, 0x1f, 0xbf, 0x85,
    0x13, 0x0d, 0x69, 0xba, 0x88, 0x0c, 0x8d, 0x37, 0xe9, 0xe0, 0x1b, 0x0e,
    0x14, 0x1a, 0xaf, 0x8e, 0x8c, 0x16, 0xe5, 0x97, 0xd0, 0x9d, 0x2f, 0x50,
    0x78, 0x9c, 0x69, 0x94, 0x12, 0x04, 0x85, 0xaf, 0x3e, 0xce, 0x19, 0x1d,
    0xc8, 0x03, 0x75, 0xa4, 0x17, 0xa2, 0x51, 0x72, 0xd1, 0x95, 0x48, 0xde,
    0xec, 0x0a, 0x16, 0xdd, 0xca, 0x99, 0x5f, 0x04, 0x0a, 0xdf, 0x86, 0xa2,
    0xd7, 0x2d, 0x28, 0x0f, 0xa7, 0x0c, 0xbd, 0x27, 0x5c, 0x82, 0xbe, 0xd6,
    0x64, 0x02, 0xa6, 0xf1, 0x23, 0x81, 0xfc, 0x45, 0xc1, 0x4d, 0x00, 0x00,
    0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

    switch (id) {
        case image0_ID:  { QImage img; img.loadFromData(image0_data, sizeof(image0_data), "PNG"); return QPixmap::fromImage(img); }
        case image1_ID:  { QImage img; img.loadFromData(image1_data, sizeof(image1_data), "PNG"); return QPixmap::fromImage(img); }
        case image2_ID:  { QImage img; img.loadFromData(image2_data, sizeof(image2_data), "PNG"); return QPixmap::fromImage(img); }
        case image3_ID:  { QImage img; img.loadFromData(image3_data, sizeof(image3_data), "PNG"); return QPixmap::fromImage(img); }
        case image4_ID:  { QImage img; img.loadFromData(image4_data, sizeof(image4_data), "PNG"); return QPixmap::fromImage(img); }
        case image5_ID:  { QImage img; img.loadFromData(image5_data, sizeof(image5_data), "PNG"); return QPixmap::fromImage(img); }
        case image6_ID:  { QImage img; img.loadFromData(image6_data, sizeof(image6_data), "PNG"); return QPixmap::fromImage(img); }
        case image7_ID:  { QImage img; img.loadFromData(image7_data, sizeof(image7_data), "PNG"); return QPixmap::fromImage(img); }
        case image8_ID:  { QImage img; img.loadFromData(image8_data, sizeof(image8_data), "PNG"); return QPixmap::fromImage(img); }
        case image9_ID:  { QImage img; img.loadFromData(image9_data, sizeof(image9_data), "PNG"); return QPixmap::fromImage(img); }
        case image10_ID:  { QImage img; img.loadFromData(image10_data, sizeof(image10_data), "PNG"); return QPixmap::fromImage(img); }
        case image11_ID:  { QImage img; img.loadFromData(image11_data, sizeof(image11_data), "PNG"); return QPixmap::fromImage(img); }
        case image12_ID:  { QImage img; img.loadFromData(image12_data, sizeof(image12_data), "PNG"); return QPixmap::fromImage(img); }
        case image13_ID:  { QImage img; img.loadFromData(image13_data, sizeof(image13_data), "PNG"); return QPixmap::fromImage(img); }
        case image14_ID:  { QImage img; img.loadFromData(image14_data, sizeof(image14_data), "PNG"); return QPixmap::fromImage(img); }
        default: return QPixmap();
    } // switch
    } // icon

};

namespace Ui {
    class QG_CadToolBarMain: public Ui_QG_CadToolBarMain {};
} // namespace Ui

QT_END_NAMESPACE

class QG_CadToolBarMain : public QWidget, public Ui::QG_CadToolBarMain
{
    Q_OBJECT

public:
    QG_CadToolBarMain(QWidget* parent = 0, const char* name = 0, Qt::WindowFlags fl = 0);
    ~QG_CadToolBarMain();

public slots:
    virtual void init();
    virtual void setCadToolBar( QG_CadToolBar * tb );

protected slots:
    virtual void languageChange();

};

#endif // QG_CADTOOLBARMAIN_H
