/**
 * ================================================
 * LibLoader : a free Java resource loading library
 * ================================================
 *
 * Project Info:  http://reporting.pentaho.org/libloader/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * ImageIOFactoryModule.java
 * ------------
 */

package org.pentaho.reporting.libraries.resourceloader.modules.factory.imageio;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;
import org.pentaho.reporting.libraries.resourceloader.factory.AbstractFactoryModule;

public class ImageIOFactoryModule extends AbstractFactoryModule
{
  private static final int[] EMPTY_FINGERPRINT = new int[0];
  private static final String[] EMPTY_FILETYPE = new String[0];

  public ImageIOFactoryModule()
  {
  }

  private Image createImage(final byte[] imageData)
      throws IOException
  {
    return ImageIO.read(new ByteArrayInputStream(imageData));
  }


  public int canHandleResource(final ResourceManager caller, final ResourceData data)
      throws ResourceCreationException, ResourceLoadingException
  {
    try
    {
      final byte[] resource = data.getResource(caller);
      if (createImage(resource) != null)
      {
        return RECOGNIZED_CONTENTTYPE;
      }
    }
    catch (IOException e)
    {
      // ignore me ..
    }
    return REJECTED;
  }


  public Resource create(final ResourceManager caller, final ResourceData data, final ResourceKey context)
      throws ResourceCreationException, ResourceLoadingException
  {
    final long version = data.getVersion(caller);
    final byte[] resource = data.getResource(caller);
    final Image image;
    try
    {
      image = createImage(resource);
    }
    catch (IOException e)
    {
      throw new ResourceCreationException("Failed to load the image.", e);
    }
    
    if (image == null)
    {
      throw new ResourceCreationException("Failed to load the image. ImageIO#read returned null");
    }

    return new SimpleResource(data.getKey(), image, version);
  }

  protected String[] getMimeTypes()
  {
    return EMPTY_FILETYPE;
  }

  protected String[] getFileExtensions()
  {
    return EMPTY_FILETYPE;
  }

  protected int[] getFingerPrint()
  {
    return EMPTY_FINGERPRINT;
  }

  public int getHeaderFingerprintSize()
  {
    return 0;
  }
}
