/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * $Id: DateValueFunctionTest.java 7205 2008-12-11 18:20:27Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.util.Locale;
import java.util.TimeZone;

import org.pentaho.reporting.libraries.formula.FormulaTestBase;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaBoot;

/**
 * @author Cedric Pronzato
 */
public class DateValueFunctionTest extends FormulaTestBase
{
  public Object[][] createDataTest()
  {
    return new Object[][]
        {
            {"DATEVALUE(\"2004-12-25\")=DATE(2004;12;25)", Boolean.TRUE},
        };
  }


  public void testFrenchDateParsing() throws Exception
  {
    final DefaultFormulaContext context = new DefaultFormulaContext(LibFormulaBoot.getInstance().getGlobalConfig(),
        Locale.FRENCH, TimeZone.getDefault());

    performTest("DATEVALUE(\"25/12/2004\")=DATE(2004;12;25)", Boolean.TRUE, context);
  }

  public void testDefault() throws Exception
  {
    runDefaultTest();
  }


}
