/**
 * =========================================
 * LibXML : a free Java layouting library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libxml/
 *
 * (C) Copyright 2006-2008, by Object Refinery Ltd, Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * PropertyReadHandler.java
 * ------------
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * The Property-ReadHandler reads character data from an element along with
 * a 'name' attribute. This way, this class is most suitable for creating
 * name-value-pairs.
 *
 * @author Thomas Morgner
 */
public class PropertyReadHandler extends StringReadHandler
{
  private String name;

  /**
   * The Default-Constructor.
   */
  public PropertyReadHandler()
  {
  }

  /**
   * Starts parsing.
   *
   * @param attrs the attributes.
   * @throws SAXException if there is a parsing error.
   */
  protected void startParsing(final Attributes attrs) throws SAXException
  {
    super.startParsing(attrs);
    name = attrs.getValue(getUri(), "name");
    if (name == null)
    {
      throw new ParseException("Required attribute 'name' missing", getLocator());
    }
  }

  /**
   * Returns the declared property-name.
   *
   * @return the property name.
   */
  public String getName()
  {
    return name;
  }
}
