/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_DEVINF_OBJ_H_
#define _SML_DEVINF_OBJ_H_

typedef struct SmlDevInfAgent SmlDevInfAgent;

// only the SmlDevInf pointer of smlDevInfAgentNew is the local DevInf
// all other SmlDevInf pointers are the DevInf of the remote peer

SmlDevInfAgent *smlDevInfAgentNew(SmlDevInf *devinf, SmlError **error);
void smlDevInfAgentFree(SmlDevInfAgent *agent);
void smlDevInfAgentSetDevInf(SmlDevInfAgent *agent, SmlDevInf *devinf);
SmlDevInf *smlDevInfAgentGetDevInf(SmlDevInfAgent *agent);
SmlBool smlDevInfAgentRegisterSession(SmlDevInfAgent *agent, SmlManager *manager, SmlSession *session, SmlError **error);
SmlBool smlDevInfAgentRegister(SmlDevInfAgent *agent, SmlManager *manager, SmlError **error);
SmlBool smlDevInfAgentSendDevInf(SmlDevInfAgent *agent, SmlSession *session, SmlError **error);
SmlBool smlDevInfAgentRequestDevInf(SmlDevInfAgent *agent, SmlSession *session, SmlError **error);

#endif //_SML_DEVINF_OBJ_H_
