/* unity-appinfo-manager.c generated by valac 0.12.0, the Vala compiler
 * generated from unity-appinfo-manager.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
/*
 * IMPLEMENTATION NOTE:
 * We want the generatedd C API to be nice and not too Vala-ish. We must
 * anticipate that place daemons consuming libunity will be written in
 * both Vala and C.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <gobject/gvaluecollector.h>


#define UNITY_TYPE_STRING_ARRAY_WRAPPER (unity_string_array_wrapper_get_type ())
#define UNITY_STRING_ARRAY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_STRING_ARRAY_WRAPPER, UnityStringArrayWrapper))
#define UNITY_STRING_ARRAY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_STRING_ARRAY_WRAPPER, UnityStringArrayWrapperClass))
#define UNITY_IS_STRING_ARRAY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_STRING_ARRAY_WRAPPER))
#define UNITY_IS_STRING_ARRAY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_STRING_ARRAY_WRAPPER))
#define UNITY_STRING_ARRAY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_STRING_ARRAY_WRAPPER, UnityStringArrayWrapperClass))

typedef struct _UnityStringArrayWrapper UnityStringArrayWrapper;
typedef struct _UnityStringArrayWrapperClass UnityStringArrayWrapperClass;
typedef struct _UnityStringArrayWrapperPrivate UnityStringArrayWrapperPrivate;
typedef struct _UnityParamSpecStringArrayWrapper UnityParamSpecStringArrayWrapper;

#define UNITY_TYPE_APP_INFO_MANAGER (unity_app_info_manager_get_type ())
#define UNITY_APP_INFO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_APP_INFO_MANAGER, UnityAppInfoManager))
#define UNITY_APP_INFO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_APP_INFO_MANAGER, UnityAppInfoManagerClass))
#define UNITY_IS_APP_INFO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_APP_INFO_MANAGER))
#define UNITY_IS_APP_INFO_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_APP_INFO_MANAGER))
#define UNITY_APP_INFO_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_APP_INFO_MANAGER, UnityAppInfoManagerClass))

typedef struct _UnityAppInfoManager UnityAppInfoManager;
typedef struct _UnityAppInfoManagerClass UnityAppInfoManagerClass;
typedef struct _UnityAppInfoManagerPrivate UnityAppInfoManagerPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _unity_string_array_wrapper_unref0(var) ((var == NULL) ? NULL : (var = (unity_string_array_wrapper_unref (var), NULL)))
typedef struct _UnityAppInfoManagerLookupAsyncData UnityAppInfoManagerLookupAsyncData;

struct _UnityStringArrayWrapper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityStringArrayWrapperPrivate * priv;
	gchar** strings;
	gint strings_length1;
	gint _strings_size_;
};

struct _UnityStringArrayWrapperClass {
	GTypeClass parent_class;
	void (*finalize) (UnityStringArrayWrapper *self);
};

struct _UnityParamSpecStringArrayWrapper {
	GParamSpec parent_instance;
};

struct _UnityAppInfoManager {
	GObject parent_instance;
	UnityAppInfoManagerPrivate * priv;
};

struct _UnityAppInfoManagerClass {
	GObjectClass parent_class;
};

struct _UnityAppInfoManagerPrivate {
	GHashTable* appinfo_by_id;
	GHashTable* monitors;
	GHashTable* categories_by_id;
};

struct _UnityAppInfoManagerLookupAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityAppInfoManager* self;
	gchar* id;
	GAppInfo* result;
	gboolean _tmp0_;
	gconstpointer _tmp1_;
	GAppInfo* _tmp2_;
	gsize data_size;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	GFileInputStream* input;
	gboolean _tmp3_;
	GFile* _tmp4_;
	GFile* f;
	GFileInputStream* _tmp5_;
	GFileInputStream* _tmp6_;
	GFile* _tmp7_;
	GFile* dir;
	gchar* _tmp8_;
	gchar* dir_uri;
	gconstpointer _tmp9_;
	GFileMonitor* _tmp10_;
	GFileMonitor* monitor;
	gchar* _tmp11_;
	GFileMonitor* _tmp12_;
	GError * ioe;
	gchar* _tmp13_;
	gchar* path;
	GFileInputStream* _tmp14_;
	GFileInputStream* _tmp15_;
	gchar* _tmp16_;
	guint8* _tmp17_;
	gint _tmp18_;
	gsize _tmp19_;
	GError * e;
	GKeyFile* _tmp20_;
	GKeyFile* keyfile;
	GError * ee;
	GDesktopAppInfo* _tmp21_;
	GDesktopAppInfo* appinfo;
	gchar* _tmp22_;
	GAppInfo* _tmp23_;
	gsize _tmp24_;
	gchar** _tmp25_;
	gchar** categories;
	gint categories_length1;
	gint _categories_size_;
	UnityStringArrayWrapper* _tmp26_;
	UnityStringArrayWrapper* wrapper;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gchar* _tmp29_;
	UnityStringArrayWrapper* _tmp30_;
	GError * eee;
	GError * _inner_error_;
};


static gpointer unity_string_array_wrapper_parent_class = NULL;
static gpointer unity_app_info_manager_parent_class = NULL;
static UnityAppInfoManager* unity_app_info_manager_singleton;
static UnityAppInfoManager* unity_app_info_manager_singleton = NULL;

gpointer unity_string_array_wrapper_ref (gpointer instance);
void unity_string_array_wrapper_unref (gpointer instance);
GParamSpec* unity_param_spec_string_array_wrapper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_value_set_string_array_wrapper (GValue* value, gpointer v_object);
void unity_value_take_string_array_wrapper (GValue* value, gpointer v_object);
gpointer unity_value_get_string_array_wrapper (const GValue* value);
GType unity_string_array_wrapper_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_STRING_ARRAY_WRAPPER_DUMMY_PROPERTY
};
UnityStringArrayWrapper* unity_string_array_wrapper_new (void);
UnityStringArrayWrapper* unity_string_array_wrapper_construct (GType object_type);
static void unity_string_array_wrapper_finalize (UnityStringArrayWrapper* obj);
GType unity_app_info_manager_get_type (void) G_GNUC_CONST;
#define UNITY_APP_INFO_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_APP_INFO_MANAGER, UnityAppInfoManagerPrivate))
enum  {
	UNITY_APP_INFO_MANAGER_DUMMY_PROPERTY
};
static UnityAppInfoManager* unity_app_info_manager_new (void);
static UnityAppInfoManager* unity_app_info_manager_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _unity_string_array_wrapper_unref0_ (gpointer var);
gchar** unity_io_get_system_data_dirs (int* result_length1);
static void unity_app_info_manager_on_dir_changed (UnityAppInfoManager* self, GFileMonitor* mon, GFile* file, GFile* other_file, GFileMonitorEvent e);
static void _unity_app_info_manager_on_dir_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
UnityAppInfoManager* unity_app_info_manager_get_instance (void);
GAppInfo* unity_app_info_manager_lookup (UnityAppInfoManager* self, const gchar* id);
static gchar** _vala_array_dup1 (gchar** self, int length);
gchar** unity_app_info_manager_get_categories (UnityAppInfoManager* self, const gchar* id, int* result_length1);
static void unity_app_info_manager_lookup_async_data_free (gpointer _data);
void unity_app_info_manager_lookup_async (UnityAppInfoManager* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GAppInfo* unity_app_info_manager_lookup_finish (UnityAppInfoManager* self, GAsyncResult* _res_, GError** error);
static gboolean unity_app_info_manager_lookup_async_co (UnityAppInfoManagerLookupAsyncData* data);
static void unity_app_info_manager_lookup_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void unity_io_open_from_data_dirs (const gchar* filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFileInputStream* unity_io_open_from_data_dirs_finish (GAsyncResult* _res_, GError** error);
void unity_io_read_stream_async (GInputStream* input, gint io_priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_io_read_stream_finish (GAsyncResult* _res_, guint8** data, int* data_length1, gsize* size, GError** error);
static gchar** _vala_array_dup2 (gchar** self, int length);
void unity_app_info_manager_clear (UnityAppInfoManager* self);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void unity_app_info_manager_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


UnityStringArrayWrapper* unity_string_array_wrapper_construct (GType object_type) {
	UnityStringArrayWrapper* self = NULL;
	self = (UnityStringArrayWrapper*) g_type_create_instance (object_type);
	return self;
}


UnityStringArrayWrapper* unity_string_array_wrapper_new (void) {
	return unity_string_array_wrapper_construct (UNITY_TYPE_STRING_ARRAY_WRAPPER);
}


static void unity_value_string_array_wrapper_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_value_string_array_wrapper_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_string_array_wrapper_unref (value->data[0].v_pointer);
	}
}


static void unity_value_string_array_wrapper_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_string_array_wrapper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_value_string_array_wrapper_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_value_string_array_wrapper_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityStringArrayWrapper* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_string_array_wrapper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_value_string_array_wrapper_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityStringArrayWrapper** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_string_array_wrapper_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_param_spec_string_array_wrapper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityParamSpecStringArrayWrapper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_TYPE_STRING_ARRAY_WRAPPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_value_get_string_array_wrapper (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STRING_ARRAY_WRAPPER), NULL);
	return value->data[0].v_pointer;
}


void unity_value_set_string_array_wrapper (GValue* value, gpointer v_object) {
	UnityStringArrayWrapper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STRING_ARRAY_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TYPE_STRING_ARRAY_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_string_array_wrapper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_string_array_wrapper_unref (old);
	}
}


void unity_value_take_string_array_wrapper (GValue* value, gpointer v_object) {
	UnityStringArrayWrapper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_TYPE_STRING_ARRAY_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_TYPE_STRING_ARRAY_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_string_array_wrapper_unref (old);
	}
}


static void unity_string_array_wrapper_class_init (UnityStringArrayWrapperClass * klass) {
	unity_string_array_wrapper_parent_class = g_type_class_peek_parent (klass);
	UNITY_STRING_ARRAY_WRAPPER_CLASS (klass)->finalize = unity_string_array_wrapper_finalize;
}


static void unity_string_array_wrapper_instance_init (UnityStringArrayWrapper * self) {
	self->ref_count = 1;
}


static void unity_string_array_wrapper_finalize (UnityStringArrayWrapper* obj) {
	UnityStringArrayWrapper * self;
	self = UNITY_STRING_ARRAY_WRAPPER (obj);
	self->strings = (_vala_array_free (self->strings, self->strings_length1, (GDestroyNotify) g_free), NULL);
}


GType unity_string_array_wrapper_get_type (void) {
	static volatile gsize unity_string_array_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&unity_string_array_wrapper_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_value_string_array_wrapper_init, unity_value_string_array_wrapper_free_value, unity_value_string_array_wrapper_copy_value, unity_value_string_array_wrapper_peek_pointer, "p", unity_value_string_array_wrapper_collect_value, "p", unity_value_string_array_wrapper_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityStringArrayWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_string_array_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityStringArrayWrapper), 0, (GInstanceInitFunc) unity_string_array_wrapper_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_string_array_wrapper_type_id;
		unity_string_array_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityStringArrayWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_string_array_wrapper_type_id__volatile, unity_string_array_wrapper_type_id);
	}
	return unity_string_array_wrapper_type_id__volatile;
}


gpointer unity_string_array_wrapper_ref (gpointer instance) {
	UnityStringArrayWrapper* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_string_array_wrapper_unref (gpointer instance) {
	UnityStringArrayWrapper* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_STRING_ARRAY_WRAPPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _unity_string_array_wrapper_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (unity_string_array_wrapper_unref (var), NULL));
}


static void _unity_app_info_manager_on_dir_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	unity_app_info_manager_on_dir_changed (self, _sender, file, other_file, event_type);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static UnityAppInfoManager* unity_app_info_manager_construct (GType object_type) {
	UnityAppInfoManager * self = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	gint _tmp3_;
	gchar** _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	self = (UnityAppInfoManager*) g_object_new (object_type, NULL);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->appinfo_by_id);
	self->priv->appinfo_by_id = _tmp0_;
	_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _unity_string_array_wrapper_unref0_);
	_g_hash_table_unref0 (self->priv->categories_by_id);
	self->priv->categories_by_id = _tmp1_;
	_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->monitors);
	self->priv->monitors = _tmp2_;
	_tmp4_ = unity_io_get_system_data_dirs (&_tmp3_);
	{
		gchar** path_collection;
		int path_collection_length1;
		int path_it;
		path_collection = _tmp4_;
		path_collection_length1 = _tmp3_;
		for (path_it = 0; path_it < _tmp3_; path_it = path_it + 1) {
			gchar* _tmp5_;
			gchar* path;
			_tmp5_ = g_strdup (path_collection[path_it]);
			path = _tmp5_;
			{
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				GFile* _tmp8_ = NULL;
				GFile* _tmp9_;
				GFile* dir;
				GFileMonitor* _tmp10_ = NULL;
				GFileMonitor* monitor;
				gchar* _tmp11_ = NULL;
				GFileMonitor* _tmp12_;
				_tmp6_ = g_build_filename (path, "applications", NULL);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_file_new_for_path (_tmp7_);
				_tmp9_ = _tmp8_;
				_g_free0 (_tmp7_);
				dir = _tmp9_;
				_tmp10_ = g_file_monitor_directory (dir, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
				monitor = _tmp10_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_IO_ERROR) {
						goto __catch0_g_io_error;
					}
					_g_object_unref0 (dir);
					_g_free0 (path);
					path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				g_signal_connect_object (monitor, "changed", (GCallback) _unity_app_info_manager_on_dir_changed_g_file_monitor_changed, self, 0);
				_tmp11_ = g_file_get_uri (dir);
				_tmp12_ = _g_object_ref0 (monitor);
				g_hash_table_insert (self->priv->monitors, _tmp11_, _tmp12_);
				_g_object_unref0 (monitor);
				goto __finally0;
				__catch0_g_io_error:
				{
					GError * e;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp13_ = g_file_get_uri (dir);
					_tmp14_ = _tmp13_;
					g_warning ("unity-appinfo-manager.vala:73: Error setting up directory monitor on '" \
"%s': %s", _tmp14_, e->message);
					_g_free0 (_tmp14_);
					_g_error_free0 (e);
				}
				__finally0:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (dir);
					_g_free0 (path);
					path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_object_unref0 (dir);
				_g_free0 (path);
			}
		}
		path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	return self;
}


static UnityAppInfoManager* unity_app_info_manager_new (void) {
	return unity_app_info_manager_construct (UNITY_TYPE_APP_INFO_MANAGER);
}


/**
     * Get a ref to the singleton AppInfoManager
     */
UnityAppInfoManager* unity_app_info_manager_get_instance (void) {
	UnityAppInfoManager* result = NULL;
	UnityAppInfoManager* _tmp1_;
	if (unity_app_info_manager_singleton == NULL) {
		UnityAppInfoManager* _tmp0_ = NULL;
		_tmp0_ = unity_app_info_manager_new ();
		_g_object_unref0 (unity_app_info_manager_singleton);
		unity_app_info_manager_singleton = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (unity_app_info_manager_singleton);
	result = _tmp1_;
	return result;
}


static void unity_app_info_manager_on_dir_changed (UnityAppInfoManager* self, GFileMonitor* mon, GFile* file, GFile* other_file, GFileMonitorEvent e) {
	gchar* _tmp0_ = NULL;
	gchar* desktop_id;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GAppInfo* appinfo = NULL;
	gboolean _tmp2_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mon != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_basename (file);
	desktop_id = _tmp0_;
	_tmp1_ = g_file_get_path (file);
	path = _tmp1_;
	_tmp2_ = g_hash_table_remove (self->priv->appinfo_by_id, desktop_id);
	if (_tmp2_) {
		GAppInfo* _tmp3_ = NULL;
		_tmp3_ = unity_app_info_manager_lookup (self, desktop_id);
		_g_object_unref0 (appinfo);
		appinfo = _tmp3_;
		g_signal_emit_by_name (self, "changed", desktop_id, appinfo);
	}
	_tmp4_ = g_hash_table_remove (self->priv->appinfo_by_id, path);
	if (_tmp4_) {
		GAppInfo* _tmp5_ = NULL;
		_tmp5_ = unity_app_info_manager_lookup (self, path);
		_g_object_unref0 (appinfo);
		appinfo = _tmp5_;
		g_signal_emit_by_name (self, "changed", path, appinfo);
	}
	_g_object_unref0 (appinfo);
	_g_free0 (path);
	_g_free0 (desktop_id);
}


/**
     * Look up an AppInfo given its desktop id or absolute path. The desktop id
     * is the base filename of the .desktop file for the application including
     * the .desktop extension.
     *
     * If the AppInfo is not already cached this method will do synchronous
     * IO to look it up.
     */
static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gpointer _unity_string_array_wrapper_ref0 (gpointer self) {
	return self ? unity_string_array_wrapper_ref (self) : NULL;
}


GAppInfo* unity_app_info_manager_lookup (UnityAppInfoManager* self, const gchar* id) {
	GAppInfo* result = NULL;
	gboolean _tmp0_;
	GAppInfo* appinfo = NULL;
	GKeyFile* _tmp3_ = NULL;
	GKeyFile* keyfile;
	gboolean _tmp4_;
	gchar* _tmp26_;
	GAppInfo* _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = g_hash_table_lookup_extended (self->priv->appinfo_by_id, id, NULL, NULL);
	if (_tmp0_) {
		gconstpointer _tmp1_ = NULL;
		GAppInfo* _tmp2_;
		_tmp1_ = g_hash_table_lookup (self->priv->appinfo_by_id, id);
		_tmp2_ = _g_object_ref0 ((GAppInfo*) _tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_key_file_new ();
	keyfile = _tmp3_;
	_tmp4_ = g_str_has_prefix (id, "/");
	if (_tmp4_) {
		GFile* _tmp6_ = NULL;
		GFile* _tmp7_;
		GFile* _tmp8_ = NULL;
		GFile* _tmp9_;
		GFile* dir;
		gchar* _tmp10_ = NULL;
		gchar* dir_uri;
		gconstpointer _tmp11_ = NULL;
		g_key_file_load_from_file (keyfile, id, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			gboolean _tmp5_ = FALSE;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_key_file_free0 (keyfile);
			keyfile = NULL;
			if (g_error_matches (e, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				_tmp5_ = TRUE;
			} else {
				_tmp5_ = g_error_matches (e, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_NOT_FOUND);
			}
			if (!_tmp5_) {
				g_warning ("unity-appinfo-manager.vala:142: Error loading '%s': %s", id, e->message);
			}
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_key_file_free0 (keyfile);
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = g_file_new_for_path (id);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_get_parent (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		dir = _tmp9_;
		_tmp10_ = g_file_get_uri (dir);
		dir_uri = _tmp10_;
		_tmp11_ = g_hash_table_lookup (self->priv->monitors, dir_uri);
		if (((GFileMonitor*) _tmp11_) == NULL) {
			GFileMonitor* _tmp12_ = NULL;
			GFileMonitor* monitor;
			gchar* _tmp13_;
			GFileMonitor* _tmp14_;
			_tmp12_ = g_file_monitor_directory (dir, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
			monitor = _tmp12_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch2_g_io_error;
				}
				_g_free0 (dir_uri);
				_g_object_unref0 (dir);
				_g_key_file_free0 (keyfile);
				_g_object_unref0 (appinfo);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			g_signal_connect_object (monitor, "changed", (GCallback) _unity_app_info_manager_on_dir_changed_g_file_monitor_changed, self, 0);
			_tmp13_ = g_strdup (dir_uri);
			_tmp14_ = _g_object_ref0 (monitor);
			g_hash_table_insert (self->priv->monitors, _tmp13_, _tmp14_);
			g_debug ("unity-appinfo-manager.vala:152: Monitoring extra app directory: %s", dir_uri);
			_g_object_unref0 (monitor);
			goto __finally2;
			__catch2_g_io_error:
			{
				GError * ioe;
				ioe = _inner_error_;
				_inner_error_ = NULL;
				g_warning ("unity-appinfo-manager.vala:154: Error setting up extra app directory m" \
"onitor on '%s': %s", dir_uri, ioe->message);
				_g_error_free0 (ioe);
			}
			__finally2:
			if (_inner_error_ != NULL) {
				_g_free0 (dir_uri);
				_g_object_unref0 (dir);
				_g_key_file_free0 (keyfile);
				_g_object_unref0 (appinfo);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_g_free0 (dir_uri);
		_g_object_unref0 (dir);
	} else {
		gchar* _tmp15_ = NULL;
		gchar* path;
		gchar* full_path = NULL;
		gchar* _tmp16_ = NULL;
		_tmp15_ = g_build_filename ("applications", id, NULL, NULL);
		path = _tmp15_;
		g_key_file_load_from_data_dirs (keyfile, path, &_tmp16_, G_KEY_FILE_NONE, &_inner_error_);
		_g_free0 (full_path);
		full_path = _tmp16_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * e;
			gboolean _tmp17_ = FALSE;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_key_file_free0 (keyfile);
			keyfile = NULL;
			if (g_error_matches (e, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				_tmp17_ = TRUE;
			} else {
				_tmp17_ = g_error_matches (e, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_NOT_FOUND);
			}
			if (!_tmp17_) {
				g_warning ("unity-appinfo-manager.vala:168: Error loading '%s': %s", id, e->message);
			}
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_free0 (full_path);
			_g_free0 (path);
			_g_key_file_free0 (keyfile);
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (full_path);
		_g_free0 (path);
	}
	if (keyfile != NULL) {
		GDesktopAppInfo* _tmp18_ = NULL;
		gsize _tmp19_;
		gchar** _tmp20_ = NULL;
		gchar** categories;
		gint categories_length1;
		gint _categories_size_;
		UnityStringArrayWrapper* _tmp21_ = NULL;
		UnityStringArrayWrapper* wrapper;
		gchar** _tmp22_;
		gchar** _tmp23_;
		gchar* _tmp24_;
		UnityStringArrayWrapper* _tmp25_;
		_tmp18_ = g_desktop_app_info_new_from_keyfile (keyfile);
		_g_object_unref0 (appinfo);
		appinfo = (GAppInfo*) _tmp18_;
		_tmp20_ = g_key_file_get_string_list (keyfile, "Desktop Entry", "Categories", &_tmp19_, &_inner_error_);
		categories = _tmp20_;
		categories_length1 = _tmp19_;
		_categories_size_ = _tmp19_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch4_g_key_file_error;
			}
			_g_key_file_free0 (keyfile);
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp21_ = unity_string_array_wrapper_new ();
		wrapper = _tmp21_;
		_tmp22_ = (_tmp23_ = categories, (_tmp23_ == NULL) ? ((gpointer) _tmp23_) : _vala_array_dup1 (_tmp23_, categories_length1));
		wrapper->strings = (_vala_array_free (wrapper->strings, wrapper->strings_length1, (GDestroyNotify) g_free), NULL);
		wrapper->strings = _tmp22_;
		wrapper->strings_length1 = categories_length1;
		wrapper->_strings_size_ = categories_length1;
		_tmp24_ = g_strdup (id);
		_tmp25_ = _unity_string_array_wrapper_ref0 (wrapper);
		g_hash_table_insert (self->priv->categories_by_id, _tmp24_, _tmp25_);
		_unity_string_array_wrapper_unref0 (wrapper);
		categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
		goto __finally4;
		__catch4_g_key_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_key_file_free0 (keyfile);
			_g_object_unref0 (appinfo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	} else {
		_g_object_unref0 (appinfo);
		appinfo = NULL;
	}
	_tmp26_ = g_strdup (id);
	_tmp27_ = _g_object_ref0 (appinfo);
	g_hash_table_insert (self->priv->appinfo_by_id, _tmp26_, _tmp27_);
	result = appinfo;
	_g_key_file_free0 (keyfile);
	return result;
}


/**
     * Look up XDG categories for for desktop id or file path @id.
     * Returns null if id is not found.
     * This method will do sync IO if the desktop file for @id is not
     * already cached. So if you are living in an async world you must first
     * do an async call to lookup_async(id) before calling this method, in which
     * case no sync io will be done.
     */
gchar** unity_app_info_manager_get_categories (UnityAppInfoManager* self, const gchar* id, int* result_length1) {
	gchar** result = NULL;
	GAppInfo* _tmp0_ = NULL;
	GAppInfo* appinfo;
	gconstpointer _tmp2_ = NULL;
	UnityStringArrayWrapper* _tmp3_;
	UnityStringArrayWrapper* _result_;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint __tmp4__size_ = 0;
	gchar** _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = unity_app_info_manager_lookup (self, id);
	appinfo = _tmp0_;
	if (appinfo == NULL) {
		gpointer _tmp1_;
		_tmp1_ = NULL;
		*result_length1 = 0;
		result = _tmp1_;
		_g_object_unref0 (appinfo);
		return result;
	}
	_tmp2_ = g_hash_table_lookup (self->priv->categories_by_id, id);
	_tmp3_ = _unity_string_array_wrapper_ref0 ((UnityStringArrayWrapper*) _tmp2_);
	_result_ = _tmp3_;
	if (_result_ != NULL) {
		_tmp4_ = _result_->strings;
		_tmp4__length1 = _result_->strings_length1;
		__tmp4__size_ = _result_->strings_length1;
	} else {
		_tmp4_ = NULL;
		_tmp4__length1 = 0;
		__tmp4__size_ = 0;
	}
	_tmp5_ = _tmp4_;
	*result_length1 = _tmp4__length1;
	result = _tmp5_;
	_unity_string_array_wrapper_unref0 (_result_);
	_g_object_unref0 (appinfo);
	return result;
}


static void unity_app_info_manager_lookup_async_data_free (gpointer _data) {
	UnityAppInfoManagerLookupAsyncData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (UnityAppInfoManagerLookupAsyncData, data);
}


void unity_app_info_manager_lookup_async (UnityAppInfoManager* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityAppInfoManagerLookupAsyncData* _data_;
	_data_ = g_slice_new0 (UnityAppInfoManagerLookupAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_app_info_manager_lookup_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_app_info_manager_lookup_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->id = g_strdup (id);
	unity_app_info_manager_lookup_async_co (_data_);
}


GAppInfo* unity_app_info_manager_lookup_finish (UnityAppInfoManager* self, GAsyncResult* _res_, GError** error) {
	GAppInfo* result;
	UnityAppInfoManagerLookupAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Look up an AppInfo given its desktop id or absolute path.
     * The desktop id is the base filename of the .desktop file for the
     * application including the .desktop extension.
     *
     * If the AppInfo is not already cached this method will do asynchronous
     * IO to look it up.
     */
static void unity_app_info_manager_lookup_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityAppInfoManagerLookupAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_app_info_manager_lookup_async_co (data);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gboolean unity_app_info_manager_lookup_async_co (UnityAppInfoManagerLookupAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = g_hash_table_lookup_extended (data->self->priv->appinfo_by_id, data->id, NULL, NULL);
	if (data->_tmp0_) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = g_hash_table_lookup (data->self->priv->appinfo_by_id, data->id);
		data->_tmp2_ = _g_object_ref0 ((GAppInfo*) data->_tmp1_);
		data->result = data->_tmp2_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->data_length1 = 0;
	data->_data_size_ = 0;
	data->_tmp3_ = g_str_has_prefix (data->id, "/");
	if (data->_tmp3_) {
		data->_tmp4_ = NULL;
		data->_tmp4_ = g_file_new_for_path (data->id);
		data->f = data->_tmp4_;
		data->_state_ = 1;
		g_file_read_async (data->f, G_PRIORITY_DEFAULT, NULL, unity_app_info_manager_lookup_async_ready, data);
		return FALSE;
		_state_1:
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_file_read_finish (data->f, data->_res_, &data->_inner_error_);
		data->_tmp6_ = data->_tmp5_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->f);
			_g_object_unref0 (data->input);
			data->data = (g_free (data->data), NULL);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->input);
		data->input = data->_tmp6_;
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_file_get_parent (data->f);
		data->dir = data->_tmp7_;
		data->_tmp8_ = NULL;
		data->_tmp8_ = g_file_get_uri (data->dir);
		data->dir_uri = data->_tmp8_;
		data->_tmp9_ = NULL;
		data->_tmp9_ = g_hash_table_lookup (data->self->priv->monitors, data->dir_uri);
		if (((GFileMonitor*) data->_tmp9_) == NULL) {
			data->_tmp10_ = NULL;
			data->_tmp10_ = g_file_monitor_directory (data->dir, G_FILE_MONITOR_NONE, NULL, &data->_inner_error_);
			data->monitor = data->_tmp10_;
			if (data->_inner_error_ != NULL) {
				if (data->_inner_error_->domain == G_IO_ERROR) {
					goto __catch5_g_io_error;
				}
				_g_free0 (data->dir_uri);
				_g_object_unref0 (data->dir);
				_g_object_unref0 (data->f);
				_g_object_unref0 (data->input);
				data->data = (g_free (data->data), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
			g_signal_connect_object (data->monitor, "changed", (GCallback) _unity_app_info_manager_on_dir_changed_g_file_monitor_changed, data->self, 0);
			data->_tmp11_ = g_strdup (data->dir_uri);
			data->_tmp12_ = _g_object_ref0 (data->monitor);
			g_hash_table_insert (data->self->priv->monitors, data->_tmp11_, data->_tmp12_);
			g_debug ("unity-appinfo-manager.vala:250: Monitoring extra app directory: %s", data->dir_uri);
			_g_object_unref0 (data->monitor);
			goto __finally5;
			__catch5_g_io_error:
			{
				data->ioe = data->_inner_error_;
				data->_inner_error_ = NULL;
				g_warning ("unity-appinfo-manager.vala:252: Error setting up extra app directory m" \
"onitor on '%s': %s", data->dir_uri, data->ioe->message);
				_g_error_free0 (data->ioe);
			}
			__finally5:
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_free0 (data->dir_uri);
				_g_object_unref0 (data->dir);
				_g_object_unref0 (data->f);
				_g_object_unref0 (data->input);
				data->data = (g_free (data->data), NULL);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
		}
		_g_free0 (data->dir_uri);
		_g_object_unref0 (data->dir);
		_g_object_unref0 (data->f);
	} else {
		data->_tmp13_ = NULL;
		data->_tmp13_ = g_build_filename ("applications", data->id, NULL, NULL);
		data->path = data->_tmp13_;
		data->_state_ = 2;
		unity_io_open_from_data_dirs (data->path, unity_app_info_manager_lookup_async_ready, data);
		return FALSE;
		_state_2:
		data->_tmp14_ = NULL;
		data->_tmp14_ = unity_io_open_from_data_dirs_finish (data->_res_, &data->_inner_error_);
		data->_tmp15_ = data->_tmp14_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->path);
			_g_object_unref0 (data->input);
			data->data = (g_free (data->data), NULL);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		_g_object_unref0 (data->input);
		data->input = data->_tmp15_;
		_g_free0 (data->path);
	}
	if (data->input == NULL) {
		data->_tmp16_ = g_strdup (data->id);
		g_hash_table_insert (data->self->priv->appinfo_by_id, data->_tmp16_, NULL);
		data->result = NULL;
		_g_object_unref0 (data->input);
		data->data = (g_free (data->data), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp17_ = NULL;
	data->_state_ = 3;
	unity_io_read_stream_async ((GInputStream*) data->input, G_PRIORITY_LOW, NULL, unity_app_info_manager_lookup_async_ready, data);
	return FALSE;
	_state_3:
	unity_io_read_stream_finish (data->_res_, &data->_tmp17_, &data->_tmp18_, &data->_tmp19_, &data->_inner_error_);
	data->data = (g_free (data->data), NULL);
	data->data = data->_tmp17_;
	data->data_length1 = data->_tmp18_;
	data->data_size = data->_tmp19_;
	if (data->_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	goto __finally6;
	__catch6_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("unity-appinfo-manager.vala:280: Error reading '%s': %s", data->id, data->e->message);
		data->result = NULL;
		_g_error_free0 (data->e);
		_g_object_unref0 (data->input);
		data->data = (g_free (data->data), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally6:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->input);
		data->data = (g_free (data->data), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp20_ = NULL;
	data->_tmp20_ = g_key_file_new ();
	data->keyfile = data->_tmp20_;
	g_key_file_load_from_data (data->keyfile, (const gchar*) data->data, data->data_size, G_KEY_FILE_NONE, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch7_g_error;
	}
	goto __finally7;
	__catch7_g_error:
	{
		data->ee = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("unity-appinfo-manager.vala:291: Error parsing '%s': %s", data->id, data->ee->message);
		data->result = NULL;
		_g_error_free0 (data->ee);
		_g_key_file_free0 (data->keyfile);
		_g_object_unref0 (data->input);
		data->data = (g_free (data->data), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally7:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_key_file_free0 (data->keyfile);
		_g_object_unref0 (data->input);
		data->data = (g_free (data->data), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp21_ = NULL;
	data->_tmp21_ = g_desktop_app_info_new_from_keyfile (data->keyfile);
	data->appinfo = data->_tmp21_;
	data->_tmp22_ = g_strdup (data->id);
	data->_tmp23_ = _g_object_ref0 ((GAppInfo*) data->appinfo);
	g_hash_table_insert (data->self->priv->appinfo_by_id, data->_tmp22_, data->_tmp23_);
	data->_tmp25_ = NULL;
	data->_tmp25_ = g_key_file_get_string_list (data->keyfile, "Desktop Entry", "Categories", &data->_tmp24_, &data->_inner_error_);
	data->categories = data->_tmp25_;
	data->categories_length1 = data->_tmp24_;
	data->_categories_size_ = data->_tmp24_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch8_g_key_file_error;
		}
		_g_object_unref0 (data->appinfo);
		_g_key_file_free0 (data->keyfile);
		_g_object_unref0 (data->input);
		data->data = (g_free (data->data), NULL);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp26_ = NULL;
	data->_tmp26_ = unity_string_array_wrapper_new ();
	data->wrapper = data->_tmp26_;
	data->_tmp27_ = (data->_tmp28_ = data->categories, (data->_tmp28_ == NULL) ? ((gpointer) data->_tmp28_) : _vala_array_dup2 (data->_tmp28_, data->categories_length1));
	data->wrapper->strings = (_vala_array_free (data->wrapper->strings, data->wrapper->strings_length1, (GDestroyNotify) g_free), NULL);
	data->wrapper->strings = data->_tmp27_;
	data->wrapper->strings_length1 = data->categories_length1;
	data->wrapper->_strings_size_ = data->categories_length1;
	data->_tmp29_ = g_strdup (data->id);
	data->_tmp30_ = _unity_string_array_wrapper_ref0 (data->wrapper);
	g_hash_table_insert (data->self->priv->categories_by_id, data->_tmp29_, data->_tmp30_);
	_unity_string_array_wrapper_unref0 (data->wrapper);
	data->categories = (_vala_array_free (data->categories, data->categories_length1, (GDestroyNotify) g_free), NULL);
	goto __finally8;
	__catch8_g_key_file_error:
	{
		data->eee = data->_inner_error_;
		data->_inner_error_ = NULL;
		_g_error_free0 (data->eee);
	}
	__finally8:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->appinfo);
		_g_key_file_free0 (data->keyfile);
		_g_object_unref0 (data->input);
		data->data = (g_free (data->data), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = (GAppInfo*) data->appinfo;
	_g_key_file_free0 (data->keyfile);
	_g_object_unref0 (data->input);
	data->data = (g_free (data->data), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->appinfo);
	_g_key_file_free0 (data->keyfile);
	_g_object_unref0 (data->input);
	data->data = (g_free (data->data), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void unity_app_info_manager_clear (UnityAppInfoManager* self) {
	g_return_if_fail (self != NULL);
	g_hash_table_remove_all (self->priv->appinfo_by_id);
	g_hash_table_remove_all (self->priv->categories_by_id);
}


static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void unity_app_info_manager_class_init (UnityAppInfoManagerClass * klass) {
	unity_app_info_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityAppInfoManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_app_info_manager_finalize;
	/**
	     * Emitted whenever an AppInfo in any of the monitored paths change.
	     * Note that @new_appinfo may be null in case it has been removed.
	     */
	g_signal_new ("changed", UNITY_TYPE_APP_INFO_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_APP_INFO);
}


static void unity_app_info_manager_instance_init (UnityAppInfoManager * self) {
	self->priv = UNITY_APP_INFO_MANAGER_GET_PRIVATE (self);
}


static void unity_app_info_manager_finalize (GObject* obj) {
	UnityAppInfoManager * self;
	self = UNITY_APP_INFO_MANAGER (obj);
	_g_hash_table_unref0 (self->priv->appinfo_by_id);
	_g_hash_table_unref0 (self->priv->monitors);
	_g_hash_table_unref0 (self->priv->categories_by_id);
	G_OBJECT_CLASS (unity_app_info_manager_parent_class)->finalize (obj);
}


/**
   * A singleton class that caches GLib.AppInfo objects.
   * Singletons are evil, yes, but this on slightly less
   * so because the exposed API is immutable.
   *
   * To detect when any of the managed AppInfo objects changes, appears,
   * or goes away listen for the 'changed' signal.
   */
GType unity_app_info_manager_get_type (void) {
	static volatile gsize unity_app_info_manager_type_id__volatile = 0;
	if (g_once_init_enter (&unity_app_info_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityAppInfoManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_app_info_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityAppInfoManager), 0, (GInstanceInitFunc) unity_app_info_manager_instance_init, NULL };
		GType unity_app_info_manager_type_id;
		unity_app_info_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityAppInfoManager", &g_define_type_info, 0);
		g_once_init_leave (&unity_app_info_manager_type_id__volatile, unity_app_info_manager_type_id);
	}
	return unity_app_info_manager_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



