/* unity-sound-menu.c generated by valac 0.12.1, the Vala compiler
 * generated from unity-sound-menu.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Conor Curran <conor.curran@canonical.com>
 *
 * Note: We aim to not wrap a typical MPRIS server but just expose to the consumer
 * the elements we need for it to populate. So that means things like Supported
 * Mime Types which are part of MPRIS but are not relevant to the consumer should 
 * remain hidden and as a result not used.
 *
 * Reasons why a client may not be able to 'embed' itself.
 *   1. Cannot find the desktop file from the name provided
 *   2. Name already taken on the bus, in the current implementation does it hang
 *      around waiting for the name to come available
 */

#include <glib.h>
#include <glib-object.h>
#include "unity.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>
#include <gio/gdesktopappinfo.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define UNITY_TYPE_MPRIS_GATEWAY (unity_mpris_gateway_get_type ())
#define UNITY_MPRIS_GATEWAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_MPRIS_GATEWAY, UnityMPRISGateway))
#define UNITY_MPRIS_GATEWAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_MPRIS_GATEWAY, UnityMPRISGatewayClass))
#define UNITY_IS_MPRIS_GATEWAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_MPRIS_GATEWAY))
#define UNITY_IS_MPRIS_GATEWAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_MPRIS_GATEWAY))
#define UNITY_MPRIS_GATEWAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_MPRIS_GATEWAY, UnityMPRISGatewayClass))

typedef struct _UnityMPRISGateway UnityMPRISGateway;
typedef struct _UnityMPRISGatewayClass UnityMPRISGatewayClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _UnityTrackMetadataPrivate {
	gchar* _artist;
	gchar* _title;
	gchar* _album;
	GFile* _art_location;
};

struct _UnityPlaylistPrivate {
	gchar* _id;
	gchar* _name;
	GIcon* _icon;
	GDateTime* _creation_date;
	GDateTime* _modification_date;
	GDateTime* _last_play_date;
};

struct _UnityMusicPlayerPrivate {
	UnityMPRISGateway* mpris_gateway;
	GeeArrayList* internal_playlists;
	GAppInfo* _app_info;
	gchar* _desktop_file_name;
	gboolean _is_blacklisted;
	gchar* _title;
	gboolean _can_go_next;
	gboolean _can_go_previous;
	gboolean _can_play;
	gboolean _can_pause;
	UnityTrackMetadata* _current_track;
	UnityPlaybackState _playback_state;
	UnityPlaylist* _current_playlist;
	DbusmenuMenuitem* _track_menu;
	DbusmenuMenuitem* _player_menu;
};


static gpointer unity_track_metadata_parent_class = NULL;
static gpointer unity_playlist_parent_class = NULL;
static gpointer unity_music_player_parent_class = NULL;

#define UNITY_TRACK_METADATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_TRACK_METADATA, UnityTrackMetadataPrivate))
enum  {
	UNITY_TRACK_METADATA_DUMMY_PROPERTY,
	UNITY_TRACK_METADATA_ARTIST,
	UNITY_TRACK_METADATA_TITLE,
	UNITY_TRACK_METADATA_ALBUM,
	UNITY_TRACK_METADATA_ART_LOCATION
};
static void unity_track_metadata_finalize (GObject* obj);
static void _vala_unity_track_metadata_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_track_metadata_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_PLAYLIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_PLAYLIST, UnityPlaylistPrivate))
enum  {
	UNITY_PLAYLIST_DUMMY_PROPERTY,
	UNITY_PLAYLIST_ID,
	UNITY_PLAYLIST_NAME,
	UNITY_PLAYLIST_ICON,
	UNITY_PLAYLIST_CREATION_DATE,
	UNITY_PLAYLIST_MODIFICATION_DATE,
	UNITY_PLAYLIST_LAST_PLAY_DATE
};
static void unity_playlist_finalize (GObject* obj);
static void _vala_unity_playlist_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_playlist_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_mpris_gateway_get_type (void) G_GNUC_CONST;
#define UNITY_MUSIC_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_MUSIC_PLAYER, UnityMusicPlayerPrivate))
enum  {
	UNITY_MUSIC_PLAYER_DUMMY_PROPERTY,
	UNITY_MUSIC_PLAYER_APP_INFO,
	UNITY_MUSIC_PLAYER_DESKTOP_FILE_NAME,
	UNITY_MUSIC_PLAYER_IS_BLACKLISTED,
	UNITY_MUSIC_PLAYER_TITLE,
	UNITY_MUSIC_PLAYER_CAN_GO_NEXT,
	UNITY_MUSIC_PLAYER_CAN_GO_PREVIOUS,
	UNITY_MUSIC_PLAYER_CAN_PLAY,
	UNITY_MUSIC_PLAYER_CAN_PAUSE,
	UNITY_MUSIC_PLAYER_CURRENT_TRACK,
	UNITY_MUSIC_PLAYER_PLAYBACK_STATE,
	UNITY_MUSIC_PLAYER_CURRENT_PLAYLIST,
	UNITY_MUSIC_PLAYER_TRACK_MENU,
	UNITY_MUSIC_PLAYER_PLAYER_MENU
};
static GAppInfo* unity_music_player_create_app_info (const gchar* desktop);
void unity_mpris_gateway_ensure_playlist_interface_is_raised (UnityMPRISGateway* self);
void unity_mpris_gateway_set_playlist_count (UnityMPRISGateway* self, gint value);
void unity_mpris_gateway_set_edited_playlist (UnityMPRISGateway* self, UnityPlaylist* value);
static GObject * unity_music_player_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
UnityMPRISGateway* unity_mpris_gateway_new (UnityMusicPlayer* client);
UnityMPRISGateway* unity_mpris_gateway_construct (GType object_type, UnityMusicPlayer* client);
static void unity_music_player_finalize (GObject* obj);
static void _vala_unity_music_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_music_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


UnityTrackMetadata* unity_track_metadata_construct (GType object_type) {
	UnityTrackMetadata * self = NULL;
	self = (UnityTrackMetadata*) g_object_new (object_type, NULL);
	return self;
}


UnityTrackMetadata* unity_track_metadata_new (void) {
	return unity_track_metadata_construct (UNITY_TYPE_TRACK_METADATA);
}


const gchar* unity_track_metadata_get_artist (UnityTrackMetadata* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_artist;
	return result;
}


void unity_track_metadata_set_artist (UnityTrackMetadata* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_artist);
	self->priv->_artist = _tmp0_;
	g_object_notify ((GObject *) self, "artist");
}


const gchar* unity_track_metadata_get_title (UnityTrackMetadata* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_title;
	return result;
}


void unity_track_metadata_set_title (UnityTrackMetadata* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp0_;
	g_object_notify ((GObject *) self, "title");
}


const gchar* unity_track_metadata_get_album (UnityTrackMetadata* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_album;
	return result;
}


void unity_track_metadata_set_album (UnityTrackMetadata* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_album);
	self->priv->_album = _tmp0_;
	g_object_notify ((GObject *) self, "album");
}


GFile* unity_track_metadata_get_art_location (UnityTrackMetadata* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_art_location;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_track_metadata_set_art_location (UnityTrackMetadata* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_art_location);
	self->priv->_art_location = _tmp0_;
	g_object_notify ((GObject *) self, "art-location");
}


static void unity_track_metadata_class_init (UnityTrackMetadataClass * klass) {
	unity_track_metadata_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityTrackMetadataPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_track_metadata_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_track_metadata_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_track_metadata_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_TRACK_METADATA_ARTIST, g_param_spec_string ("artist", "artist", "artist", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_TRACK_METADATA_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_TRACK_METADATA_ALBUM, g_param_spec_string ("album", "album", "album", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_TRACK_METADATA_ART_LOCATION, g_param_spec_object ("art-location", "art-location", "art-location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_track_metadata_instance_init (UnityTrackMetadata * self) {
	self->priv = UNITY_TRACK_METADATA_GET_PRIVATE (self);
}


static void unity_track_metadata_finalize (GObject* obj) {
	UnityTrackMetadata * self;
	self = UNITY_TRACK_METADATA (obj);
	_g_free0 (self->priv->_artist);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_album);
	_g_object_unref0 (self->priv->_art_location);
	G_OBJECT_CLASS (unity_track_metadata_parent_class)->finalize (obj);
}


GType unity_track_metadata_get_type (void) {
	static volatile gsize unity_track_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&unity_track_metadata_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityTrackMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_track_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityTrackMetadata), 0, (GInstanceInitFunc) unity_track_metadata_instance_init, NULL };
		GType unity_track_metadata_type_id;
		unity_track_metadata_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityTrackMetadata", &g_define_type_info, 0);
		g_once_init_leave (&unity_track_metadata_type_id__volatile, unity_track_metadata_type_id);
	}
	return unity_track_metadata_type_id__volatile;
}


static void _vala_unity_track_metadata_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityTrackMetadata * self;
	self = UNITY_TRACK_METADATA (object);
	switch (property_id) {
		case UNITY_TRACK_METADATA_ARTIST:
		g_value_set_string (value, unity_track_metadata_get_artist (self));
		break;
		case UNITY_TRACK_METADATA_TITLE:
		g_value_set_string (value, unity_track_metadata_get_title (self));
		break;
		case UNITY_TRACK_METADATA_ALBUM:
		g_value_set_string (value, unity_track_metadata_get_album (self));
		break;
		case UNITY_TRACK_METADATA_ART_LOCATION:
		g_value_set_object (value, unity_track_metadata_get_art_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_track_metadata_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityTrackMetadata * self;
	self = UNITY_TRACK_METADATA (object);
	switch (property_id) {
		case UNITY_TRACK_METADATA_ARTIST:
		unity_track_metadata_set_artist (self, g_value_get_string (value));
		break;
		case UNITY_TRACK_METADATA_TITLE:
		unity_track_metadata_set_title (self, g_value_get_string (value));
		break;
		case UNITY_TRACK_METADATA_ALBUM:
		unity_track_metadata_set_album (self, g_value_get_string (value));
		break;
		case UNITY_TRACK_METADATA_ART_LOCATION:
		unity_track_metadata_set_art_location (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPlaylist* unity_playlist_construct (GType object_type, const gchar* id) {
	UnityPlaylist * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	self = (UnityPlaylist*) g_object_new (object_type, "id", id, NULL);
	return self;
}


UnityPlaylist* unity_playlist_new (const gchar* id) {
	return unity_playlist_construct (UNITY_TYPE_PLAYLIST, id);
}


const gchar* unity_playlist_get_id (UnityPlaylist* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_id;
	return result;
}


static void unity_playlist_set_id (UnityPlaylist* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


const gchar* unity_playlist_get_name (UnityPlaylist* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


void unity_playlist_set_name (UnityPlaylist* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	g_object_notify ((GObject *) self, "name");
}


GIcon* unity_playlist_get_icon (UnityPlaylist* self) {
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon;
	return result;
}


void unity_playlist_set_icon (UnityPlaylist* self, GIcon* value) {
	GIcon* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = _tmp0_;
	g_object_notify ((GObject *) self, "icon");
}


GDateTime* unity_playlist_get_creation_date (UnityPlaylist* self) {
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_creation_date;
	return result;
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


void unity_playlist_set_creation_date (UnityPlaylist* self, GDateTime* value) {
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_creation_date);
	self->priv->_creation_date = _tmp0_;
	g_object_notify ((GObject *) self, "creation-date");
}


GDateTime* unity_playlist_get_modification_date (UnityPlaylist* self) {
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_modification_date;
	return result;
}


void unity_playlist_set_modification_date (UnityPlaylist* self, GDateTime* value) {
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_modification_date);
	self->priv->_modification_date = _tmp0_;
	g_object_notify ((GObject *) self, "modification-date");
}


GDateTime* unity_playlist_get_last_play_date (UnityPlaylist* self) {
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_last_play_date;
	return result;
}


void unity_playlist_set_last_play_date (UnityPlaylist* self, GDateTime* value) {
	GDateTime* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_last_play_date);
	self->priv->_last_play_date = _tmp0_;
	g_object_notify ((GObject *) self, "last-play-date");
}


static void unity_playlist_class_init (UnityPlaylistClass * klass) {
	unity_playlist_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaylistPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_playlist_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_playlist_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_playlist_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLAYLIST_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLAYLIST_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLAYLIST_ICON, g_param_spec_object ("icon", "icon", "icon", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLAYLIST_CREATION_DATE, g_param_spec_boxed ("creation-date", "creation-date", "creation-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLAYLIST_MODIFICATION_DATE, g_param_spec_boxed ("modification-date", "modification-date", "modification-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLAYLIST_LAST_PLAY_DATE, g_param_spec_boxed ("last-play-date", "last-play-date", "last-play-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_playlist_instance_init (UnityPlaylist * self) {
	self->priv = UNITY_PLAYLIST_GET_PRIVATE (self);
}


static void unity_playlist_finalize (GObject* obj) {
	UnityPlaylist * self;
	self = UNITY_PLAYLIST (obj);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_icon);
	_g_date_time_unref0 (self->priv->_creation_date);
	_g_date_time_unref0 (self->priv->_modification_date);
	_g_date_time_unref0 (self->priv->_last_play_date);
	G_OBJECT_CLASS (unity_playlist_parent_class)->finalize (obj);
}


GType unity_playlist_get_type (void) {
	static volatile gsize unity_playlist_type_id__volatile = 0;
	if (g_once_init_enter (&unity_playlist_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaylistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_playlist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaylist), 0, (GInstanceInitFunc) unity_playlist_instance_init, NULL };
		GType unity_playlist_type_id;
		unity_playlist_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaylist", &g_define_type_info, 0);
		g_once_init_leave (&unity_playlist_type_id__volatile, unity_playlist_type_id);
	}
	return unity_playlist_type_id__volatile;
}


static void _vala_unity_playlist_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaylist * self;
	self = UNITY_PLAYLIST (object);
	switch (property_id) {
		case UNITY_PLAYLIST_ID:
		g_value_set_string (value, unity_playlist_get_id (self));
		break;
		case UNITY_PLAYLIST_NAME:
		g_value_set_string (value, unity_playlist_get_name (self));
		break;
		case UNITY_PLAYLIST_ICON:
		g_value_set_object (value, unity_playlist_get_icon (self));
		break;
		case UNITY_PLAYLIST_CREATION_DATE:
		g_value_set_boxed (value, unity_playlist_get_creation_date (self));
		break;
		case UNITY_PLAYLIST_MODIFICATION_DATE:
		g_value_set_boxed (value, unity_playlist_get_modification_date (self));
		break;
		case UNITY_PLAYLIST_LAST_PLAY_DATE:
		g_value_set_boxed (value, unity_playlist_get_last_play_date (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_playlist_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaylist * self;
	self = UNITY_PLAYLIST (object);
	switch (property_id) {
		case UNITY_PLAYLIST_ID:
		unity_playlist_set_id (self, g_value_get_string (value));
		break;
		case UNITY_PLAYLIST_NAME:
		unity_playlist_set_name (self, g_value_get_string (value));
		break;
		case UNITY_PLAYLIST_ICON:
		unity_playlist_set_icon (self, g_value_get_object (value));
		break;
		case UNITY_PLAYLIST_CREATION_DATE:
		unity_playlist_set_creation_date (self, g_value_get_boxed (value));
		break;
		case UNITY_PLAYLIST_MODIFICATION_DATE:
		unity_playlist_set_modification_date (self, g_value_get_boxed (value));
		break;
		case UNITY_PLAYLIST_LAST_PLAY_DATE:
		unity_playlist_set_last_play_date (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType unity_playback_state_get_type (void) {
	static volatile gsize unity_playback_state_type_id__volatile = 0;
	if (g_once_init_enter (&unity_playback_state_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_PLAYBACK_STATE_PLAYING, "UNITY_PLAYBACK_STATE_PLAYING", "playing"}, {UNITY_PLAYBACK_STATE_PAUSED, "UNITY_PLAYBACK_STATE_PAUSED", "paused"}, {0, NULL, NULL}};
		GType unity_playback_state_type_id;
		unity_playback_state_type_id = g_enum_register_static ("UnityPlaybackState", values);
		g_once_init_leave (&unity_playback_state_type_id__volatile, unity_playback_state_type_id);
	}
	return unity_playback_state_type_id__volatile;
}


UnityMusicPlayer* unity_music_player_construct (GType object_type, const gchar* desktop) {
	UnityMusicPlayer * self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	g_return_val_if_fail (desktop != NULL, NULL);
	self = (UnityMusicPlayer*) g_object_new (object_type, "desktop-file-name", desktop, NULL);
	_tmp0_ = gee_array_list_new (UNITY_TYPE_PLAYLIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->priv->internal_playlists);
	self->priv->internal_playlists = _tmp0_;
	return self;
}


UnityMusicPlayer* unity_music_player_new (const gchar* desktop) {
	return unity_music_player_construct (UNITY_TYPE_MUSIC_PLAYER, desktop);
}


static GAppInfo* unity_music_player_create_app_info (const gchar* desktop) {
	GAppInfo* result = NULL;
	GDesktopAppInfo* _tmp0_ = NULL;
	GDesktopAppInfo* info;
	gboolean _tmp1_ = FALSE;
	GDesktopAppInfo* _tmp2_;
	GAppInfo* _tmp3_;
	GAppInfo* app_info;
	g_return_val_if_fail (desktop != NULL, NULL);
	_tmp0_ = g_desktop_app_info_new (desktop);
	info = _tmp0_;
	if (desktop == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = info == NULL;
	}
	if (_tmp1_) {
		g_warning ("unity-sound-menu.vala:100: Could not create a desktopappinfo instance " \
"from app: %s", desktop);
		result = NULL;
		_g_object_unref0 (info);
		return result;
	}
	_tmp2_ = info;
	_tmp3_ = _g_object_ref0 (G_IS_APP_INFO (_tmp2_) ? ((GAppInfo*) _tmp2_) : NULL);
	app_info = _tmp3_;
	result = app_info;
	_g_object_unref0 (info);
	return result;
}


gboolean unity_music_player_add_playlist (UnityMusicPlayer* self, UnityPlaylist* p) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _result_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	unity_mpris_gateway_ensure_playlist_interface_is_raised (self->priv->mpris_gateway);
	_tmp0_ = gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->internal_playlists, p);
	_result_ = _tmp0_;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->internal_playlists);
	unity_mpris_gateway_set_playlist_count (self->priv->mpris_gateway, _tmp1_);
	result = _result_;
	return result;
}


gboolean unity_music_player_remove_playlist (UnityMusicPlayer* self, UnityPlaylist* p) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _result_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->internal_playlists, p);
	_result_ = _tmp0_;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->internal_playlists);
	unity_mpris_gateway_set_playlist_count (self->priv->mpris_gateway, _tmp1_);
	result = _result_;
	return result;
}


UnityPlaylist** unity_music_player_get_playlists (UnityMusicPlayer* self, int* result_length1) {
	UnityPlaylist** result = NULL;
	gint _tmp0_;
	gpointer* _tmp1_ = NULL;
	UnityPlaylist** _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) self->priv->internal_playlists, &_tmp0_);
	_tmp2_ = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp0_;
	}
	result = _tmp2_;
	return result;
}


void unity_music_player_edit_playlist_name (UnityMusicPlayer* self, const gchar* id, const gchar* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (name != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _pl_list;
		gint _tmp1_;
		gint _pl_size;
		gint _pl_index;
		_tmp0_ = _g_object_ref0 (self->priv->internal_playlists);
		_pl_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _pl_list);
		_pl_size = _tmp1_;
		_pl_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			UnityPlaylist* pl;
			const gchar* _tmp3_ = NULL;
			_pl_index = _pl_index + 1;
			if (!(_pl_index < _pl_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _pl_list, _pl_index);
			pl = (UnityPlaylist*) _tmp2_;
			_tmp3_ = unity_playlist_get_id (pl);
			if (g_strcmp0 (_tmp3_, id) == 0) {
				unity_playlist_set_name (pl, name);
				unity_mpris_gateway_set_edited_playlist (self->priv->mpris_gateway, pl);
				_g_object_unref0 (pl);
				_g_object_unref0 (_pl_list);
				return;
			}
			_g_object_unref0 (pl);
		}
		_g_object_unref0 (_pl_list);
	}
}


GAppInfo* unity_music_player_get_app_info (UnityMusicPlayer* self) {
	GAppInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_app_info;
	return result;
}


static void unity_music_player_set_app_info (UnityMusicPlayer* self, GAppInfo* value) {
	GAppInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_app_info);
	self->priv->_app_info = _tmp0_;
	g_object_notify ((GObject *) self, "app-info");
}


const gchar* unity_music_player_get_desktop_file_name (UnityMusicPlayer* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_desktop_file_name;
	return result;
}


static void unity_music_player_set_desktop_file_name (UnityMusicPlayer* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_desktop_file_name);
	self->priv->_desktop_file_name = _tmp0_;
	g_object_notify ((GObject *) self, "desktop-file-name");
}


gboolean unity_music_player_get_is_blacklisted (UnityMusicPlayer* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_blacklisted;
	return result;
}


void unity_music_player_set_is_blacklisted (UnityMusicPlayer* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_blacklisted = value;
	g_object_notify ((GObject *) self, "is-blacklisted");
}


const gchar* unity_music_player_get_title (UnityMusicPlayer* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_title;
	return result;
}


void unity_music_player_set_title (UnityMusicPlayer* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp0_;
	g_object_notify ((GObject *) self, "title");
}


gboolean unity_music_player_get_can_go_next (UnityMusicPlayer* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_go_next;
	return result;
}


void unity_music_player_set_can_go_next (UnityMusicPlayer* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_can_go_next = value;
	g_object_notify ((GObject *) self, "can-go-next");
}


gboolean unity_music_player_get_can_go_previous (UnityMusicPlayer* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_go_previous;
	return result;
}


void unity_music_player_set_can_go_previous (UnityMusicPlayer* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_can_go_previous = value;
	g_object_notify ((GObject *) self, "can-go-previous");
}


gboolean unity_music_player_get_can_play (UnityMusicPlayer* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_play;
	return result;
}


void unity_music_player_set_can_play (UnityMusicPlayer* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_can_play = value;
	g_object_notify ((GObject *) self, "can-play");
}


gboolean unity_music_player_get_can_pause (UnityMusicPlayer* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_pause;
	return result;
}


void unity_music_player_set_can_pause (UnityMusicPlayer* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_can_pause = value;
	g_object_notify ((GObject *) self, "can-pause");
}


UnityTrackMetadata* unity_music_player_get_current_track (UnityMusicPlayer* self) {
	UnityTrackMetadata* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_current_track;
	return result;
}


void unity_music_player_set_current_track (UnityMusicPlayer* self, UnityTrackMetadata* value) {
	UnityTrackMetadata* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_current_track);
	self->priv->_current_track = _tmp0_;
	g_object_notify ((GObject *) self, "current-track");
}


UnityPlaybackState unity_music_player_get_playback_state (UnityMusicPlayer* self) {
	UnityPlaybackState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_playback_state;
	return result;
}


void unity_music_player_set_playback_state (UnityMusicPlayer* self, UnityPlaybackState value) {
	g_return_if_fail (self != NULL);
	self->priv->_playback_state = value;
	g_object_notify ((GObject *) self, "playback-state");
}


UnityPlaylist* unity_music_player_get_current_playlist (UnityMusicPlayer* self) {
	UnityPlaylist* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_current_playlist;
	return result;
}


void unity_music_player_set_current_playlist (UnityMusicPlayer* self, UnityPlaylist* value) {
	UnityPlaylist* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_current_playlist);
	self->priv->_current_playlist = _tmp0_;
	g_object_notify ((GObject *) self, "current-playlist");
}


DbusmenuMenuitem* unity_music_player_get_track_menu (UnityMusicPlayer* self) {
	DbusmenuMenuitem* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_track_menu;
	return result;
}


void unity_music_player_set_track_menu (UnityMusicPlayer* self, DbusmenuMenuitem* value) {
	DbusmenuMenuitem* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_track_menu);
	self->priv->_track_menu = _tmp0_;
	g_object_notify ((GObject *) self, "track-menu");
}


DbusmenuMenuitem* unity_music_player_get_player_menu (UnityMusicPlayer* self) {
	DbusmenuMenuitem* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_player_menu;
	return result;
}


void unity_music_player_set_player_menu (UnityMusicPlayer* self, DbusmenuMenuitem* value) {
	DbusmenuMenuitem* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_player_menu);
	self->priv->_player_menu = _tmp0_;
	g_object_notify ((GObject *) self, "player-menu");
}


static GObject * unity_music_player_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityMusicPlayer * self;
	GAppInfo* _tmp0_ = NULL;
	GAppInfo* a_info;
	const gchar* _tmp1_ = NULL;
	UnityMPRISGateway* _tmp2_ = NULL;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_music_player_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_MUSIC_PLAYER (obj);
	_tmp0_ = unity_music_player_create_app_info (self->priv->_desktop_file_name);
	a_info = _tmp0_;
	if (a_info == NULL) {
		g_critical ("unity-sound-menu.vala:78: Cannot locate the Desktop file ");
		_g_object_unref0 (a_info);
		return obj;
	}
	unity_music_player_set_app_info (self, a_info);
	_tmp1_ = g_app_info_get_name (self->priv->_app_info);
	unity_music_player_set_title (self, _tmp1_);
	_tmp2_ = unity_mpris_gateway_new (self);
	_g_object_unref0 (self->priv->mpris_gateway);
	self->priv->mpris_gateway = _tmp2_;
	goto __finally32;
	__catch32_g_io_error:
	{
		GError * e;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_app_info_get_name (self->priv->_app_info);
		g_critical ("unity-sound-menu.vala:88: Could not create the MPRISGateway for %s\n", _tmp3_);
		_g_error_free0 (e);
		_g_object_unref0 (a_info);
		return obj;
	}
	__finally32:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (a_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp4_ = g_app_info_get_name (self->priv->_app_info);
	unity_music_player_set_title (self, _tmp4_);
	unity_music_player_set_playback_state (self, UNITY_PLAYBACK_STATE_PAUSED);
	_g_object_unref0 (a_info);
	return obj;
}


static void unity_music_player_class_init (UnityMusicPlayerClass * klass) {
	unity_music_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityMusicPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_music_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_music_player_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_music_player_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_music_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_APP_INFO, g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_APP_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_DESKTOP_FILE_NAME, g_param_spec_string ("desktop-file-name", "desktop-file-name", "desktop-file-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_IS_BLACKLISTED, g_param_spec_boolean ("is-blacklisted", "is-blacklisted", "is-blacklisted", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_CAN_GO_NEXT, g_param_spec_boolean ("can-go-next", "can-go-next", "can-go-next", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_CAN_GO_PREVIOUS, g_param_spec_boolean ("can-go-previous", "can-go-previous", "can-go-previous", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_CAN_PLAY, g_param_spec_boolean ("can-play", "can-play", "can-play", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_CAN_PAUSE, g_param_spec_boolean ("can-pause", "can-pause", "can-pause", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_CURRENT_TRACK, g_param_spec_object ("current-track", "current-track", "current-track", UNITY_TYPE_TRACK_METADATA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_PLAYBACK_STATE, g_param_spec_enum ("playback-state", "playback-state", "playback-state", UNITY_TYPE_PLAYBACK_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_CURRENT_PLAYLIST, g_param_spec_object ("current-playlist", "current-playlist", "current-playlist", UNITY_TYPE_PLAYLIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_TRACK_MENU, g_param_spec_object ("track-menu", "track-menu", "track-menu", dbusmenu_menuitem_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MUSIC_PLAYER_PLAYER_MENU, g_param_spec_object ("player-menu", "player-menu", "player-menu", dbusmenu_menuitem_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("raise", UNITY_TYPE_MUSIC_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("play_pause", UNITY_TYPE_MUSIC_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("previous", UNITY_TYPE_MUSIC_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("next", UNITY_TYPE_MUSIC_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("activate_playlist", UNITY_TYPE_MUSIC_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void unity_music_player_instance_init (UnityMusicPlayer * self) {
	self->priv = UNITY_MUSIC_PLAYER_GET_PRIVATE (self);
}


static void unity_music_player_finalize (GObject* obj) {
	UnityMusicPlayer * self;
	self = UNITY_MUSIC_PLAYER (obj);
	_g_object_unref0 (self->priv->mpris_gateway);
	_g_object_unref0 (self->priv->internal_playlists);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_desktop_file_name);
	_g_free0 (self->priv->_title);
	_g_object_unref0 (self->priv->_current_track);
	_g_object_unref0 (self->priv->_current_playlist);
	_g_object_unref0 (self->priv->_track_menu);
	_g_object_unref0 (self->priv->_player_menu);
	G_OBJECT_CLASS (unity_music_player_parent_class)->finalize (obj);
}


GType unity_music_player_get_type (void) {
	static volatile gsize unity_music_player_type_id__volatile = 0;
	if (g_once_init_enter (&unity_music_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMusicPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_music_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMusicPlayer), 0, (GInstanceInitFunc) unity_music_player_instance_init, NULL };
		GType unity_music_player_type_id;
		unity_music_player_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityMusicPlayer", &g_define_type_info, 0);
		g_once_init_leave (&unity_music_player_type_id__volatile, unity_music_player_type_id);
	}
	return unity_music_player_type_id__volatile;
}


static void _vala_unity_music_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityMusicPlayer * self;
	self = UNITY_MUSIC_PLAYER (object);
	switch (property_id) {
		case UNITY_MUSIC_PLAYER_APP_INFO:
		g_value_set_object (value, unity_music_player_get_app_info (self));
		break;
		case UNITY_MUSIC_PLAYER_DESKTOP_FILE_NAME:
		g_value_set_string (value, unity_music_player_get_desktop_file_name (self));
		break;
		case UNITY_MUSIC_PLAYER_IS_BLACKLISTED:
		g_value_set_boolean (value, unity_music_player_get_is_blacklisted (self));
		break;
		case UNITY_MUSIC_PLAYER_TITLE:
		g_value_set_string (value, unity_music_player_get_title (self));
		break;
		case UNITY_MUSIC_PLAYER_CAN_GO_NEXT:
		g_value_set_boolean (value, unity_music_player_get_can_go_next (self));
		break;
		case UNITY_MUSIC_PLAYER_CAN_GO_PREVIOUS:
		g_value_set_boolean (value, unity_music_player_get_can_go_previous (self));
		break;
		case UNITY_MUSIC_PLAYER_CAN_PLAY:
		g_value_set_boolean (value, unity_music_player_get_can_play (self));
		break;
		case UNITY_MUSIC_PLAYER_CAN_PAUSE:
		g_value_set_boolean (value, unity_music_player_get_can_pause (self));
		break;
		case UNITY_MUSIC_PLAYER_CURRENT_TRACK:
		g_value_set_object (value, unity_music_player_get_current_track (self));
		break;
		case UNITY_MUSIC_PLAYER_PLAYBACK_STATE:
		g_value_set_enum (value, unity_music_player_get_playback_state (self));
		break;
		case UNITY_MUSIC_PLAYER_CURRENT_PLAYLIST:
		g_value_set_object (value, unity_music_player_get_current_playlist (self));
		break;
		case UNITY_MUSIC_PLAYER_TRACK_MENU:
		g_value_set_object (value, unity_music_player_get_track_menu (self));
		break;
		case UNITY_MUSIC_PLAYER_PLAYER_MENU:
		g_value_set_object (value, unity_music_player_get_player_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_music_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityMusicPlayer * self;
	self = UNITY_MUSIC_PLAYER (object);
	switch (property_id) {
		case UNITY_MUSIC_PLAYER_APP_INFO:
		unity_music_player_set_app_info (self, g_value_get_object (value));
		break;
		case UNITY_MUSIC_PLAYER_DESKTOP_FILE_NAME:
		unity_music_player_set_desktop_file_name (self, g_value_get_string (value));
		break;
		case UNITY_MUSIC_PLAYER_IS_BLACKLISTED:
		unity_music_player_set_is_blacklisted (self, g_value_get_boolean (value));
		break;
		case UNITY_MUSIC_PLAYER_TITLE:
		unity_music_player_set_title (self, g_value_get_string (value));
		break;
		case UNITY_MUSIC_PLAYER_CAN_GO_NEXT:
		unity_music_player_set_can_go_next (self, g_value_get_boolean (value));
		break;
		case UNITY_MUSIC_PLAYER_CAN_GO_PREVIOUS:
		unity_music_player_set_can_go_previous (self, g_value_get_boolean (value));
		break;
		case UNITY_MUSIC_PLAYER_CAN_PLAY:
		unity_music_player_set_can_play (self, g_value_get_boolean (value));
		break;
		case UNITY_MUSIC_PLAYER_CAN_PAUSE:
		unity_music_player_set_can_pause (self, g_value_get_boolean (value));
		break;
		case UNITY_MUSIC_PLAYER_CURRENT_TRACK:
		unity_music_player_set_current_track (self, g_value_get_object (value));
		break;
		case UNITY_MUSIC_PLAYER_PLAYBACK_STATE:
		unity_music_player_set_playback_state (self, g_value_get_enum (value));
		break;
		case UNITY_MUSIC_PLAYER_CURRENT_PLAYLIST:
		unity_music_player_set_current_playlist (self, g_value_get_object (value));
		break;
		case UNITY_MUSIC_PLAYER_TRACK_MENU:
		unity_music_player_set_track_menu (self, g_value_get_object (value));
		break;
		case UNITY_MUSIC_PLAYER_PLAYER_MENU:
		unity_music_player_set_player_menu (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



