/*
 * Copyright (C) 2009 Splitted-Desktop Systems. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef VA_COMPAT_H
#define VA_COMPAT_H

VAStatus va_compat_init(VADisplay dpy, int compat_version, void *compat_ctx);
VAStatus va_compat_fini(VADisplay dpy);

/* H.264 Picture (0.29) */
typedef struct _VAPictureH264_0_29
{
    VASurfaceID picture_id;
    unsigned int flags;
    unsigned int TopFieldOrderCnt;
    unsigned int BottomFieldOrderCnt;
} VAPictureH264_0_29;

/* H.264 Picture Parameter Buffer (0.29) */
typedef struct _VAPictureParameterBufferH264_0_29
{
    VAPictureH264_0_29 CurrPic;
    VAPictureH264_0_29 ReferenceFrames[16];	/* in DPB */
    unsigned short picture_width_in_mbs_minus1;
    unsigned short picture_height_in_mbs_minus1;
    unsigned char bit_depth_luma_minus8;
    unsigned char bit_depth_chroma_minus8;
    unsigned char num_ref_frames;
    union {
        struct {
            unsigned char chroma_format_idc			: 2; 
            unsigned char residual_colour_transform_flag	: 1; 
            unsigned char frame_mbs_only_flag			: 1; 
            unsigned char mb_adaptive_frame_field_flag		: 1; 
            unsigned char direct_8x8_inference_flag		: 1; 
            unsigned char MinLumaBiPredSize8x8			: 1; /* see A.3.3.2 */
        };
        unsigned char seq_fields;
    };
    unsigned char num_slice_groups_minus1;
    unsigned char slice_group_map_type;
    signed char pic_init_qp_minus26;
    signed char chroma_qp_index_offset;
    signed char second_chroma_qp_index_offset;
    union {
        struct {
            unsigned char entropy_coding_mode_flag		: 1;
            unsigned char weighted_pred_flag			: 1;
            unsigned char weighted_bipred_idc			: 2;
            unsigned char transform_8x8_mode_flag		: 1;
            unsigned char field_pic_flag			: 1;
            unsigned char constrained_intra_pred_flag		: 1;
        };
        unsigned char pic_fields;
    };
    unsigned short frame_num;
} VAPictureParameterBufferH264_0_29;

/* H.264 Slice Parameter Buffer (0.29) */
typedef struct _VASliceParameterBufferH264_0_29
{
    unsigned int slice_data_size;/* number of bytes in the slice data buffer for this slice */
    unsigned int slice_data_offset;/* the offset to the NAL start code for this slice */
    unsigned int slice_data_flag; /* see VA_SLICE_DATA_FLAG_XXX defintions */
    unsigned short slice_data_bit_offset; /* bit offset from NAL start code to the beginning of slice data */
    unsigned short first_mb_in_slice;
    unsigned char slice_type;
    unsigned char direct_spatial_mv_pred_flag;
    unsigned char num_ref_idx_l0_active_minus1;
    unsigned char num_ref_idx_l1_active_minus1;
    unsigned char cabac_init_idc;
    char slice_qp_delta;
    unsigned char disable_deblocking_filter_idc;
    char slice_alpha_c0_offset_div2;
    char slice_beta_offset_div2;
    VAPictureH264_0_29 RefPicList0[32];	/* See 8.2.4.2 */
    VAPictureH264_0_29 RefPicList1[32];	/* See 8.2.4.2 */
    unsigned char luma_log2_weight_denom;
    unsigned char chroma_log2_weight_denom;
    unsigned char luma_weight_l0_flag;
    short luma_weight_l0[32];
    short luma_offset_l0[32];
    unsigned char chroma_weight_l0_flag;
    short chroma_weight_l0[32][2];
    short chroma_offset_l0[32][2];
    unsigned char luma_weight_l1_flag;
    short luma_weight_l1[32];
    short luma_offset_l1[32];
    unsigned char chroma_weight_l1_flag;
    short chroma_weight_l1[32][2];
    short chroma_offset_l1[32][2];
} VASliceParameterBufferH264_0_29;

/* VC-1 Picture Parameter Buffer (0.29) */
typedef struct _VAPictureParameterBufferVC1_0_29
{
    VASurfaceID forward_reference_picture;
    VASurfaceID backward_reference_picture;
    /* if out-of-loop post-processing is done on the render
       target, then we need to keep the in-loop decoded 
       picture as a reference picture */
    VASurfaceID inloop_decoded_picture;

    /* sequence layer for AP or meta data for SP and MP */
    union {
        struct {
            unsigned char interlace	: 1; /* SEQUENCE_LAYER::INTERLACE */
            unsigned char syncmarker	: 1;/* METADATA::SYNCMARKER */
            unsigned char overlap	: 1;/* METADATA::OVERLAP */
        };
        unsigned char sequence_fields;
    };

    unsigned short coded_width;		/* ENTRY_POINT_LAYER::CODED_WIDTH */
    unsigned short coded_height;	/* ENTRY_POINT_LAYER::CODED_HEIGHT */
    unsigned char closed_entry;		/* ENTRY_POINT_LAYER::CLOSED_ENTRY */
    unsigned char broken_link;		/* ENTRY_POINT_LAYER::BROKEN_LINK */
    unsigned char loopfilter;		/* ENTRY_POINT_LAYER::LOOPFILTER */
    unsigned char conditional_overlap_flag; /* ENTRY_POINT_LAYER::CONDOVER */
    unsigned char fast_uvmc_flag;	/* ENTRY_POINT_LAYER::FASTUVMC */
    union {
        struct {
            unsigned char range_mapping_luma_flag: 	1; /* ENTRY_POINT_LAYER::RANGE_MAPY_FLAG */
            unsigned char range_mapping_luma: 		3; /* ENTRY_POINT_LAYER::RANGE_MAPY */
            unsigned char range_mapping_chroma_flag:	1; /* ENTRY_POINT_LAYER::RANGE_MAPUV_FLAG */
            unsigned char range_mapping_chroma:		3; /* ENTRY_POINT_LAYER::RANGE_MAPUV */
        };
        unsigned char range_mapping_fields;
    };

    unsigned char b_picture_fraction;	/* PICTURE_LAYER::BFRACTION */
    unsigned char cbp_table;		/* PICTURE_LAYER::CBPTAB/ICBPTAB */
    unsigned char mb_mode_table;	/* PICTURE_LAYER::MBMODETAB */
    unsigned char range_reduction_frame;/* PICTURE_LAYER::RANGEREDFRM */
    unsigned char rounding_control;	/* PICTURE_LAYER::RNDCTRL */
    unsigned char post_processing;	/* PICTURE_LAYER::POSTPROC */
    unsigned char picture_resolution_index;	/* PICTURE_LAYER::RESPIC */
    unsigned char luma_scale;		/* PICTURE_LAYER::LUMSCALE */
    unsigned char luma_shift;		/* PICTURE_LAYER::LUMSHIFT */
    union {
        struct {
            unsigned char picture_type	: 2; 	/* PICTURE_LAYER::PTYPE */
            unsigned char frame_coding_mode	: 3;/* PICTURE_LAYER::FCM */
            unsigned char top_field_first	: 1;/* PICTURE_LAYER::TFF */
            unsigned char is_first_field	: 1; /* set to 1 if it is the first field */
            unsigned char intensity_compensation: 1;/* PICTURE_LAYER::INTCOMP */
        };
        unsigned char picture_fields;
    };
    union {
        struct {
            unsigned char mv_type_mb	: 1; 	/* PICTURE::MVTYPEMB */
            unsigned char direct_mb	: 1; 	/* PICTURE::DIRECTMB */
            unsigned char skip_mb	: 1; 	/* PICTURE::SKIPMB */
            unsigned char field_tx	: 1; 	/* PICTURE::FIELDTX */
            unsigned char forward_mb	: 1;	/* PICTURE::FORWARDMB */
            unsigned char ac_pred	: 1;	/* PICTURE::ACPRED */
            unsigned char overflags	: 1;	/* PICTURE::OVERFLAGS */
        };
        unsigned char raw_coding_flag;
    };
    union {
        struct {
            unsigned char bp_mv_type_mb   : 1;    /* PICTURE::MVTYPEMB */
            unsigned char bp_direct_mb    : 1;    /* PICTURE::DIRECTMB */
            unsigned char bp_skip_mb      : 1;    /* PICTURE::SKIPMB */  
            unsigned char bp_field_tx     : 1;    /* PICTURE::FIELDTX */ 
            unsigned char bp_forward_mb   : 1;    /* PICTURE::FORWARDMB */
            unsigned char bp_ac_pred      : 1;    /* PICTURE::ACPRED */   
            unsigned char bp_overflags    : 1;    /* PICTURE::OVERFLAGS */
        };
        unsigned char bitplane_present_flag; /* signal what bitplane is being passed via the bitplane buffer */
    };
    union {
        struct {
            unsigned char reference_distance_flag : 1;/* PICTURE_LAYER::REFDIST_FLAG */
            unsigned char reference_distance	: 5;/* PICTURE_LAYER::REFDIST */
            unsigned char num_reference_pictures: 1;/* PICTURE_LAYER::NUMREF */
            unsigned char reference_field_pic_indicator	: 1;/* PICTURE_LAYER::REFFIELD */
        };
        unsigned short reference_fields;
    };
    union {
        struct {
            VAMvModeVC1 mv_mode              : 3; /* PICTURE_LAYER::MVMODE */
            VAMvModeVC1 mv_mode2             : 3; /* PICTURE_LAYER::MVMODE2 */
            unsigned char mv_table           : 3; /* PICTURE_LAYER::MVTAB/IMVTAB */
            unsigned char two_mv_block_pattern_table: 2; /* PICTURE_LAYER::2MVBPTAB */
            unsigned char four_mv_switch     : 1; /* PICTURE_LAYER::4MVSWITCH */
            unsigned char four_mv_block_pattern_table : 2; /* PICTURE_LAYER::4MVBPTAB */
            unsigned char extended_mv_flag   : 1; /* ENTRY_POINT_LAYER::EXTENDED_MV */
            unsigned char extended_mv_range  : 2; /* PICTURE_LAYER::MVRANGE */
            unsigned char extended_dmv_flag  : 1; /* ENTRY_POINT_LAYER::EXTENDED_DMV */
            unsigned char extended_dmv_range : 2; /* PICTURE_LAYER::DMVRANGE */
        };
        unsigned int mv_fields;
    };
    union {
        struct {
            unsigned char dquant	: 2; 	/* ENTRY_POINT_LAYER::DQUANT */
            unsigned char quantizer     : 2; 	/* ENTRY_POINT_LAYER::QUANTIZER */
            unsigned char half_qp	: 1; 	/* PICTURE_LAYER::HALFQP */
            unsigned char pic_quantizer_scale : 5;/* PICTURE_LAYER::PQUANT */
            unsigned char pic_quantizer_type : 1;/* PICTURE_LAYER::PQUANTIZER */
            unsigned char dq_frame	: 1; 	/* VOPDQUANT::DQUANTFRM */
            unsigned char dq_profile	: 2; 	/* VOPDQUANT::DQPROFILE */
            unsigned char dq_sb_edge	: 2; 	/* VOPDQUANT::DQSBEDGE */
            unsigned char dq_db_edge 	: 2; 	/* VOPDQUANT::DQDBEDGE */
            unsigned char dq_binary_level : 1; 	/* VOPDQUANT::DQBILEVEL */
            unsigned char alt_pic_quantizer : 5;/* VOPDQUANT::ALTPQUANT */
        };
        unsigned long pic_quantizer_fields;
    };
    union {
        struct {
            unsigned char variable_sized_transform_flag	: 1;/* ENTRY_POINT_LAYER::VSTRANSFORM */
            unsigned char mb_level_transform_type_flag	: 1;/* PICTURE_LAYER::TTMBF */
            unsigned char frame_level_transform_type	: 2;/* PICTURE_LAYER::TTFRM */
            unsigned char transform_ac_codingset_idx1	: 2;/* PICTURE_LAYER::TRANSACFRM */
            unsigned char transform_ac_codingset_idx2	: 2;/* PICTURE_LAYER::TRANSACFRM2 */
            unsigned char intra_transform_dc_table	: 1;/* PICTURE_LAYER::TRANSDCTAB */
        };
        unsigned short transform_fields;
    };
} VAPictureParameterBufferVC1_0_29;

/* MPEG-2 Picture Parameter Buffer (0.29) */
typedef struct _VAPictureParameterBufferMPEG2_0_29
{
    unsigned short horizontal_size;
    unsigned short vertical_size;
    VASurfaceID forward_reference_picture;
    VASurfaceID backward_reference_picture;
    /* meanings of the following fields are the same as in the standard */
    int picture_coding_type;
    int f_code; /* pack all four fcode into this */
    union {
        struct {
            unsigned char intra_dc_precision		: 2; 
            unsigned char picture_structure		: 2; 
            unsigned char top_field_first		: 1; 
            unsigned char frame_pred_frame_dct		: 1; 
            unsigned char concealment_motion_vectors	: 1;
            unsigned char q_scale_type			: 1;
            unsigned char intra_vlc_format		: 1;
            unsigned char alternate_scan		: 1;
            unsigned char repeat_first_field		: 1;
            unsigned char progressive_frame		: 1;
            unsigned char is_first_field		: 1; /* indicate whether the current field
                                                              * is the first field for field picture
                                                              */
        };
        unsigned int picture_coding_extension;
    };
} VAPictureParameterBufferMPEG2_0_29;

/* MPEG-2 Slice Parameter Buffer (0.29) */
typedef struct _VASliceParameterBufferMPEG2_0_29
{
    unsigned int slice_data_size;/* number of bytes in the slice data buffer for this slice */
    unsigned int slice_data_offset;/* the offset to the first byte of slice data */
    unsigned int slice_data_flag; /* see VA_SLICE_DATA_FLAG_XXX defintions */
    unsigned int macroblock_offset;/* the offset to the first bit of MB from the first byte of slice data */
    unsigned int slice_vertical_position;
    int quantiser_scale_code;
    int intra_slice_flag;
} VASliceParameterBufferMPEG2_0_29;

/* MPEG-4 Picture Parameter Buffer (0.29) */
typedef struct _VAPictureParameterBufferMPEG4_0_29
{
    unsigned short vop_width;
    unsigned short vop_height;
    VASurfaceID forward_reference_picture;
    VASurfaceID backward_reference_picture;
    union {
        struct {
            unsigned char short_video_header		: 1; 
            unsigned char chroma_format			: 2; 
            unsigned char interlaced			: 1; 
            unsigned char obmc_disable			: 1; 
            unsigned char sprite_enable			: 2; 
            unsigned char sprite_warping_accuracy	: 2; 
            unsigned char quant_type			: 1; 
            unsigned char quarter_sample		: 1; 
            unsigned char data_partitioned		: 1; 
            unsigned char reversible_vlc		: 1; 
        };
        unsigned short vol_fields;
    };
    unsigned char no_of_sprite_warping_points;
    short sprite_trajectory_du[3];
    short sprite_trajectory_dv[3];
    unsigned char quant_precision;
    union {
        struct {
            unsigned char vop_coding_type		: 2; 
            unsigned char backward_reference_vop_coding_type	: 2; 
            unsigned char vop_rounding_type		: 1; 
            unsigned char intra_dc_vlc_thr		: 3; 
            unsigned char top_field_first		: 1; 
            unsigned char alternate_vertical_scan_flag	: 1; 
        };
        unsigned short vop_fields;
    };
    unsigned char vop_fcode_forward;
    unsigned char vop_fcode_backward;
    /* short header related */
    unsigned char num_gobs_in_vop;
    unsigned char num_macroblocks_in_gob;
    /* for direct mode prediction */
    short TRB;
    short TRD;
} VAPictureParameterBufferMPEG4_0_29;

/* H.264 Picture (0.30) */
typedef struct _VAPictureH264_0_30
{
    VASurfaceID picture_id;
    unsigned int flags;
    unsigned int TopFieldOrderCnt;
    unsigned int BottomFieldOrderCnt;
} VAPictureH264_0_30;

/* H.264 Picture Parameter Buffer (0.30) */
typedef struct _VAPictureParameterBufferH264_0_30
{
    VAPictureH264 CurrPic;
    VAPictureH264 ReferenceFrames[16];	/* in DPB */
    unsigned short picture_width_in_mbs_minus1;
    unsigned short picture_height_in_mbs_minus1;
    unsigned char bit_depth_luma_minus8;
    unsigned char bit_depth_chroma_minus8;
    unsigned char num_ref_frames;
    union {
        struct {
            unsigned char chroma_format_idc			: 2; 
            unsigned char residual_colour_transform_flag		: 1; 
            unsigned char frame_mbs_only_flag			: 1; 
            unsigned char mb_adaptive_frame_field_flag		: 1; 
            unsigned char direct_8x8_inference_flag		: 1; 
            unsigned char MinLumaBiPredSize8x8			: 1; /* see A.3.3.2 */
        } bits;
        unsigned char value;
    } seq_fields;
    unsigned char num_slice_groups_minus1;
    unsigned char slice_group_map_type;
    signed char pic_init_qp_minus26;
    signed char chroma_qp_index_offset;
    signed char second_chroma_qp_index_offset;
    union {
        struct {
            unsigned char entropy_coding_mode_flag	: 1;
            unsigned char weighted_pred_flag		: 1;
            unsigned char weighted_bipred_idc		: 2;
            unsigned char transform_8x8_mode_flag	: 1;
            unsigned char field_pic_flag			: 1;
            unsigned char constrained_intra_pred_flag	: 1;
        } bits;
        unsigned char value;
    } pic_fields;
    unsigned short frame_num;
} VAPictureParameterBufferH264_0_30;

/* H.264 Slice Parameter Buffer (0.30) */
typedef struct _VASliceParameterBufferH264_0_30
{
    unsigned int slice_data_size;/* number of bytes in the slice data buffer for this slice */
    unsigned int slice_data_offset;/* the offset to the NAL start code for this slice */
    unsigned int slice_data_flag; /* see VA_SLICE_DATA_FLAG_XXX defintions */
    unsigned short slice_data_bit_offset; /* bit offset from NAL start code to the beginning of slice data */
    unsigned short first_mb_in_slice;
    unsigned char slice_type;
    unsigned char direct_spatial_mv_pred_flag;
    unsigned char num_ref_idx_l0_active_minus1;
    unsigned char num_ref_idx_l1_active_minus1;
    unsigned char cabac_init_idc;
    char slice_qp_delta;
    unsigned char disable_deblocking_filter_idc;
    char slice_alpha_c0_offset_div2;
    char slice_beta_offset_div2;
    VAPictureH264 RefPicList0[32];	/* See 8.2.4.2 */
    VAPictureH264 RefPicList1[32];	/* See 8.2.4.2 */
    unsigned char luma_log2_weight_denom;
    unsigned char chroma_log2_weight_denom;
    unsigned char luma_weight_l0_flag;
    short luma_weight_l0[32];
    short luma_offset_l0[32];
    unsigned char chroma_weight_l0_flag;
    short chroma_weight_l0[32][2];
    short chroma_offset_l0[32][2];
    unsigned char luma_weight_l1_flag;
    short luma_weight_l1[32];
    short luma_offset_l1[32];
    unsigned char chroma_weight_l1_flag;
    short chroma_weight_l1[32][2];
    short chroma_offset_l1[32][2];
} VASliceParameterBufferH264_0_30;

/* VC-1 Picture Parameter Buffer (0.30) */
typedef struct _VAPictureParameterBufferVC1_0_30
{
    VASurfaceID forward_reference_picture;
    VASurfaceID backward_reference_picture;
    /* if out-of-loop post-processing is done on the render
       target, then we need to keep the in-loop decoded 
       picture as a reference picture */
    VASurfaceID inloop_decoded_picture;

    /* sequence layer for AP or meta data for SP and MP */
    union {
        struct {
            unsigned char interlace	: 1; /* SEQUENCE_LAYER::INTERLACE */
            unsigned char syncmarker	: 1;/* METADATA::SYNCMARKER */
            unsigned char overlap	: 1;/* METADATA::OVERLAP */
        } bits;
        unsigned char value;
    } sequence_fields;

    unsigned short coded_width;		/* ENTRY_POINT_LAYER::CODED_WIDTH */
    unsigned short coded_height;	/* ENTRY_POINT_LAYER::CODED_HEIGHT */
    unsigned char closed_entry;		/* ENTRY_POINT_LAYER::CLOSED_ENTRY */
    unsigned char broken_link;		/* ENTRY_POINT_LAYER::BROKEN_LINK */
    unsigned char loopfilter;		/* ENTRY_POINT_LAYER::LOOPFILTER */
    unsigned char conditional_overlap_flag; /* ENTRY_POINT_LAYER::CONDOVER */
    unsigned char fast_uvmc_flag;	/* ENTRY_POINT_LAYER::FASTUVMC */
    union {
        struct {
            unsigned char luma_flag	: 1; /* ENTRY_POINT_LAYER::RANGE_MAPY_FLAG */
            unsigned char luma		: 3; /* ENTRY_POINT_LAYER::RANGE_MAPY */
            unsigned char chroma_flag	: 1; /* ENTRY_POINT_LAYER::RANGE_MAPUV_FLAG */
            unsigned char chroma		: 3; /* ENTRY_POINT_LAYER::RANGE_MAPUV */
        } bits;
        unsigned char value;
    } range_mapping_fields;

    unsigned char b_picture_fraction;	/* PICTURE_LAYER::BFRACTION */
    unsigned char cbp_table;		/* PICTURE_LAYER::CBPTAB/ICBPTAB */
    unsigned char mb_mode_table;	/* PICTURE_LAYER::MBMODETAB */
    unsigned char range_reduction_frame;/* PICTURE_LAYER::RANGEREDFRM */
    unsigned char rounding_control;	/* PICTURE_LAYER::RNDCTRL */
    unsigned char post_processing;	/* PICTURE_LAYER::POSTPROC */
    unsigned char picture_resolution_index;	/* PICTURE_LAYER::RESPIC */
    unsigned char luma_scale;		/* PICTURE_LAYER::LUMSCALE */
    unsigned char luma_shift;		/* PICTURE_LAYER::LUMSHIFT */
    union {
        struct {
            unsigned char picture_type		: 2; /* PICTURE_LAYER::PTYPE */
            unsigned char frame_coding_mode	: 3; /* PICTURE_LAYER::FCM */
            unsigned char top_field_first	: 1; /* PICTURE_LAYER::TFF */
            unsigned char is_first_field		: 1; /* set to 1 if it is the first field */
            unsigned char intensity_compensation	: 1; /* PICTURE_LAYER::INTCOMP */
        } bits;
        unsigned char value;
    } picture_fields;
    union {
        struct {
            unsigned char mv_type_mb	: 1; 	/* PICTURE::MVTYPEMB */
            unsigned char direct_mb	: 1; 	/* PICTURE::DIRECTMB */
            unsigned char skip_mb	: 1; 	/* PICTURE::SKIPMB */
            unsigned char field_tx	: 1; 	/* PICTURE::FIELDTX */
            unsigned char forward_mb	: 1;	/* PICTURE::FORWARDMB */
            unsigned char ac_pred	: 1;	/* PICTURE::ACPRED */
            unsigned char overflags	: 1;	/* PICTURE::OVERFLAGS */
        } flags;
        unsigned char value;
    } raw_coding;
    union {
        struct {
            unsigned char bp_mv_type_mb   : 1;    /* PICTURE::MVTYPEMB */
            unsigned char bp_direct_mb    : 1;    /* PICTURE::DIRECTMB */
            unsigned char bp_skip_mb      : 1;    /* PICTURE::SKIPMB */  
            unsigned char bp_field_tx     : 1;    /* PICTURE::FIELDTX */ 
            unsigned char bp_forward_mb   : 1;    /* PICTURE::FORWARDMB */
            unsigned char bp_ac_pred      : 1;    /* PICTURE::ACPRED */   
            unsigned char bp_overflags    : 1;    /* PICTURE::OVERFLAGS */
        } flags;
        unsigned char value;
    } bitplane_present; /* signal what bitplane is being passed via the bitplane buffer */
    union {
        struct {
            unsigned char reference_distance_flag : 1;/* PICTURE_LAYER::REFDIST_FLAG */
            unsigned char reference_distance	: 5;/* PICTURE_LAYER::REFDIST */
            unsigned char num_reference_pictures: 1;/* PICTURE_LAYER::NUMREF */
            unsigned char reference_field_pic_indicator	: 1;/* PICTURE_LAYER::REFFIELD */
        } bits;
        unsigned short value;
    } reference_fields;
    union {
        struct {
            unsigned char mv_mode		: 3; /* PICTURE_LAYER::MVMODE */
            unsigned char mv_mode2		: 3; /* PICTURE_LAYER::MVMODE2 */
            unsigned char mv_table		: 3; /* PICTURE_LAYER::MVTAB/IMVTAB */
            unsigned char two_mv_block_pattern_table: 2; /* PICTURE_LAYER::2MVBPTAB */
            unsigned char four_mv_switch		: 1; /* PICTURE_LAYER::4MVSWITCH */
            unsigned char four_mv_block_pattern_table : 2; /* PICTURE_LAYER::4MVBPTAB */
            unsigned char extended_mv_flag	: 1; /* ENTRY_POINT_LAYER::EXTENDED_MV */
            unsigned char extended_mv_range	: 2; /* PICTURE_LAYER::MVRANGE */
            unsigned char extended_dmv_flag	: 1; /* ENTRY_POCHAR_LAYER::EXTENDED_DMV */
            unsigned char extended_dmv_range	: 2; /* PICTURE_LAYER::DMVRANGE */
        } bits;
        unsigned int value;
    } mv_fields;
    union {
        struct {
            unsigned char dquant	: 2; 	/* ENTRY_POINT_LAYER::DQUANT */
            unsigned char quantizer     : 2; 	/* ENTRY_POINT_LAYER::QUANTIZER */
            unsigned char half_qp	: 1; 	/* PICTURE_LAYER::HALFQP */
            unsigned char pic_quantizer_scale : 5;/* PICTURE_LAYER::PQUANT */
            unsigned char pic_quantizer_type : 1;/* PICTURE_LAYER::PQUANTIZER */
            unsigned char dq_frame	: 1; 	/* VOPDQUANT::DQUANTFRM */
            unsigned char dq_profile	: 2; 	/* VOPDQUANT::DQPROFILE */
            unsigned char dq_sb_edge	: 2; 	/* VOPDQUANT::DQSBEDGE */
            unsigned char dq_db_edge 	: 2; 	/* VOPDQUANT::DQDBEDGE */
            unsigned char dq_binary_level : 1; 	/* VOPDQUANT::DQBILEVEL */
            unsigned char alt_pic_quantizer : 5;/* VOPDQUANT::ALTPQUANT */
        } bits;
        unsigned long value;
    } pic_quantizer_fields;
    union {
        struct {
            unsigned char variable_sized_transform_flag	: 1;/* ENTRY_POINT_LAYER::VSTRANSFORM */
            unsigned char mb_level_transform_type_flag	: 1;/* PICTURE_LAYER::TTMBF */
            unsigned char frame_level_transform_type	: 2;/* PICTURE_LAYER::TTFRM */
            unsigned char transform_ac_codingset_idx1	: 2;/* PICTURE_LAYER::TRANSACFRM */
            unsigned char transform_ac_codingset_idx2	: 2;/* PICTURE_LAYER::TRANSACFRM2 */
            unsigned char intra_transform_dc_table	: 1;/* PICTURE_LAYER::TRANSDCTAB */
        } bits;
        unsigned short value;
    } transform_fields;
} VAPictureParameterBufferVC1_0_30;

/* MPEG-2 Picture Parameter Buffer (0.30) */
typedef struct _VAPictureParameterBufferMPEG2_0_30
{
    unsigned short horizontal_size;
    unsigned short vertical_size;
    VASurfaceID forward_reference_picture;
    VASurfaceID backward_reference_picture;
    /* meanings of the following fields are the same as in the standard */
    int picture_coding_type;
    int f_code; /* pack all four fcode into this */
    union {
        struct {
            unsigned int intra_dc_precision		: 2; 
            unsigned int picture_structure		: 2; 
            unsigned int top_field_first		: 1; 
            unsigned int frame_pred_frame_dct		: 1; 
            unsigned int concealment_motion_vectors	: 1;
            unsigned int q_scale_type			: 1;
            unsigned int intra_vlc_format		: 1;
            unsigned int alternate_scan			: 1;
            unsigned int repeat_first_field		: 1;
            unsigned int progressive_frame		: 1;
            unsigned int is_first_field			: 1; /* indicate whether the current field
                                                              * is the first field for field picture
                                                              */
        } bits;
        unsigned int value;
    } picture_coding_extension;
} VAPictureParameterBufferMPEG2_0_30;

/* MPEG-2 Slice Parameter Buffer (0.29) */
typedef VASliceParameterBufferMPEG2_0_29 VASliceParameterBufferMPEG2_0_30;

/* MPEG-4 Picture Parameter Buffer (0.30) */
typedef struct _VAPictureParameterBufferMPEG4_0_30
{
    unsigned short vop_width;
    unsigned short vop_height;
    VASurfaceID forward_reference_picture;
    VASurfaceID backward_reference_picture;
    union {
        struct {
            unsigned char short_video_header		: 1; 
            unsigned char chroma_format			: 2; 
            unsigned char interlaced			: 1; 
            unsigned char obmc_disable			: 1; 
            unsigned char sprite_enable			: 2; 
            unsigned char sprite_warping_accuracy	: 2; 
            unsigned char quant_type			: 1; 
            unsigned char quarter_sample			: 1; 
            unsigned char data_partitioned		: 1; 
            unsigned char reversible_vlc			: 1; 
        } bits;
        unsigned short value;
    } vol_fields;
    unsigned char no_of_sprite_warping_points;
    short sprite_trajectory_du[3];
    short sprite_trajectory_dv[3];
    unsigned char quant_precision;
    union {
        struct {
            unsigned char vop_coding_type		: 2; 
            unsigned char backward_reference_vop_coding_type	: 2; 
            unsigned char vop_rounding_type		: 1; 
            unsigned char intra_dc_vlc_thr		: 3; 
            unsigned char top_field_first		: 1; 
            unsigned char alternate_vertical_scan_flag	: 1; 
        } bits;
        unsigned short value;
    } vop_fields;
    unsigned char vop_fcode_forward;
    unsigned char vop_fcode_backward;
    /* short header related */
    unsigned char num_gobs_in_vop;
    unsigned char num_macroblocks_in_gob;
    /* for direct mode prediction */
    short TRB;
    short TRD;
} VAPictureParameterBufferMPEG4_0_30;

/* Encode Slice Parameter Buffer (0.30) */
typedef struct _VAEncSliceParameterBuffer_0_30
{
    unsigned int start_row_number;	/* starting MB row number for this slice */
    unsigned int slice_height;	/* slice height measured in MB */
    union {
        struct {
            unsigned char is_intra	: 1;
            unsigned char disable_deblocking_filter_idc : 2;
        } bits;
        unsigned char value;
    } slice_flags;
} VAEncSliceParameterBuffer_0_30;

/* MPEG-4 Picture Parameter Buffer (0.31) */
typedef struct _VAPictureParameterBufferMPEG4_0_31
{
    unsigned short vop_width;
    unsigned short vop_height;
    VASurfaceID forward_reference_picture;
    VASurfaceID backward_reference_picture;
    union {
        struct {
            unsigned int short_video_header		: 1; 
            unsigned int chroma_format			: 2; 
            unsigned int interlaced			: 1; 
            unsigned int obmc_disable			: 1; 
            unsigned int sprite_enable			: 2; 
            unsigned int sprite_warping_accuracy	: 2; 
            unsigned int quant_type			: 1; 
            unsigned int quarter_sample			: 1; 
            unsigned int data_partitioned		: 1; 
            unsigned int reversible_vlc			: 1; 
        } bits;
        unsigned int value;
    } vol_fields;
    unsigned char no_of_sprite_warping_points;
    short sprite_trajectory_du[3];
    short sprite_trajectory_dv[3];
    unsigned char quant_precision;
    union {
        struct {
            unsigned int vop_coding_type		: 2; 
            unsigned int backward_reference_vop_coding_type	: 2; 
            unsigned int vop_rounding_type		: 1; 
            unsigned int intra_dc_vlc_thr		: 3; 
            unsigned int top_field_first		: 1; 
            unsigned int alternate_vertical_scan_flag	: 1; 
        } bits;
        unsigned int value;
    } vop_fields;
    unsigned char vop_fcode_forward;
    unsigned char vop_fcode_backward;
    /* short header related */
    unsigned char num_gobs_in_vop;
    unsigned char num_macroblocks_in_gob;
    /* for direct mode prediction */
    short TRB;
    short TRD;
} VAPictureParameterBufferMPEG4_0_31;

typedef struct VADriverContext_0_29 *VADriverContextP_0_29;

/* Driver VTable (0.29) */
struct VADriverVTable_0_29
{
	VAStatus (*vaTerminate) ( VADriverContextP_0_29 ctx );

	VAStatus (*vaQueryConfigProfiles) (
		VADriverContextP_0_29 ctx,
		VAProfile *profile_list,	/* out */
		int *num_profiles			/* out */
	);

	VAStatus (*vaQueryConfigEntrypoints) (
		VADriverContextP_0_29 ctx,
		VAProfile profile,
		VAEntrypoint  *entrypoint_list,	/* out */
		int *num_entrypoints			/* out */
	);

	VAStatus (*vaGetConfigAttributes) (
		VADriverContextP_0_29 ctx,
		VAProfile profile,
		VAEntrypoint entrypoint,
		VAConfigAttrib *attrib_list,	/* in/out */
		int num_attribs
	);

	VAStatus (*vaCreateConfig) (
		VADriverContextP_0_29 ctx,
		VAProfile profile, 
		VAEntrypoint entrypoint, 
		VAConfigAttrib *attrib_list,
		int num_attribs,
		VAConfigID *config_id		/* out */
	);

	VAStatus (*vaDestroyConfig) (
		VADriverContextP_0_29 ctx,
		VAConfigID config_id
	);

	VAStatus (*vaQueryConfigAttributes) (
		VADriverContextP_0_29 ctx,
		VAConfigID config_id, 
		VAProfile *profile,		/* out */
		VAEntrypoint *entrypoint, 	/* out */
		VAConfigAttrib *attrib_list,	/* out */
		int *num_attribs		/* out */
	);

	VAStatus (*vaCreateSurfaces) (
		VADriverContextP_0_29 ctx,
		int width,
		int height,
		int format,
		int num_surfaces,
		VASurfaceID *surfaces		/* out */
	);

	VAStatus (*vaDestroySurfaces) (
		VADriverContextP_0_29 ctx,
		VASurfaceID *surface_list,
		int num_surfaces
	);

	VAStatus (*vaCreateContext) (
		VADriverContextP_0_29 ctx,
		VAConfigID config_id,
		int picture_width,
		int picture_height,
		int flag,
		VASurfaceID *render_targets,
		int num_render_targets,
		VAContextID *context		/* out */
	);

	VAStatus (*vaDestroyContext) (
		VADriverContextP_0_29 ctx,
		VAContextID context
	);

	VAStatus (*vaCreateBuffer) (
		VADriverContextP_0_29 ctx,
		VAContextID context,		/* in */
		VABufferType type,		/* in */
		unsigned int size,		/* in */
		unsigned int num_elements,	/* in */
		void *data,			/* in */
		VABufferID *buf_id		/* out */
	);

	VAStatus (*vaBufferSetNumElements) (
		VADriverContextP_0_29 ctx,
		VABufferID buf_id,	/* in */
		unsigned int num_elements	/* in */
	);

	VAStatus (*vaMapBuffer) (
		VADriverContextP_0_29 ctx,
		VABufferID buf_id,	/* in */
		void **pbuf         /* out */
	);

	VAStatus (*vaUnmapBuffer) (
		VADriverContextP_0_29 ctx,
		VABufferID buf_id	/* in */
	);

	VAStatus (*vaDestroyBuffer) (
		VADriverContextP_0_29 ctx,
		VABufferID buffer_id
	);

	VAStatus (*vaBeginPicture) (
		VADriverContextP_0_29 ctx,
		VAContextID context,
		VASurfaceID render_target
	);

	VAStatus (*vaRenderPicture) (
		VADriverContextP_0_29 ctx,
		VAContextID context,
		VABufferID *buffers,
		int num_buffers
	);

	VAStatus (*vaEndPicture) (
		VADriverContextP_0_29 ctx,
		VAContextID context
	);

	VAStatus (*vaSyncSurface) (
		VADriverContextP_0_29 ctx,
		VAContextID context,
		VASurfaceID render_target
	);

	VAStatus (*vaQuerySurfaceStatus) (
		VADriverContextP_0_29 ctx,
		VASurfaceID render_target,
		VASurfaceStatus *status	/* out */
	);

	VAStatus (*vaPutSurface) (
    		VADriverContextP_0_29 ctx,
		VASurfaceID surface,
		unsigned long draw, /* X Drawable */
		short srcx,
		short srcy,
		unsigned short srcw,
		unsigned short srch,
		short destx,
		short desty,
		unsigned short destw,
		unsigned short desth,
		VARectangle *cliprects, /* client supplied clip list */
		unsigned int number_cliprects, /* number of clip rects in the clip list */
		unsigned int flags /* de-interlacing flags */
	);

	VAStatus (*vaQueryImageFormats) (
		VADriverContextP_0_29 ctx,
		VAImageFormat *format_list,        /* out */
		int *num_formats           /* out */
	);

	VAStatus (*vaCreateImage) (
		VADriverContextP_0_29 ctx,
		VAImageFormat *format,
		int width,
		int height,
		VAImage *image     /* out */
	);

	VAStatus (*vaDeriveImage) (
		VADriverContextP_0_29 ctx,
		VASurfaceID surface,
		VAImage *image     /* out */
	);

	VAStatus (*vaDestroyImage) (
		VADriverContextP_0_29 ctx,
		VAImageID image
	);
	
	VAStatus (*vaSetImagePalette) (
	        VADriverContextP_0_29 ctx,
	        VAImageID image,
	        /*
                 * pointer to an array holding the palette data.  The size of the array is
                 * num_palette_entries * entry_bytes in size.  The order of the components
                 * in the palette is described by the component_order in VAImage struct
                 */
                unsigned char *palette
	);
	
	VAStatus (*vaGetImage) (
		VADriverContextP_0_29 ctx,
		VASurfaceID surface,
		int x,     /* coordinates of the upper left source pixel */
		int y,
		unsigned int width, /* width and height of the region */
		unsigned int height,
		VAImageID image
	);

	VAStatus (*vaPutImage) (
		VADriverContextP_0_29 ctx,
		VASurfaceID surface,
		VAImageID image,
		int src_x,
		int src_y,
		unsigned int width,
		unsigned int height,
		int dest_x,
		int dest_y 
	);

	VAStatus (*vaPutImage2) (
		VADriverContextP_0_29 ctx,
		VASurfaceID surface,
		VAImageID image,
		int src_x,
		int src_y,
		unsigned int src_width,
		unsigned int src_height,
		int dest_x,
		int dest_y,
		unsigned int dest_width,
		unsigned int dest_height
	);

	VAStatus (*vaQuerySubpictureFormats) (
		VADriverContextP_0_29 ctx,
		VAImageFormat *format_list,        /* out */
		unsigned int *flags,       /* out */
		unsigned int *num_formats  /* out */
	);

	VAStatus (*vaCreateSubpicture) (
		VADriverContextP_0_29 ctx,
		VAImageID image,
		VASubpictureID *subpicture   /* out */
	);

	VAStatus (*vaDestroySubpicture) (
		VADriverContextP_0_29 ctx,
		VASubpictureID subpicture
	);

        VAStatus (*vaSetSubpictureImage) (
                VADriverContextP_0_29 ctx,
                VASubpictureID subpicture,
                VAImageID image
        );
        
	VAStatus (*vaSetSubpicturePalette) (
		VADriverContextP_0_29 ctx,
		VASubpictureID subpicture,
		/*
		 * pointer to an array holding the palette data.  The size of the array is
		 * num_palette_entries * entry_bytes in size.  The order of the components
		 * in the palette is described by the component_order in VASubpicture struct
		 */
		unsigned char *palette
	);

	VAStatus (*vaSetSubpictureChromakey) (
		VADriverContextP_0_29 ctx,
		VASubpictureID subpicture,
		unsigned int chromakey_min,
		unsigned int chromakey_max,
		unsigned int chromakey_mask
	);

	VAStatus (*vaSetSubpictureGlobalAlpha) (
		VADriverContextP_0_29 ctx,
		VASubpictureID subpicture,
		float global_alpha 
	);

	VAStatus (*vaAssociateSubpicture) (
		VADriverContextP_0_29 ctx,
		VASubpictureID subpicture,
		VASurfaceID *target_surfaces,
		int num_surfaces,
		short src_x, /* upper left offset in subpicture */
		short src_y,
		short dest_x, /* upper left offset in surface */
		short dest_y,
		unsigned short width,
		unsigned short height,
		/*
		 * whether to enable chroma-keying or global-alpha
		 * see VA_SUBPICTURE_XXX values
		 */
		unsigned int flags
	);

	VAStatus (*vaAssociateSubpicture2) (
		VADriverContextP_0_29 ctx,
		VASubpictureID subpicture,
		VASurfaceID *target_surfaces,
		int num_surfaces,
		short src_x, /* upper left offset in subpicture */
		short src_y,
		unsigned short src_width,
		unsigned short src_height,
		short dest_x, /* upper left offset in surface */
		short dest_y,
		unsigned short dest_width,
		unsigned short dest_height,
		/*
		 * whether to enable chroma-keying or global-alpha
		 * see VA_SUBPICTURE_XXX values
		 */
		unsigned int flags
	);

	VAStatus (*vaDeassociateSubpicture) (
		VADriverContextP_0_29 ctx,
		VASubpictureID subpicture,
		VASurfaceID *target_surfaces,
		int num_surfaces
	);

	VAStatus (*vaQueryDisplayAttributes) (
		VADriverContextP_0_29 ctx,
		VADisplayAttribute *attr_list,	/* out */
		int *num_attributes		/* out */
        );

	VAStatus (*vaGetDisplayAttributes) (
		VADriverContextP_0_29 ctx,
		VADisplayAttribute *attr_list,	/* in/out */
		int num_attributes
        );
        
        VAStatus (*vaSetDisplayAttributes) (
		VADriverContextP_0_29 ctx,
                VADisplayAttribute *attr_list,
                int num_attributes
        );


	VAStatus (*vaDbgCopySurfaceToBuffer) (
		VADriverContextP_0_29 ctx,
		VASurfaceID surface,
		void **buffer, /* out */
		unsigned int *stride /* out */
	);
};

/* Driver context (0.29) */
struct VADriverContext_0_29
{
    void *old_pNext;			/* preserved for binary compatibility */

    void *pDriverData;
    struct VADriverVTable_0_29 vtable;

    void *x11_dpy;
    int x11_screen;

    int version_major;
    int version_minor;
    int max_profiles;
    int max_entrypoints;
    int max_attributes;
    int max_image_formats;
    int max_subpic_formats;
    int max_display_attributes;
    const char *str_vendor;

    void *handle;			/* dlopen handle */
};

/* Forward declarations for VA API 0.30 */
struct v4l2_format;
struct v4l2_buffer;
typedef struct VADriverContext_0_30 *VADriverContextP_0_30;

/* Driver VTable (0.30) */
struct VADriverVTable_0_30
{
	VAStatus (*vaTerminate) ( VADriverContextP_0_30 ctx );

	VAStatus (*vaQueryConfigProfiles) (
		VADriverContextP_0_30 ctx,
		VAProfile *profile_list,	/* out */
		int *num_profiles			/* out */
	);

	VAStatus (*vaQueryConfigEntrypoints) (
		VADriverContextP_0_30 ctx,
		VAProfile profile,
		VAEntrypoint  *entrypoint_list,	/* out */
		int *num_entrypoints			/* out */
	);

	VAStatus (*vaGetConfigAttributes) (
		VADriverContextP_0_30 ctx,
		VAProfile profile,
		VAEntrypoint entrypoint,
		VAConfigAttrib *attrib_list,	/* in/out */
		int num_attribs
	);

	VAStatus (*vaCreateConfig) (
		VADriverContextP_0_30 ctx,
		VAProfile profile, 
		VAEntrypoint entrypoint, 
		VAConfigAttrib *attrib_list,
		int num_attribs,
		VAConfigID *config_id		/* out */
	);

	VAStatus (*vaDestroyConfig) (
		VADriverContextP_0_30 ctx,
		VAConfigID config_id
	);

	VAStatus (*vaQueryConfigAttributes) (
		VADriverContextP_0_30 ctx,
		VAConfigID config_id, 
		VAProfile *profile,		/* out */
		VAEntrypoint *entrypoint, 	/* out */
		VAConfigAttrib *attrib_list,	/* out */
		int *num_attribs		/* out */
	);

	VAStatus (*vaCreateSurfaces) (
		VADriverContextP_0_30 ctx,
		int width,
		int height,
		int format,
		int num_surfaces,
		VASurfaceID *surfaces		/* out */
	);

	VAStatus (*vaDestroySurfaces) (
		VADriverContextP_0_30 ctx,
		VASurfaceID *surface_list,
		int num_surfaces
	);

	VAStatus (*vaCreateContext) (
		VADriverContextP_0_30 ctx,
		VAConfigID config_id,
		int picture_width,
		int picture_height,
		int flag,
		VASurfaceID *render_targets,
		int num_render_targets,
		VAContextID *context		/* out */
	);

	VAStatus (*vaDestroyContext) (
		VADriverContextP_0_30 ctx,
		VAContextID context
	);

	VAStatus (*vaCreateBuffer) (
		VADriverContextP_0_30 ctx,
		VAContextID context,		/* in */
		VABufferType type,		/* in */
		unsigned int size,		/* in */
		unsigned int num_elements,	/* in */
		void *data,			/* in */
		VABufferID *buf_id		/* out */
	);

	VAStatus (*vaBufferSetNumElements) (
		VADriverContextP_0_30 ctx,
		VABufferID buf_id,	/* in */
		unsigned int num_elements	/* in */
	);

	VAStatus (*vaMapBuffer) (
		VADriverContextP_0_30 ctx,
		VABufferID buf_id,	/* in */
		void **pbuf         /* out */
	);

	VAStatus (*vaUnmapBuffer) (
		VADriverContextP_0_30 ctx,
		VABufferID buf_id	/* in */
	);

	VAStatus (*vaDestroyBuffer) (
		VADriverContextP_0_30 ctx,
		VABufferID buffer_id
	);

	VAStatus (*vaBeginPicture) (
		VADriverContextP_0_30 ctx,
		VAContextID context,
		VASurfaceID render_target
	);

	VAStatus (*vaRenderPicture) (
		VADriverContextP_0_30 ctx,
		VAContextID context,
		VABufferID *buffers,
		int num_buffers
	);

	VAStatus (*vaEndPicture) (
		VADriverContextP_0_30 ctx,
		VAContextID context
	);

	VAStatus (*vaSyncSurface) (
		VADriverContextP_0_30 ctx,
		VAContextID context,
		VASurfaceID render_target
	);

	VAStatus (*vaQuerySurfaceStatus) (
		VADriverContextP_0_30 ctx,
		VASurfaceID render_target,
		VASurfaceStatus *status	/* out */
	);

	VAStatus (*vaPutSurface) (
    		VADriverContextP_0_30 ctx,
		VASurfaceID surface,
		unsigned long draw, /* X Drawable */
		short srcx,
		short srcy,
		unsigned short srcw,
		unsigned short srch,
		short destx,
		short desty,
		unsigned short destw,
		unsigned short desth,
		VARectangle *cliprects, /* client supplied clip list */
		unsigned int number_cliprects, /* number of clip rects in the clip list */
		unsigned int flags /* de-interlacing flags */
	);

	VAStatus (*vaQueryImageFormats) (
		VADriverContextP_0_30 ctx,
		VAImageFormat *format_list,        /* out */
		int *num_formats           /* out */
	);

	VAStatus (*vaCreateImage) (
		VADriverContextP_0_30 ctx,
		VAImageFormat *format,
		int width,
		int height,
		VAImage *image     /* out */
	);

	VAStatus (*vaDeriveImage) (
		VADriverContextP_0_30 ctx,
		VASurfaceID surface,
		VAImage *image     /* out */
	);

	VAStatus (*vaDestroyImage) (
		VADriverContextP_0_30 ctx,
		VAImageID image
	);
	
	VAStatus (*vaSetImagePalette) (
	        VADriverContextP_0_30 ctx,
	        VAImageID image,
	        /*
                 * pointer to an array holding the palette data.  The size of the array is
                 * num_palette_entries * entry_bytes in size.  The order of the components
                 * in the palette is described by the component_order in VAImage struct
                 */
                unsigned char *palette
	);
	
	VAStatus (*vaGetImage) (
		VADriverContextP_0_30 ctx,
		VASurfaceID surface,
		int x,     /* coordinates of the upper left source pixel */
		int y,
		unsigned int width, /* width and height of the region */
		unsigned int height,
		VAImageID image
	);

	VAStatus (*vaPutImage) (
		VADriverContextP_0_30 ctx,
		VASurfaceID surface,
		VAImageID image,
		int src_x,
		int src_y,
		unsigned int width,
		unsigned int height,
		int dest_x,
		int dest_y 
	);

	VAStatus (*vaPutImage2) (
		VADriverContextP_0_30 ctx,
		VASurfaceID surface,
		VAImageID image,
		int src_x,
		int src_y,
		unsigned int src_width,
		unsigned int src_height,
		int dest_x,
		int dest_y,
		unsigned int dest_width,
		unsigned int dest_height
	);

	VAStatus (*vaQuerySubpictureFormats) (
		VADriverContextP_0_30 ctx,
		VAImageFormat *format_list,        /* out */
		unsigned int *flags,       /* out */
		unsigned int *num_formats  /* out */
	);

	VAStatus (*vaCreateSubpicture) (
		VADriverContextP_0_30 ctx,
		VAImageID image,
		VASubpictureID *subpicture   /* out */
	);

	VAStatus (*vaDestroySubpicture) (
		VADriverContextP_0_30 ctx,
		VASubpictureID subpicture
	);

        VAStatus (*vaSetSubpictureImage) (
                VADriverContextP_0_30 ctx,
                VASubpictureID subpicture,
                VAImageID image
        );

	VAStatus (*vaSetSubpictureChromakey) (
		VADriverContextP_0_30 ctx,
		VASubpictureID subpicture,
		unsigned int chromakey_min,
		unsigned int chromakey_max,
		unsigned int chromakey_mask
	);

	VAStatus (*vaSetSubpictureGlobalAlpha) (
		VADriverContextP_0_30 ctx,
		VASubpictureID subpicture,
		float global_alpha 
	);

	VAStatus (*vaAssociateSubpicture) (
		VADriverContextP_0_30 ctx,
		VASubpictureID subpicture,
		VASurfaceID *target_surfaces,
		int num_surfaces,
		short src_x, /* upper left offset in subpicture */
		short src_y,
		short dest_x, /* upper left offset in surface */
		short dest_y,
		unsigned short width,
		unsigned short height,
		/*
		 * whether to enable chroma-keying or global-alpha
		 * see VA_SUBPICTURE_XXX values
		 */
		unsigned int flags
	);

	VAStatus (*vaAssociateSubpicture2) (
		VADriverContextP_0_30 ctx,
		VASubpictureID subpicture,
		VASurfaceID *target_surfaces,
		int num_surfaces,
		short src_x, /* upper left offset in subpicture */
		short src_y,
		unsigned short src_width,
		unsigned short src_height,
		short dest_x, /* upper left offset in surface */
		short dest_y,
		unsigned short dest_width,
		unsigned short dest_height,
		/*
		 * whether to enable chroma-keying or global-alpha
		 * see VA_SUBPICTURE_XXX values
		 */
		unsigned int flags
	);

	VAStatus (*vaDeassociateSubpicture) (
		VADriverContextP_0_30 ctx,
		VASubpictureID subpicture,
		VASurfaceID *target_surfaces,
		int num_surfaces
	);

	VAStatus (*vaQueryDisplayAttributes) (
		VADriverContextP_0_30 ctx,
		VADisplayAttribute *attr_list,	/* out */
		int *num_attributes		/* out */
        );

	VAStatus (*vaGetDisplayAttributes) (
		VADriverContextP_0_30 ctx,
		VADisplayAttribute *attr_list,	/* in/out */
		int num_attributes
        );
        
        VAStatus (*vaSetDisplayAttributes) (
		VADriverContextP_0_30 ctx,
                VADisplayAttribute *attr_list,
                int num_attributes
        );

        /* device specific */
	VAStatus (*vaCreateSurfaceFromCIFrame) (
		VADriverContextP_0_30 ctx,
		unsigned long frame_id,
		VASurfaceID *surface		/* out */
	);
    
    
        VAStatus (*vaCreateSurfaceFromV4L2Buf) (
		VADriverContextP_0_30 ctx,
                int v4l2_fd,         /* file descriptor of V4L2 device */
                struct v4l2_format *v4l2_fmt,       /* format of V4L2 */
                struct v4l2_buffer *v4l2_buf,       /* V4L2 buffer */
                VASurfaceID *surface	           /* out */
        );
    
        VAStatus (*vaCopySurfaceToBuffer) (
		VADriverContextP_0_30 ctx,
                VASurfaceID surface,
                unsigned int *fourcc, /* out  for follow argument */
                unsigned int *luma_stride,
                unsigned int *chroma_u_stride,
                unsigned int *chroma_v_stride,
                unsigned int *luma_offset,
                unsigned int *chroma_u_offset,
                unsigned int *chroma_v_offset,
                void **buffer
        );
};

/* Driver context (0.30) */
struct VADriverContext_0_30
{
    void *pDriverData;
    struct VADriverVTable_0_30 vtable;

    void *x11_dpy;
    int x11_screen;
    int version_major;
    int version_minor;
    int max_profiles;
    int max_entrypoints;
    int max_attributes;
    int max_image_formats;
    int max_subpic_formats;
    int max_display_attributes;
    const char *str_vendor;

    void *handle;			/* dlopen handle */
    
    void *dri_state;
};

/* Driver VTable and context (0.31) */
#define VADriverVTable_0_31     VADriverVTable
#define VADriverContext_0_31    VADriverContext

#endif /* VA_COMPAT_H */
