/*
 * Copyright (C) 2009 Splitted-Desktop Systems. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#undef  CONCAT_
#define CONCAT_(x, y)                   x##y
#undef  CONCAT
#define CONCAT(x, y)                    CONCAT_(x, y)
#undef  MKCOMPAT_
#define MKCOMPAT_(NAME,MINOR)           CONCAT(CONCAT(NAME,_0_),MINOR)
#undef  MKCOMPAT
#define MKCOMPAT(NAME)                  MKCOMPAT_(NAME,COMPAT_MINOR)
#undef  STRUCT
#define STRUCT(BUFFER, CODEC)           MKCOMPAT(VA##BUFFER##Buffer##CODEC)
#undef  TRANSLATE_1
#define TRANSLATE_1(NAME)               CONCAT(va_compat_translate_,NAME)
#undef  TRANSLATE_
#define TRANSLATE_(NAME)                TRANSLATE_1(MKCOMPAT(NAME))
#undef  TRANSLATE
#define TRANSLATE(BUFFER, CODEC)        TRANSLATE_1(STRUCT(BUFFER,CODEC))

#undef  COPY_ARRAY
#define COPY_ARRAY(DST, SRC, ARRAY) \
    memcpy((DST)->ARRAY, (SRC)->ARRAY, sizeof((DST)->ARRAY))

#undef  COPY_FIELD
#define COPY_FIELD(DST, SRC, MEMBER) \
    (DST)->MEMBER = (SRC)->MEMBER

#undef  COPY_VTABLE__
#define COPY_VTABLE__(DST, DST_MEMBER, SRC, SRC_MEMBER) \
    (DST##_vtable)->DST_MEMBER = (SRC##_vtable)->SRC_MEMBER

#undef  COPY_VTABLE_
#define COPY_VTABLE_(DST, DST_SUFFIX, SRC, MEMBER) \
    COPY_VTABLE__(DST, MEMBER##_##DST_SUFFIX, SRC, MEMBER)

#undef  COPY_VTABLE
#define COPY_VTABLE(DST, SRC, MEMBER) \
    COPY_VTABLE__(DST, MEMBER, SRC, MEMBER)

/* 0.29 */
#if COMPAT_MAJOR == 0 && COMPAT_MINOR == 29
#undef  BFV
#define BFV(a, b) a
#undef  BFM
#define BFM(a, b, c) c
#undef  COPY_BIT_FIELD
#define COPY_BIT_FIELD(DST, SRC, FIELD, MEMBER)  \
    (DST)->MEMBER = (SRC)->FIELD.bits.MEMBER
#undef  COPY_BIT_FLAG
#define COPY_BIT_FLAG(DST, SRC, FIELD, MEMBER)  \
    (DST)->MEMBER = (SRC)->FIELD.flags.MEMBER
#endif

/* 0.29 glue to match 0.30 names */
#undef M_raw_coding
#undef M_bitplane_present
#undef M_luma_flag
#undef M_luma
#undef M_chroma_flag
#undef M_chroma

#if COMPAT_MAJOR == 0 && COMPAT_MINOR == 29
#define M_raw_coding            raw_coding_flag
#define M_bitplane_present      bitplane_present_flag
#define M_luma_flag             range_mapping_luma_flag
#define M_luma                  range_mapping_luma
#define M_chroma_flag           range_mapping_chroma_flag
#define M_chroma                range_mapping_chroma
#else
#define M_raw_coding            raw_coding
#define M_bitplane_present      bitplane_present
#define M_luma_flag             luma_flag
#define M_luma                  luma
#define M_chroma_flag           chroma_flag
#define M_chroma                chroma
#endif

/* 0.30 */
#if COMPAT_MAJOR == 0 && COMPAT_MINOR == 30
#undef  BFV
#define BFV(a, b) a.b
#undef  BFM
#define BFM(a, b, c) a.b.c
#undef  COPY_BIT_FIELD
#define COPY_BIT_FIELD(DST, SRC, FIELD, MEMBER)  \
    (DST)->FIELD.bits.MEMBER = (SRC)->FIELD.bits.MEMBER
#undef  COPY_BIT_FLAG
#define COPY_BIT_FLAG(DST, SRC, FIELD, MEMBER)  \
    (DST)->FIELD.flags.MEMBER = (SRC)->FIELD.flags.MEMBER
#endif

#if COMPAT_MAJOR == 0 && COMPAT_MINOR < 31
static VAStatus TRANSLATE_(VAPictureH264)(
    VACompatContextP    ctx,
    void               *dest_pic,
    const void         *src_pic
)
{
    MKCOMPAT(VAPictureH264) *dest = dest_pic;
    const VAPictureH264 *src = src_pic;

    COPY_FIELD(dest, src, picture_id);
    COPY_FIELD(dest, src, flags);
    COPY_FIELD(dest, src, TopFieldOrderCnt);
    COPY_FIELD(dest, src, BottomFieldOrderCnt);

    return VA_STATUS_SUCCESS;
}

static VAStatus TRANSLATE(PictureParameter,H264)(
    VACompatContextP    ctx,
    void               *dest_buffer,
    const void         *src_buffer
)
{
    STRUCT(PictureParameter,H264) *dest = dest_buffer;
    const VAPictureParameterBufferH264 *src = src_buffer;
    VAStatus status;
    int i;

    status = TRANSLATE_(VAPictureH264)(ctx,
                                      &dest->CurrPic, &src->CurrPic);
    if (status != VA_STATUS_SUCCESS)
        return status;

    for (i = 0; i < 16; i++) {
        status = TRANSLATE_(VAPictureH264)(ctx,
                                           &dest->ReferenceFrames[i],
                                           &src->ReferenceFrames[i]);
        if (status != VA_STATUS_SUCCESS)
            return status;
    }

    COPY_FIELD(dest, src, picture_width_in_mbs_minus1);
    COPY_FIELD(dest, src, picture_height_in_mbs_minus1);
    COPY_FIELD(dest, src, bit_depth_luma_minus8);
    COPY_FIELD(dest, src, bit_depth_chroma_minus8);
    COPY_FIELD(dest, src, num_ref_frames);
    dest->BFV(seq_fields, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, seq_fields, chroma_format_idc);
    COPY_BIT_FIELD(dest, src, seq_fields, residual_colour_transform_flag);
    COPY_BIT_FIELD(dest, src, seq_fields, frame_mbs_only_flag);
    COPY_BIT_FIELD(dest, src, seq_fields, mb_adaptive_frame_field_flag);
    COPY_BIT_FIELD(dest, src, seq_fields, direct_8x8_inference_flag);
    COPY_BIT_FIELD(dest, src, seq_fields, MinLumaBiPredSize8x8);
    COPY_FIELD(dest, src, num_slice_groups_minus1);
    COPY_FIELD(dest, src, slice_group_map_type);
    COPY_FIELD(dest, src, pic_init_qp_minus26);
    COPY_FIELD(dest, src, chroma_qp_index_offset);
    COPY_FIELD(dest, src, second_chroma_qp_index_offset);
    dest->BFV(pic_fields, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, pic_fields, entropy_coding_mode_flag);
    COPY_BIT_FIELD(dest, src, pic_fields, weighted_pred_flag);
    COPY_BIT_FIELD(dest, src, pic_fields, weighted_bipred_idc);
    COPY_BIT_FIELD(dest, src, pic_fields, transform_8x8_mode_flag);
    COPY_BIT_FIELD(dest, src, pic_fields, field_pic_flag);
    COPY_BIT_FIELD(dest, src, pic_fields, constrained_intra_pred_flag);
    COPY_FIELD(dest, src, frame_num);

    return VA_STATUS_SUCCESS;
}

static VAStatus TRANSLATE(SliceParameter,H264)(
    VACompatContextP    ctx,
    void               *dest_buffer,
    const void         *src_buffer
)
{
    STRUCT(SliceParameter,H264) *dest = dest_buffer;
    const VASliceParameterBufferH264 *src = src_buffer;
    VAStatus status;
    int i;

    COPY_FIELD(dest, src, slice_data_size);
    COPY_FIELD(dest, src, slice_data_offset);
    COPY_FIELD(dest, src, slice_data_flag);
    COPY_FIELD(dest, src, slice_data_bit_offset);
    COPY_FIELD(dest, src, first_mb_in_slice);
    COPY_FIELD(dest, src, slice_type);
    COPY_FIELD(dest, src, direct_spatial_mv_pred_flag);
    COPY_FIELD(dest, src, num_ref_idx_l0_active_minus1);
    COPY_FIELD(dest, src, num_ref_idx_l1_active_minus1);
    COPY_FIELD(dest, src, cabac_init_idc);
    COPY_FIELD(dest, src, slice_qp_delta);
    COPY_FIELD(dest, src, disable_deblocking_filter_idc);
    COPY_FIELD(dest, src, slice_alpha_c0_offset_div2);
    COPY_FIELD(dest, src, slice_beta_offset_div2);
    for (i = 0; i < 32; i++) {
        status = TRANSLATE_(VAPictureH264)(ctx,
                                           &dest->RefPicList0[i],
                                           &src->RefPicList0[i]);
        if (status != VA_STATUS_SUCCESS)
            return status;
        status = TRANSLATE_(VAPictureH264)(ctx,
                                           &dest->RefPicList1[i],
                                           &src->RefPicList1[i]);
        if (status != VA_STATUS_SUCCESS)
            return status;
    }
    COPY_FIELD(dest, src, luma_log2_weight_denom);
    COPY_FIELD(dest, src, chroma_log2_weight_denom);
    COPY_FIELD(dest, src, luma_weight_l0_flag);
    COPY_ARRAY(dest, src, luma_weight_l0);
    COPY_ARRAY(dest, src, luma_offset_l0);
    COPY_FIELD(dest, src, chroma_weight_l0_flag);
    COPY_ARRAY(dest, src, chroma_weight_l0);
    COPY_ARRAY(dest, src, chroma_offset_l0);
    COPY_FIELD(dest, src, luma_weight_l1_flag);
    COPY_ARRAY(dest, src, luma_weight_l1);
    COPY_ARRAY(dest, src, luma_offset_l1);
    COPY_FIELD(dest, src, chroma_weight_l1_flag);
    COPY_ARRAY(dest, src, chroma_weight_l1);
    COPY_ARRAY(dest, src, chroma_offset_l1);

    return VA_STATUS_SUCCESS;
}

static VAStatus TRANSLATE(PictureParameter,VC1)(
    VACompatContextP    ctx,
    void               *dest_buffer,
    const void         *src_buffer
)
{
    STRUCT(PictureParameter,VC1) *dest = dest_buffer;
    const VAPictureParameterBufferVC1 *src = src_buffer;

    COPY_FIELD(dest, src, forward_reference_picture);
    COPY_FIELD(dest, src, backward_reference_picture);
    COPY_FIELD(dest, src, inloop_decoded_picture);
    dest->BFV(sequence_fields, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, sequence_fields, interlace);
    COPY_BIT_FIELD(dest, src, sequence_fields, syncmarker);
    COPY_BIT_FIELD(dest, src, sequence_fields, overlap);
    COPY_FIELD(dest, src, coded_width);
    COPY_FIELD(dest, src, coded_height);
#if COMPAT_MAJOR == 0 && COMPAT_MINOR == 30
    dest->closed_entry = src->entrypoint_fields.bits.closed_entry;
    dest->broken_link  = src->entrypoint_fields.bits.broken_link;
    dest->loopfilter   = src->entrypoint_fields.bits.loopfilter;
#else
    COPY_BIT_FIELD(dest, src, entrypoint_fields, closed_entry);
    COPY_BIT_FIELD(dest, src, entrypoint_fields, broken_link);
    COPY_BIT_FIELD(dest, src, entrypoint_fields, loopfilter);
#endif
    COPY_FIELD(dest, src, conditional_overlap_flag);
    COPY_FIELD(dest, src, fast_uvmc_flag);
    dest->BFV(range_mapping_fields, value) = 0; /* reset all bits */
    dest->BFM(range_mapping_fields, bits, M_luma_flag) =
        src->range_mapping_fields.bits.luma_flag;
    dest->BFM(range_mapping_fields, bits, M_luma) =
        src->range_mapping_fields.bits.luma;
    dest->BFM(range_mapping_fields, bits, M_chroma_flag) =
        src->range_mapping_fields.bits.chroma_flag;
    dest->BFM(range_mapping_fields, bits, M_chroma) =
        src->range_mapping_fields.bits.chroma;
    COPY_FIELD(dest, src, b_picture_fraction);
    COPY_FIELD(dest, src, cbp_table);
    COPY_FIELD(dest, src, mb_mode_table);
    COPY_FIELD(dest, src, range_reduction_frame);
    COPY_FIELD(dest, src, rounding_control);
    COPY_FIELD(dest, src, post_processing);
    COPY_FIELD(dest, src, picture_resolution_index);
    COPY_FIELD(dest, src, luma_scale);
    COPY_FIELD(dest, src, luma_shift);
    dest->BFV(picture_fields, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, picture_fields, picture_type);
    COPY_BIT_FIELD(dest, src, picture_fields, frame_coding_mode);
    COPY_BIT_FIELD(dest, src, picture_fields, top_field_first);
    COPY_BIT_FIELD(dest, src, picture_fields, is_first_field);
    COPY_BIT_FIELD(dest, src, picture_fields, intensity_compensation);
    dest->BFV(M_raw_coding, value) = 0; /* reset all bits */
    COPY_BIT_FLAG(dest, src, raw_coding, mv_type_mb);
    COPY_BIT_FLAG(dest, src, raw_coding, direct_mb);
    COPY_BIT_FLAG(dest, src, raw_coding, skip_mb);
    COPY_BIT_FLAG(dest, src, raw_coding, field_tx);
    COPY_BIT_FLAG(dest, src, raw_coding, forward_mb);
    COPY_BIT_FLAG(dest, src, raw_coding, ac_pred);
    COPY_BIT_FLAG(dest, src, raw_coding, overflags);
    dest->BFV(M_bitplane_present, value) = 0; /* reset all bits */
    COPY_BIT_FLAG(dest, src, bitplane_present, bp_mv_type_mb);
    COPY_BIT_FLAG(dest, src, bitplane_present, bp_direct_mb);
    COPY_BIT_FLAG(dest, src, bitplane_present, bp_skip_mb);
    COPY_BIT_FLAG(dest, src, bitplane_present, bp_field_tx);
    COPY_BIT_FLAG(dest, src, bitplane_present, bp_forward_mb);
    COPY_BIT_FLAG(dest, src, bitplane_present, bp_ac_pred);
    COPY_BIT_FLAG(dest, src, bitplane_present, bp_overflags);
    dest->BFV(reference_fields, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, reference_fields, reference_distance_flag);
    COPY_BIT_FIELD(dest, src, reference_fields, reference_distance);
    COPY_BIT_FIELD(dest, src, reference_fields, num_reference_pictures);
    COPY_BIT_FIELD(dest, src, reference_fields, reference_field_pic_indicator);
    dest->BFV(mv_fields, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, mv_fields, mv_mode);
    COPY_BIT_FIELD(dest, src, mv_fields, mv_mode2);
    COPY_BIT_FIELD(dest, src, mv_fields, mv_table);
    COPY_BIT_FIELD(dest, src, mv_fields, two_mv_block_pattern_table);
    COPY_BIT_FIELD(dest, src, mv_fields, four_mv_switch);
    COPY_BIT_FIELD(dest, src, mv_fields, four_mv_block_pattern_table);
    COPY_BIT_FIELD(dest, src, mv_fields, extended_mv_flag);
    COPY_BIT_FIELD(dest, src, mv_fields, extended_mv_range);
    COPY_BIT_FIELD(dest, src, mv_fields, extended_dmv_flag);
    COPY_BIT_FIELD(dest, src, mv_fields, extended_dmv_range);
    dest->BFV(pic_quantizer_fields, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, dquant);
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, quantizer);
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, half_qp);
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, pic_quantizer_scale);
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, pic_quantizer_type);
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, dq_frame);
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, dq_profile);
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, dq_sb_edge);
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, dq_db_edge);
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, dq_binary_level);
    COPY_BIT_FIELD(dest, src, pic_quantizer_fields, alt_pic_quantizer);
    dest->BFV(transform_fields, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, transform_fields, variable_sized_transform_flag);
    COPY_BIT_FIELD(dest, src, transform_fields, mb_level_transform_type_flag);
    COPY_BIT_FIELD(dest, src, transform_fields, frame_level_transform_type);
    COPY_BIT_FIELD(dest, src, transform_fields, transform_ac_codingset_idx1);
    COPY_BIT_FIELD(dest, src, transform_fields, transform_ac_codingset_idx2);
    COPY_BIT_FIELD(dest, src, transform_fields, intra_transform_dc_table);

    if (src->picture_fields.bits.picture_type == 4) {
        dest->BFM(picture_fields, bits, picture_type) = 1; /* P-frame */
        ctx->skip_frame = 1;
    }

    return VA_STATUS_SUCCESS;
}

static VAStatus TRANSLATE(PictureParameter,MPEG2)(
    VACompatContextP    ctx,
    void               *dest_buffer,
    const void         *src_buffer
)
{
    STRUCT(PictureParameter,MPEG2) *dest = dest_buffer;
    const VAPictureParameterBufferMPEG2 *src = src_buffer;

    COPY_FIELD(dest, src, horizontal_size);
    COPY_FIELD(dest, src, vertical_size);
    COPY_FIELD(dest, src, forward_reference_picture);
    COPY_FIELD(dest, src, backward_reference_picture);
    COPY_FIELD(dest, src, picture_coding_type);
    COPY_FIELD(dest, src, f_code);
    dest->BFV(picture_coding_extension, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, picture_coding_extension, intra_dc_precision);
    COPY_BIT_FIELD(dest, src, picture_coding_extension, picture_structure);
    COPY_BIT_FIELD(dest, src, picture_coding_extension, top_field_first);
    COPY_BIT_FIELD(dest, src, picture_coding_extension, frame_pred_frame_dct);
    COPY_BIT_FIELD(dest, src, picture_coding_extension, concealment_motion_vectors);
    COPY_BIT_FIELD(dest, src, picture_coding_extension, q_scale_type);
    COPY_BIT_FIELD(dest, src, picture_coding_extension, intra_vlc_format);
    COPY_BIT_FIELD(dest, src, picture_coding_extension, alternate_scan);
    COPY_BIT_FIELD(dest, src, picture_coding_extension, repeat_first_field);
    COPY_BIT_FIELD(dest, src, picture_coding_extension, progressive_frame);
    COPY_BIT_FIELD(dest, src, picture_coding_extension, is_first_field);

    return VA_STATUS_SUCCESS;
}

static VAStatus TRANSLATE(SliceParameter,MPEG2)(
    VACompatContextP    ctx,
    void               *dest_buffer,
    const void         *src_buffer
)
{
    STRUCT(SliceParameter,MPEG2) *dest = dest_buffer;
    const VASliceParameterBufferMPEG2 *src = src_buffer;

    COPY_FIELD(dest, src, slice_data_size);
    COPY_FIELD(dest, src, slice_data_offset);
    COPY_FIELD(dest, src, slice_data_flag);
    COPY_FIELD(dest, src, macroblock_offset);
    COPY_FIELD(dest, src, slice_vertical_position);
    COPY_FIELD(dest, src, quantiser_scale_code);
    COPY_FIELD(dest, src, intra_slice_flag);

    return VA_STATUS_SUCCESS;
}
#endif

static VAStatus TRANSLATE(PictureParameter,MPEG4)(
    VACompatContextP    ctx,
    void               *dest_buffer,
    const void         *src_buffer
)
{
    STRUCT(PictureParameter,MPEG4) *dest = dest_buffer;
    const VAPictureParameterBufferMPEG4 *src = src_buffer;

    COPY_FIELD(dest, src, vop_width);
    COPY_FIELD(dest, src, vop_height);
    COPY_FIELD(dest, src, forward_reference_picture);
    COPY_FIELD(dest, src, backward_reference_picture);
    dest->BFV(vol_fields, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, vol_fields, short_video_header);
    COPY_BIT_FIELD(dest, src, vol_fields, chroma_format);
    COPY_BIT_FIELD(dest, src, vol_fields, interlaced);
    COPY_BIT_FIELD(dest, src, vol_fields, obmc_disable);
    COPY_BIT_FIELD(dest, src, vol_fields, sprite_enable);
    COPY_BIT_FIELD(dest, src, vol_fields, sprite_warping_accuracy);
    COPY_BIT_FIELD(dest, src, vol_fields, quant_type);
    COPY_BIT_FIELD(dest, src, vol_fields, quarter_sample);
    COPY_BIT_FIELD(dest, src, vol_fields, data_partitioned);
    COPY_BIT_FIELD(dest, src, vol_fields, reversible_vlc);
    COPY_FIELD(dest, src, no_of_sprite_warping_points);
    COPY_ARRAY(dest, src, sprite_trajectory_du);
    COPY_ARRAY(dest, src, sprite_trajectory_dv);
    COPY_FIELD(dest, src, quant_precision);
    dest->BFV(vop_fields, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, vop_fields, vop_coding_type);
    COPY_BIT_FIELD(dest, src, vop_fields, backward_reference_vop_coding_type);
    COPY_BIT_FIELD(dest, src, vop_fields, vop_rounding_type);
    COPY_BIT_FIELD(dest, src, vop_fields, intra_dc_vlc_thr);
    COPY_BIT_FIELD(dest, src, vop_fields, top_field_first);
    COPY_BIT_FIELD(dest, src, vop_fields, alternate_vertical_scan_flag);
    COPY_FIELD(dest, src, vop_fcode_forward);
    COPY_FIELD(dest, src, vop_fcode_backward);
    COPY_FIELD(dest, src, num_gobs_in_vop);
    COPY_FIELD(dest, src, num_macroblocks_in_gob);
    COPY_FIELD(dest, src, TRB);
    COPY_FIELD(dest, src, TRD);

    return VA_STATUS_SUCCESS;
}

#if COMPAT_MAJOR == 0 && COMPAT_MINOR == 30
static VAStatus TRANSLATE_(VAEncSliceParameterBuffer)(
    VACompatContextP    ctx,
    void               *dest_buffer,
    const void         *src_buffer
)
{
    MKCOMPAT(VAEncSliceParameterBuffer) * const dest = dest_buffer;
    const VAEncSliceParameterBuffer * const src = src_buffer;

    COPY_FIELD(dest, src, start_row_number);
    COPY_FIELD(dest, src, slice_height);
    dest->BFV(slice_flags, value) = 0; /* reset all bits */
    COPY_BIT_FIELD(dest, src, slice_flags, is_intra);
    COPY_BIT_FIELD(dest, src, slice_flags, disable_deblocking_filter_idc);

    return VA_STATUS_SUCCESS;
}
#endif

static void TRANSLATE_(VADriverContext)(
    VACompatContext *dest,
    const struct MKCOMPAT(VADriverContext) *src
)
{
    VACompatDriverVTable *dest_vtable = &dest->vtable;
    const struct MKCOMPAT(VADriverVTable) *src_vtable = &src->vtable;

    memset(dest_vtable, 0, sizeof(*dest_vtable));
    COPY_VTABLE(dest, src, vaTerminate);
    COPY_VTABLE(dest, src, vaQueryConfigProfiles);
    COPY_VTABLE(dest, src, vaQueryConfigEntrypoints);
    COPY_VTABLE(dest, src, vaGetConfigAttributes);
    COPY_VTABLE(dest, src, vaCreateConfig);
    COPY_VTABLE(dest, src, vaDestroyConfig);
    COPY_VTABLE(dest, src, vaQueryConfigAttributes);
    COPY_VTABLE(dest, src, vaCreateSurfaces);
    COPY_VTABLE(dest, src, vaDestroySurfaces);
    COPY_VTABLE(dest, src, vaCreateContext);
    COPY_VTABLE(dest, src, vaDestroyContext);
    COPY_VTABLE(dest, src, vaCreateBuffer);
    COPY_VTABLE(dest, src, vaBufferSetNumElements);
    COPY_VTABLE(dest, src, vaMapBuffer);
    COPY_VTABLE(dest, src, vaUnmapBuffer);
    COPY_VTABLE(dest, src, vaDestroyBuffer);
    COPY_VTABLE(dest, src, vaBeginPicture);
    COPY_VTABLE(dest, src, vaRenderPicture);
    COPY_VTABLE(dest, src, vaEndPicture);
    COPY_VTABLE(dest, src, vaQuerySurfaceStatus);
    COPY_VTABLE(dest, src, vaPutSurface);
    COPY_VTABLE(dest, src, vaQueryImageFormats);
    COPY_VTABLE(dest, src, vaCreateImage);
    COPY_VTABLE(dest, src, vaDeriveImage);
    COPY_VTABLE(dest, src, vaDestroyImage);
    COPY_VTABLE(dest, src, vaSetImagePalette);
    COPY_VTABLE(dest, src, vaGetImage);
    COPY_VTABLE(dest, src, vaQuerySubpictureFormats);
    COPY_VTABLE(dest, src, vaCreateSubpicture);
    COPY_VTABLE(dest, src, vaDestroySubpicture);
    COPY_VTABLE(dest, src, vaSetSubpictureImage);
    COPY_VTABLE(dest, src, vaSetSubpictureChromakey);
    COPY_VTABLE(dest, src, vaSetSubpictureGlobalAlpha);
    COPY_VTABLE(dest, src, vaDeassociateSubpicture);
    COPY_VTABLE(dest, src, vaQueryDisplayAttributes);
    COPY_VTABLE(dest, src, vaGetDisplayAttributes);
    COPY_VTABLE(dest, src, vaSetDisplayAttributes);
#if COMPAT_MAJOR == 0 && COMPAT_MINOR <= 29
    COPY_VTABLE(dest, src, vaSetSubpicturePalette);
    COPY_VTABLE(dest, src, vaDbgCopySurfaceToBuffer);
#endif
#if COMPAT_MAJOR == 0 && COMPAT_MINOR >= 30
    COPY_VTABLE(dest, src, vaCreateSurfaceFromCIFrame);
    COPY_VTABLE(dest, src, vaCreateSurfaceFromV4L2Buf);
    COPY_VTABLE(dest, src, vaCopySurfaceToBuffer);
#endif
#if COMPAT_MAJOR == 0 && COMPAT_MINOR >= 31
    COPY_VTABLE(dest, src, vaSyncSurface);
    COPY_VTABLE(dest, src, vaPutImage);
    COPY_VTABLE(dest, src, vaAssociateSubpicture);
#else
    COPY_VTABLE_(dest, pre31, src, vaSyncSurface);
    COPY_VTABLE_(dest, pre31, src, vaPutImage);
    COPY_VTABLE_(dest, pre31, src, vaPutImage2);
    COPY_VTABLE_(dest, pre31, src, vaAssociateSubpicture);
    COPY_VTABLE_(dest, pre31, src, vaAssociateSubpicture2);
#endif
}

#undef COMPAT_MAJOR
#undef COMPAT_MINOR
