/*
 * Copyright (C) 2010 Splitted-Desktop Systems. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include "va_crystalhd.h"

/* Checks if the Broadcom Crystal HD decoder is available */
int va_hasCrystalHD(void)
{
    char line[1024];
    int len, vendor, device, dummy, found = 0;
    FILE *fp;

    fp = fopen("/proc/bus/pci/devices", "r");
    if (!fp)
        return 0;

    while (!found && fgets(line, sizeof(line), fp)) {
        len = strlen(line);
        if (len == 0)
            continue;
        line[len - 1] = 0;
        if (sscanf(line, "%x %04x%04x", &dummy, &vendor, &device) == 3) {
            if (vendor == 0x14e4 && device == 0x1612) /* BCM70012 */
                found = 1;
        }
    }
    fclose(fp);
    return found;
}
