/*
 * Copyright (C) 2009 Splitted-Desktop Systems. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef LIBDRM_GLUE_H
#define LIBDRM_GLUE_H

#include "config.h"
#include <xf86drm.h>

int libdrm_open(void)
    ATTRIBUTE_HIDDEN;

void libdrm_close(void)
    ATTRIBUTE_HIDDEN;

int libdrm_drmAvailable(void)
    ATTRIBUTE_HIDDEN;

int libdrm_drmOpen(const char *name, const char *busid)
    ATTRIBUTE_HIDDEN;

int libdrm_drmClose(int fd)
    ATTRIBUTE_HIDDEN;

int libdrm_drmOpenOnce(void *unused, const char *BusID, int *newlyopened)
    ATTRIBUTE_HIDDEN;

void libdrm_drmCloseOnce(int fd)
    ATTRIBUTE_HIDDEN;

int libdrm_drmGetMagic(int fd, drm_magic_t * magic)
    ATTRIBUTE_HIDDEN;

int libdrm_drmSetInterfaceVersion(int fd, drmSetVersion *version)
    ATTRIBUTE_HIDDEN;

char *libdrm_drmGetBusid(int fd)
    ATTRIBUTE_HIDDEN;

void libdrm_drmFreeBusid(const char *busid)
    ATTRIBUTE_HIDDEN;

int libdrm_drmMap(int fd,
                  drm_handle_t handle,
                  drmSize size,
                  drmAddressPtr address)
    ATTRIBUTE_HIDDEN;

int libdrm_drmUnmap(drmAddress address, drmSize size)
    ATTRIBUTE_HIDDEN;

#endif /* LIBDRM_GLUE_H */
