/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file TextVisitor.h
    \brief Definition of the Template class TextNode.
    
    Magics Team - ECMWF 2007
    
    Started: Tue 6-Mar-2007
    
    Changes:
    
*/

#ifndef TextVisitor_H
#define TextVisitor_H

#include "magics.h"

#include "SceneVisitor.h"
#include "XmlBasicNodeAttributes.h"
#include "TextVisitorAttributes.h"
#include "TagHandler.h"

namespace magics {

class TextEntry {
public: 
    TextEntry(const string entry = "") : entry_(entry) {}
    ~TextEntry() {}
    string entry();
    string entry_;
    void add(const string& info ) {
        entry_ += info;
    }
};



class TextVisitor: public TextVisitorAttributes, 
	public TagHandler,
	public LayoutVisitor, 
	public BasicPositionalObject,
	public map<string, vector<TextEntry* > >
{

public:
	TextVisitor();
	virtual ~TextVisitor();
	
	TextVisitor* clone();
	void add(const string& line, TextEntry* entry);
	void add(TextEntry* entry) { add("<magics_title/>", entry); }
	
	
	void addToTags(const string&,  const string&);
			
    virtual void titles(vector<string>&);
	virtual Layout& layout() const { return LayoutVisitor::layout(); }
	virtual Layout* layoutPtr() const { return LayoutVisitor::layoutPtr(); }
	
	

    map<string, vector<Text*> > texts() { return currentTexts_; }
    void visit();
    void visit(BasicSceneObject&);
    void finish(BasicGraphicsObjectContainer&);
    void update(vector<Text*>&);
    void start();
    
    void visit(MetaDataVisitor&);
    bool positional() const { return positional_; } 
    virtual void getReady();

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
	
	 virtual void decode() {}
	 
	bool positional_;
	
	 static map<string, string> tags_;


    
    void set(const map<string, string>& map ) { TextVisitorAttributes::set(map); }
	void set(const XmlNode& node ) { TextVisitorAttributes::set(node); }
	string label_;
	mutable vector<Text*> texts_;
	mutable map<string, vector<Text*> > currentTexts_;
	VectorOfPointers<vector<TextEntry* > > currentLine_;
	
     
private:
    //! Copy constructor - No copy allowed
	TextVisitor(const TextVisitor&);
    //! Overloaded << operator to copy - No copy allowed
	TextVisitor& operator=(const TextVisitor&);


};

class XmlTextVisitor : public TextVisitor, public XmlBasicNodeAttributes
{
public:
	XmlTextVisitor();
	~XmlTextVisitor() {}
	void set(const XmlNode&);
	void getReady();
	void decode();
};

class FortranTextVisitor : public TextVisitor
{
public:
	FortranTextVisitor();
	~FortranTextVisitor() {}
protected:
    void decode();
	void interpret(string&, stringarray&);
};

class FortranAutomaticTextVisitor : public FortranTextVisitor
{
public:
	FortranAutomaticTextVisitor();
	~FortranAutomaticTextVisitor() {}
	void getReady();	
	
	 
};


class FortranPositionalTextVisitor : public FortranTextVisitor
{
public:
	FortranPositionalTextVisitor();
	~FortranPositionalTextVisitor() {}
	void getReady();	
};
/*
class MvTextVisitor : 
{
	MvTextVisitor();
	~MvTextVisitor()
		
}
*/
} // namespace magics
#endif
