/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file XmlRootNodeAttributes.h
    \brief Definition of XmlRootNode Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:57 2011
*/
   

#ifndef XmlRootNodeAttributes_H
#define XmlRootNodeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class XmlRootNodeAttributes 
{
public:
//  --  constructor
    XmlRootNodeAttributes();
    
//  --  destructor
    virtual ~XmlRootNodeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const XmlRootNodeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  paper format of super page ( a4/a3/a2 ) 
    \param format Setting root_node_format - default=a4
*/
	void setFormat(string format) 
		{ format_ =  format; } 
	string getFormat() const 
		{ return format_; } 
        
/*!
    Magics Information:
    \brief  paper orientation of super page ( landscape/portrait) 
    \param orientation Setting root_node_orientation - default=landscape
*/
	void setOrientation(string orientation) 
		{ orientation_ =  orientation; } 
	string getOrientation() const 
		{ return orientation_; } 
        
/*!
    Magics Information:
    \brief  Horizontal length of super page 
    \param width Setting root_node_width - default=-1
*/
	void setWidth(double width) 
		{ width_ =  width; } 
	double getWidth() const 
		{ return width_; } 
        
/*!
    Magics Information:
    \brief  Vertical length of super page 
    \param height Setting root_node_height - default=-1
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Frame on/off 
    \param border Setting root_node_frame - default=off
*/
	void setBorder(bool border) 
		{ border_ =  border; } 
	bool getBorder() const 
		{ return border_; } 
        
/*!
    Magics Information:
    \brief  Frame Colour 
    \param border_colour Setting root_node_frame_colour - default=blue
*/
	void setBorder_colour(Colour* border_colour) 
		{ auto_ptr<Colour> tmp(border_colour); border_colour_ = tmp; } 
	const Colour&  getBorder_colour() const 
		{ return *border_colour_; }
/*!
    Magics Information:
    \brief  Frame Line Style 
    \param border_style Setting root_node_frame_line_style - default=solid
*/
	void setBorder_style(LineStyle border_style) 
		{ border_style_ =  border_style; } 
	LineStyle getBorder_style() const 
		{ return border_style_; } 
        
/*!
    Magics Information:
    \brief  Frame thickness 
    \param border_thickness Setting root_node_frame_thickness - default=1
*/
	void setBorder_thickness(int border_thickness) 
		{ border_thickness_ =  border_thickness; } 
	int getBorder_thickness() const 
		{ return border_thickness_; } 
        
/*!
    Magics Information:
    \brief  magml/wrep : set specail behaviour for wrep project 
    \param application Setting root_node_application - default=magml
*/
	void setApplication(string application) 
		{ application_ =  application; } 
	string getApplication() const 
		{ return application_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string format_;
	string orientation_;
	double width_;
	double height_;
	bool border_;
	auto_ptr<Colour> border_colour_;
	LineStyle border_style_;
	int border_thickness_;
	string application_;

private:
  
	friend ostream& operator<<(ostream& s,const XmlRootNodeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
