/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BoxPlotWhiskerLineAttributes.cc
    \brief Implemtation of BoxPlotWhiskerLine Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Thu Jun 16 12:02:58 2011
*/    

#include "BoxPlotWhiskerLineAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


BoxPlotWhiskerLineAttributes::BoxPlotWhiskerLineAttributes():
	colour_(Translator<string, Colour>().magics("boxplot_whisker_line_colour")),
	thickness_(ParameterManager::getInt("boxplot_whisker_line_thickness")),
	style_(Translator<string, LineStyle>().magics("boxplot_whisker_line_style"))
{
} 



BoxPlotWhiskerLineAttributes::~BoxPlotWhiskerLineAttributes()
{
}

    
void BoxPlotWhiskerLineAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	prefix[0] = "boxplot_whisker_line";
	prefix[1] = "boxplot_whisker";
	prefix[2] = "boxplot";

	setAttribute(prefix, "boxplot_whisker_line_colour", colour_, params);
	setAttribute(prefix, "boxplot_whisker_line_thickness", thickness_, params);
	setAttribute(prefix, "boxplot_whisker_line_style", style_, params);
}

void BoxPlotWhiskerLineAttributes::copy(const BoxPlotWhiskerLineAttributes& other)
{
	setColour(other.colour_->clone());
	thickness_ = other.thickness_;
	style_ = other.style_;
} 


bool BoxPlotWhiskerLineAttributes::accept(const string& node)
{	
	if ( magCompare(node, "whisker_line")  )
		return true;
	return false;
}

void BoxPlotWhiskerLineAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "whisker_line") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void BoxPlotWhiskerLineAttributes::print(ostream& out)  const
{
	out << "BoxPlotWhiskerLineAttributes[";
	out << "colour = " << *colour_;
	out << ", thickness = " << thickness_;
	out << ", style = " << style_;
	out << "]" << "\n";
}


void BoxPlotWhiskerLineAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tboxplot_whisker_line_colour = \'" << *colour_ << "\'\n";
	out << tab << "\tboxplot_whisker_line_thickness = \'" << thickness_ << "\'\n";
	out << tab << "\tboxplot_whisker_line_style = \'" << style_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> boxplot_whisker_line_colour("boxplot_whisker_line_colour", "navy", "");
static MagicsParameter<int> boxplot_whisker_line_thickness("boxplot_whisker_line_thickness", 3, "");
static MagicsParameter<string> boxplot_whisker_line_style("boxplot_whisker_line_style", "solid", "");
