/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file CalculateColourTechniqueAttributes.h
    \brief Definition of CalculateColourTechnique Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:55 2011
*/
   

#ifndef CalculateColourTechniqueAttributes_H
#define CalculateColourTechniqueAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "ColourTableDefinitionComputeInterface.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class CalculateColourTechniqueAttributes : public ColourTableDefinitionComputeInterface
{
public:
//  --  constructor
    CalculateColourTechniqueAttributes();
    
//  --  destructor
    virtual ~CalculateColourTechniqueAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const CalculateColourTechniqueAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Highest shading band colour 
    \param max Setting contour_shade_max_level_colour - default=blue
*/
	void setMax(Colour* max) 
		{ auto_ptr<Colour> tmp(max); max_ = tmp; } 
	const Colour&  getMax() const 
		{ return *max_; }
/*!
    Magics Information:
    \brief  Lowest shading band colour 
    \param min Setting contour_shade_min_level_colour - default=red
*/
	void setMin(Colour* min) 
		{ auto_ptr<Colour> tmp(min); min_ = tmp; } 
	const Colour&  getMin() const 
		{ return *min_; }
/*!
    Magics Information:
    \brief  Direction of colour sequencing for shading (CLOCKWISE/ ANTI_CLOCKWISE) 
    \param direction Setting contour_shade_colour_direction - default=anti_clockwise
*/
	void setDirection(string direction) 
		{ direction_ =  direction; } 
	string getDirection() const 
		{ return direction_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<Colour> max_;
	auto_ptr<Colour> min_;
	string direction_;

private:
  
	friend ostream& operator<<(ostream& s,const CalculateColourTechniqueAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
