/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file DateAxis.h
    \brief Definition of the Template class DateAxis.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 7-Oct-2005
    
    Changes:
    
*/

#ifndef DateAxis_H
#define DateAxis_H

#include "magics.h"

#include "AxisMethod.h"
#include "DateAxisAttributes.h"

namespace magics {

class DateAxis: public AxisMethod, public DateAxisAttributes {

public:
	DateAxis();
	virtual ~DateAxis();
	
	void set(const map<string, string>& map) { DateAxisAttributes::set(map); }
	void set(const XmlNode& node)                  { DateAxisAttributes::set(node); update(); }
	
	virtual double getMin() const;
    virtual double getMax() const;
    
     
    void prepare(double, double, AxisItems&);
   
    void updateX(const Transformation&);
    void updateY(const Transformation&);

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
	 void update() const;
	 mutable DateTime from_;
	 mutable DateTime to_;
	 mutable DateTime base_;
	 
private:
    //! Copy constructor - No copy allowed
	DateAxis(const DateAxis&);
    //! Overloaded << operator to copy - No copy allowed
	DateAxis& operator=(const DateAxis&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const DateAxis& p)
		{ p.print(s); return s; }

};

class HyperAxis: public AxisMethod {

public:
	HyperAxis();
	virtual ~HyperAxis();
	
	void set(const map<string, string>& map) {  }
	void set(const XmlNode& node)                  { }
	
    void prepare(double, double, AxisItems&) const;
    void updateX(const Transformation&);
    void updateY(const Transformation&);

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
	 void update() const;
	
	 
private:
    //! Copy constructor - No copy allowed
	HyperAxis(const DateAxis&);
    //! Overloaded << operator to copy - No copy allowed
	HyperAxis& operator=(const DateAxis&);



};

} // namespace magics
#endif
