/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file SymbolAdvancedTableMode.cc
    \brief Definition of the Template class SymbolAdvancedTableMode.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 21-Jan-2004
    
    Changes:
    
*/

#ifndef SymbolAdvancedTableMode_H
#define SymbolAdvancedTableMode_H

#include "magics.h"

#include "SymbolMode.h"
#include "SymbolAdvancedTableModeAttributes.h"
#include "IntervalMap.h"

namespace magics {


class SymbolAdvancedTableMode: 
	public SymbolMode, 
	public SymbolAdvancedTableModeAttributes,
	public LevelSelectionInterface,
	public ColourTechniqueInterface,
	public HeightTechniqueInterface,
	public OutLayerTechniqueInterface
{

public:
	SymbolAdvancedTableMode();
	virtual ~SymbolAdvancedTableMode();
    virtual void prepare();
    
    bool accept(double) const;
    SymbolProperties operator()(double) const;
    void visit(Data<GeoPoint>&, HistoVisitor&);
    void visit(Data<UserPoint>&, HistoVisitor&);
    void set(const map<string, string>& map ) { 
        SymbolAdvancedTableModeAttributes::set(map); 
        prepare();
    }
    void set(const XmlNode& node ) { 
        SymbolAdvancedTableModeAttributes::set(node); 
        prepare();
    }
    
    /*
    bool top(const string& box, const SymbolProperties&, vector<Text* >& text) const;  
    bool bottom(const string& box, const SymbolProperties&, vector<Text* >& text) const;  
    bool right(const string& box, const SymbolProperties&,  vector<Text* >& text) const;   
    bool none(const string& box, const SymbolProperties&, vector<Text* >& text) const;
    bool centre(const string& box, const SymbolProperties&, vector<Text* >& text) const;
    */
    virtual bool accept(const string& node) {
    		return SymbolAdvancedTableModeAttributes::accept(node);    
    	}
    	
    	virtual SymbolMode* clone() const {
    		SymbolAdvancedTableMode* object = new SymbolAdvancedTableMode();
    		object->copy(*this);
    		return object;
    	}
    	virtual void adjust(double , double );
    
    		
        
 

      //  void operator()(const string& box, const UserPoint&, vector<Text* >&) const;
       // void operator()(const string& box, const GeoPoint&,  vector<Text* >&) const;
       
        void visit(LegendVisitor&);
        
       
        int getCount() const { return SymbolAdvancedTableModeAttributes::getCount(); }
        int getTolerance() const { return SymbolAdvancedTableModeAttributes::getTolerance(); }
        double getReference() const { return SymbolAdvancedTableModeAttributes::getReference(); }
        double getInterval() const { return SymbolAdvancedTableModeAttributes::getInterval(); }
        double getMin() const { return SymbolAdvancedTableModeAttributes::getMin(); }
        double getMax() const { return SymbolAdvancedTableModeAttributes::getMax(); }
        const Colour& getMinColour() const { return SymbolAdvancedTableModeAttributes::getMinColour(); }
        const Colour& getMaxColour() const { return SymbolAdvancedTableModeAttributes::getMaxColour(); }
        string getDirection() const { return SymbolAdvancedTableModeAttributes::getDirection(); }
        stringarray getColours()  const { return SymbolAdvancedTableModeAttributes::getColours(); }
        floatarray getList()  const { return SymbolAdvancedTableModeAttributes::getList(); }
        double getMinHeight() const { return SymbolAdvancedTableModeAttributes::getHeight_min(); }
        double getMaxHeight() const { return SymbolAdvancedTableModeAttributes::getHeight_max(); }
        floatarray getHeights()  const { return SymbolAdvancedTableModeAttributes::getHeights(); }
        ListPolicy getHeightPolicy() const { return SymbolAdvancedTableModeAttributes::getHeight_policy(); }
        int getLevels()  const { return nbLevels_; }
        float getMinOutlayer() const { return SymbolAdvancedTableModeAttributes::getOutlayer_min(); }
        float getMaxOutlayer() const { return SymbolAdvancedTableModeAttributes::getOutlayer_max(); }

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
     IntervalMap<SymbolProperties>  map_;
     int nbLevels_;
    
    
     typedef  bool (SymbolAdvancedTableMode::*TextHandler)(const string&, const SymbolProperties&, vector<Text* >& text) const;   
     static map<string,  TextHandler> textHandlers_;
     
private:
    //! Copy constructor - No copy allowed
	SymbolAdvancedTableMode(const SymbolAdvancedTableMode&);
    //! Overloaded << operator to copy - No copy allowed
	SymbolAdvancedTableMode& operator=(const SymbolAdvancedTableMode&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const SymbolAdvancedTableMode& p)
		{ p.print(s); return s; }

};

} // namespace magics
#endif
