/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ContourAttributes.h
    \brief Definition of Contour Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:37 2011
*/
   

#ifndef ContourAttributes_H
#define ContourAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "ValuePlotBase.h"
#include "ContourMethod.h"
#include "IsoPlot.h"
#include "HiLoBase.h"

namespace magics {

class XmlNode;


template <class P>
class ContourAttributes 
{
public:
//  --  constructor
    ContourAttributes();
    
//  --  destructor
    virtual ~ContourAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const ContourAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Turn legend on or off (ON/OFF)
    \param legend Setting legend - default=off
*/
	void setLegend(bool legend) 
		{ legend_ =  legend; } 
	bool getLegend() const 
		{ return legend_; } 
        
/*!
    Magics Information:
    \brief  Turn contouring on or off (ON/OFF) 
    \param contour Setting contour - default=on
*/
	void setContour(IsoPlot<P> * contour) 
		{ auto_ptr<IsoPlot<P> > tmp(contour); contour_ = tmp; } 
	const IsoPlot<P> &  getContour() const 
		{ return *contour_; }
/*!
    Magics Information:
    \brief  Contouring method (automatic/linear/sample/akima760/akima474) 
    \param method Setting contour_method - default=automatic
*/
	void setMethod(ContourMethod<P> * method) 
		{ auto_ptr<ContourMethod<P> > tmp(method); method_ = tmp; } 
	const ContourMethod<P> &  getMethod() const 
		{ return *method_; }
/*!
    Magics Information:
    \brief Any value below this floor will be forced  to the floor value.
		avoid the bubbles artificially created by the interpolation method
    \param floor Setting contour_interpolation_floor - default=-INT_MAX
*/
	void setFloor(double floor) 
		{ floor_ =  floor; } 
	double getFloor() const 
		{ return floor_; } 
        
/*!
    Magics Information:
    \brief  any value above this ceiling will be forced  to the ceiling value.
		avoid the bubbles artificially created by the interpolation method 
    \param ceiling Setting contour_interpolation_ceiling - default=INT_MAX
*/
	void setCeiling(double ceiling) 
		{ ceiling_ =  ceiling; } 
	double getCeiling() const 
		{ return ceiling_; } 
        
/*!
    Magics Information:
    \brief  Turn the automatic seeting of contouring attributes (ON/OFF) 
    \param setting Setting contour_automatic_setting - default=off
*/
	void setSetting(bool setting) 
		{ setting_ =  setting; } 
	bool getSetting() const 
		{ return setting_; } 
        
/*!
    Magics Information:
    \brief  Users can give their own file to setup the automatic library of contours 
    \param library_path Setting contour_automatic_library_path - default=
*/
	void setLibrary_path(const string& library_path) 
		{ library_path_ =  library_path; } 
	const string& getLibrary_path() const 
		{ return library_path_; } 
        
/*!
    Magics Information:
    \brief  Plot local maxima/minima (ON/OFF/HI/LO) 
    \param hilo Setting contour_hilo - default=off
*/
	void setHilo(HiLoBase<P> * hilo) 
		{ auto_ptr<HiLoBase<P> > tmp(hilo); hilo_ = tmp; } 
	const HiLoBase<P> &  getHilo() const 
		{ return *hilo_; }
/*!
    Magics Information:
    \brief  Plot Grid point values (ON/OFF) 
    \param grid Setting contour_grid_value_plot - default=off
*/
	void setGrid(ValuePlotBase<P> * grid) 
		{ auto_ptr<ValuePlotBase<P> > tmp(grid); grid_ = tmp; } 
	const ValuePlotBase<P> &  getGrid() const 
		{ return *grid_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	bool legend_;
	auto_ptr<IsoPlot<P> > contour_;
	auto_ptr<ContourMethod<P> > method_;
	double floor_;
	double ceiling_;
	bool setting_;
	string library_path_;
	auto_ptr<HiLoBase<P> > hilo_;
	auto_ptr<ValuePlotBase<P> > grid_;

private:
  
	friend ostream& operator<<(ostream& s,const ContourAttributes<P>& p)
	{ p.print(s); return s; }
};

} // namespace magics
#include "ContourAttributes.cc" 

#endif
