/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file HatchPolyShadingMethod.h
    \brief Definition of the Template class HatchPolyShadingMethod.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 25-Aug-2004
    
    Changes:
    
*/

#ifndef HatchPolyShadingMethod_H
#define HatchPolyShadingMethod_H

#include "magics.h"

#include "PolyShadingMethod.h"
#include "HatchPolyShadingMethodAttributes.h"
#include "IntervalMap.h"

namespace magics {

template <class P>
class HatchPolyShadingMethod: public PolyShadingMethod<P>, public HatchPolyShadingMethodAttributes {

public:
	HatchPolyShadingMethod() {}
	virtual ~HatchPolyShadingMethod() {}
	
	
    
    virtual void set(const map<string, string>& map) { HatchPolyShadingMethodAttributes::set(map); }
    virtual void set(const XmlNode& node) { HatchPolyShadingMethodAttributes::set(node); }
    virtual bool accept(const string& node) { return HatchPolyShadingMethodAttributes::accept(node); }
    virtual PolyShadingMethod<P>* clone() const {
		HatchPolyShadingMethod<P>* object = new HatchPolyShadingMethod<P>();
		object->copy(*this);
		return object;
	}

    virtual void prepare(const LevelSelection& levels) { 
    	int index = 1;
    	if (index_ >= 7 || index_ <0) {
    		MagLog::warning() << "index should be < 7--> reset to 1 "<< endl;
    		index_ = 1 ;
    	}
    	LevelSelection::const_iterator from = levels.begin();
    	LevelSelection::const_iterator level = levels.begin();
    	level++;
    	for (  ;  level != levels.end(); ++level) {
    		indexes_.insert(make_pair(Interval(*from, *level), (index_) ? index_ : index)); 		
    		index++;
    		from++;
    		if ( index == 7 ) index = 1;
    	}
    }
    virtual void operator()(Polyline& poly, const ColourTechnique&) const { 
        float value = poly.front().value(); 
        
        HatchShadingProperties* shading = new HatchShadingProperties();
    
        
        shading->index_     = indexes_.find(value, 1);
        
        MagLog::dev() << "index for " << value << "--->" << shading->index_ << "\n";
        shading->density_   = density_;
        shading->thickness_ = thickness_;
        poly.setFilled(true);
        poly.setStroke(false);
        poly.setShading(shading);
         MagLog::dev() << "Attach HatchShading Information : "  << value << "--->" << *shading << "\n";
    };
    virtual void operator()(Polyline& poly, double value, const ColourTechnique& ) const { 
   
        HatchShadingProperties* shading = new HatchShadingProperties();            
         poly.setFilled(true);
         shading->index_     = indexes_.find(value, 1);
        shading->density_   = density_;
        shading->thickness_ = thickness_;
        poly.setStroke(false);
        if (!value)  poly.setShading(new FillShadingProperties());
        poly.setShading(shading);
         //MagLog::dev() << "Attach HatchShading Information--->" << *shading << "\n";
    };
protected:  
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const {} 
	 IntervalMap<int> indexes_;
private:
    //! Copy constructor - No copy allowed
	HatchPolyShadingMethod(const HatchPolyShadingMethod&);
    //! Overloaded << operator to copy - No copy allowed
	HatchPolyShadingMethod& operator=(const HatchPolyShadingMethod&);
    
// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const HatchPolyShadingMethod<P>& p)
		{ p.print(s); return s; }

};

} // namespace magics

#endif
