/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GenericSQLDecoder.h
    \brief Definition of the Template class GenericSQLDecoder.
    
    Magics Team - ECMWF 2004
    
    Started: Fri 16-Jan-2004
    
    Changes:
    
*/

#ifndef GenericSQLDecoder_H
#define GenericSQLDecoder_H

#include "magics.h"

#include "GenericSQLDecoderAttributes.h"
#include "Decoder.h"
#include "Data.h"
#include "GeoPoint.h"


#include "odb.h"

namespace magics {

class GenericSQLException : public MagicsException
{
public:
	 GenericSQLException( const string& why ):
		MagicsException("GenericSQL Exception :  " + why ) {}
};  

class GenericSQLDecoder: public GenericSQLDecoderAttributes, 
                  public Decoder
{

public:
	GenericSQLDecoder();
	virtual ~GenericSQLDecoder();
    
    //! Decoder interface
    virtual void prepare();
    virtual void set(const map<string, string>& map ) { GenericSQLDecoderAttributes::set(map); }
    

   
 
    
   

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

     odb_stm* sql_;
     map<string, int> columns_;
     bool more_;

private:
    //! Copy constructor - No copy allowed
	GenericSQLDecoder(const GenericSQLDecoder&);
    //! Overloaded << operator to copy - No copy allowed
	GenericSQLDecoder& operator=(const GenericSQLDecoder&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const GenericSQLDecoder& p)
		{ p.print(s); return s; }

};

} // namespace magics

#endif
